/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.bo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerAware;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.krad.bo.BusinessObjectBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObjectExtension;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.PersistenceService;
import org.kuali.rice.krad.service.PersistenceStructureService;

@MappedSuperclass
public abstract class PersistableBusinessObjectBase
extends BusinessObjectBase
implements PersistableBusinessObject,
PersistenceBrokerAware,
Versioned,
GloballyUnique {
    private static final long serialVersionUID = 1451642350593233282L;
    private static final Logger LOG = Logger.getLogger(PersistableBusinessObjectBase.class);
    @Version
    @Column(name="VER_NBR")
    protected Long versionNumber;
    @Column(name="OBJ_ID")
    private String objectId;
    @Transient
    private boolean newCollectionRecord;
    @Transient
    protected PersistableBusinessObjectExtension extension;
    private static transient PersistenceService persistenceService;
    private static transient PersistenceStructureService persistenceStructureService;

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    @Override
    public void setVersionNumber(Long versionNumber) {
        this.versionNumber = versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    @Override
    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    @Override
    public boolean isNewCollectionRecord() {
        return this.newCollectionRecord;
    }

    @Override
    public void setNewCollectionRecord(boolean isNewCollectionRecord) {
        this.newCollectionRecord = isNewCollectionRecord;
    }

    public final void afterDelete(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        this.postRemove();
    }

    @PostRemove
    protected void postRemove() {
    }

    public final void afterInsert(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        this.postPersist();
    }

    @PostPersist
    protected void postPersist() {
    }

    public final void afterLookup(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        this.postLoad();
    }

    @PostLoad
    protected void postLoad() {
    }

    public final void afterUpdate(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        this.postUpdate();
    }

    @PostUpdate
    protected void postUpdate() {
    }

    public final void beforeDelete(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        this.preRemove();
    }

    @PreRemove
    protected void preRemove() {
    }

    public final void beforeInsert(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        this.setObjectId(null);
        this.prePersist();
    }

    @PrePersist
    protected void prePersist() {
        this.generateAndSetObjectIdIfNeeded();
    }

    public final void beforeUpdate(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        this.preUpdate();
    }

    @PreUpdate
    protected void preUpdate() {
        this.generateAndSetObjectIdIfNeeded();
    }

    private void generateAndSetObjectIdIfNeeded() {
        if (StringUtils.isEmpty((String)this.getObjectId())) {
            this.setObjectId(UUID.randomUUID().toString());
        }
    }

    public void refresh() {
        PersistableBusinessObjectBase.getPersistenceService().retrieveNonKeyFields(this);
    }

    @Override
    public void refreshNonUpdateableReferences() {
        PersistableBusinessObjectBase.getPersistenceService().refreshAllNonUpdatingReferences(this);
    }

    @Override
    public void refreshReferenceObject(String referenceObjectName) {
        if (StringUtils.isNotBlank((String)referenceObjectName) && !StringUtils.equals((String)referenceObjectName, (String)"extension")) {
            PersistenceStructureService pss = PersistableBusinessObjectBase.getPersistenceStructureService();
            if (pss.hasReference(this.getClass(), referenceObjectName) || pss.hasCollection(this.getClass(), referenceObjectName)) {
                PersistableBusinessObjectBase.getPersistenceService().retrieveReferenceObject(this, referenceObjectName);
            } else {
                LOG.warn((Object)("refreshReferenceObject() called with non-reference property: " + referenceObjectName));
            }
        }
    }

    @Override
    public List<Collection<PersistableBusinessObject>> buildListOfDeletionAwareLists() {
        return new ArrayList<Collection<PersistableBusinessObject>>();
    }

    @Override
    public void linkEditableUserFields() {
    }

    @Override
    public PersistableBusinessObjectExtension getExtension() {
        if (this.extension == null && PersistableBusinessObjectBase.getPersistenceStructureService().isPersistable(this.getClass())) {
            try {
                Class<? extends PersistableBusinessObjectExtension> extensionClass = PersistableBusinessObjectBase.getPersistenceStructureService().getBusinessObjectAttributeClass(this.getClass(), "extension");
                if (extensionClass != null) {
                    this.extension = extensionClass.newInstance();
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"unable to create extension object", (Throwable)ex);
            }
        }
        return this.extension;
    }

    @Override
    public void setExtension(PersistableBusinessObjectExtension extension) {
        this.extension = extension;
    }

    protected static PersistenceService getPersistenceService() {
        if (persistenceService == null) {
            persistenceService = KRADServiceLocator.getPersistenceService();
        }
        return persistenceService;
    }

    protected static PersistenceStructureService getPersistenceStructureService() {
        if (persistenceStructureService == null) {
            persistenceStructureService = KRADServiceLocator.getPersistenceStructureService();
        }
        return persistenceStructureService;
    }
}

