/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.keyvalues;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.WordUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;

public class EnumValuesFinder
extends KeyValuesBase {
    private Class<? extends Enum> enumeration;

    public EnumValuesFinder(Class<? extends Enum> enumeration) {
        this.enumeration = enumeration;
    }

    @Override
    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> labels = new ArrayList<KeyValue>();
        for (Enum enumval : this.enumeration.getEnumConstants()) {
            labels.add((KeyValue)new ConcreteKeyValue(this.getEnumKey(enumval), this.getEnumLabel(enumval)));
        }
        return labels;
    }

    protected String getEnumKey(Enum enm) {
        return enm.name();
    }

    protected String getEnumLabel(Enum enm) {
        return WordUtils.capitalize((String)enm.name().toLowerCase());
    }
}

