/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.util.SessionTicket;

public class UserSession
implements Serializable {
    private static final long serialVersionUID = 4532616762540067557L;
    private Person person;
    private Person backdoorUser;
    private AtomicInteger nextObjectKey;
    private Map<String, Object> objectMap;
    private String kualiSessionId;

    public String getKualiSessionId() {
        return this.kualiSessionId;
    }

    public void setKualiSessionId(String kualiSessionId) {
        this.kualiSessionId = kualiSessionId;
    }

    public UserSession(String principalName) {
        this.initPerson(principalName);
        this.nextObjectKey = new AtomicInteger(0);
        this.objectMap = Collections.synchronizedMap(new HashMap());
    }

    protected void initPerson(String principalName) {
        this.person = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(principalName);
        if (this.person == null) {
            throw new IllegalArgumentException("Failed to locate a principal with principal name '" + principalName + "'");
        }
    }

    public String getPrincipalId() {
        if (this.backdoorUser != null) {
            return this.backdoorUser.getPrincipalId();
        }
        return this.person.getPrincipalId();
    }

    public String getPrincipalName() {
        if (this.backdoorUser != null) {
            return this.backdoorUser.getPrincipalName();
        }
        return this.person.getPrincipalName();
    }

    public String getLoggedInUserPrincipalName() {
        if (this.person != null) {
            return this.person.getPrincipalName();
        }
        return "";
    }

    public Person getPerson() {
        if (this.backdoorUser != null) {
            return this.backdoorUser;
        }
        return this.person;
    }

    public Person getActualPerson() {
        return this.person;
    }

    public void setBackdoorUser(String principalName) {
        if (!this.isProductionEnvironment()) {
            this.backdoorUser = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(principalName);
        }
    }

    private boolean isProductionEnvironment() {
        return ConfigContext.getCurrentContextConfig().isProductionEnvironment();
    }

    public void clearBackdoorUser() {
        this.backdoorUser = null;
    }

    public String addObjectWithGeneratedKey(Serializable object, String keyPrefix) {
        String objectKey = keyPrefix + this.nextObjectKey.incrementAndGet();
        this.objectMap.put(objectKey, object);
        return objectKey;
    }

    public String addObjectWithGeneratedKey(Object object) {
        String objectKey = this.nextObjectKey.incrementAndGet() + "";
        this.objectMap.put(objectKey, object);
        return objectKey;
    }

    public void addObject(String key, Object object) {
        this.objectMap.put(key, object);
    }

    public Object retrieveObject(String objectKey) {
        return this.objectMap.get(objectKey);
    }

    public void removeObject(String objectKey) {
        this.objectMap.remove(objectKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObjectsByPrefix(String objectKeyPrefix) {
        Map<String, Object> map = this.objectMap;
        synchronized (map) {
            ArrayList<String> removeKeys = new ArrayList<String>();
            for (String key : this.objectMap.keySet()) {
                if (!key.startsWith(objectKeyPrefix)) continue;
                removeKeys.add(key);
            }
            for (String key : removeKeys) {
                this.objectMap.remove(key);
            }
        }
    }

    public boolean isBackdoorInUse() {
        return this.backdoorUser != null;
    }

    public String putSessionTicket(SessionTicket ticket) {
        return this.addObjectWithGeneratedKey(ticket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SessionTicket> getAllSessionTickets() {
        ArrayList<SessionTicket> sessionTickets = new ArrayList<SessionTicket>();
        Map<String, Object> map = this.objectMap;
        synchronized (map) {
            for (Object object : this.objectMap.values()) {
                if (!(object instanceof SessionTicket)) continue;
                sessionTickets.add((SessionTicket)object);
            }
        }
        return sessionTickets;
    }

    public List<SessionTicket> getAllSessionTicketsByType(String ticketTypeName) {
        ArrayList<SessionTicket> sessionTickets = new ArrayList<SessionTicket>();
        for (SessionTicket ticket : this.getAllSessionTickets()) {
            if (!StringUtils.equalsIgnoreCase((String)ticket.getTicketTypeName(), (String)ticketTypeName)) continue;
            sessionTickets.add(ticket);
        }
        return sessionTickets;
    }

    public boolean hasMatchingSessionTicket(String ticketTypeName, Map<String, String> matchContext) {
        boolean hasTicket = false;
        for (SessionTicket ticket : this.getAllSessionTicketsByType(ticketTypeName)) {
            Map<String, String> ticketContext = ticket.getTicketContext();
            boolean keySetMatch = ((Object)ticketContext.keySet()).equals(matchContext.keySet());
            if (!keySetMatch) continue;
            boolean valuesMatch = true;
            for (String contextKey : ticketContext.keySet()) {
                String matchValue;
                String ticketValue = ticketContext.get(contextKey);
                if (StringUtils.equalsIgnoreCase((String)ticketValue, (String)(matchValue = matchContext.get(contextKey)))) continue;
                valuesMatch = false;
            }
            if (!valuesMatch) continue;
            hasTicket = true;
            break;
        }
        return hasTicket;
    }

    public Map<String, Object> getObjectMap() {
        return Collections.unmodifiableMap(this.objectMap);
    }

    public void clearObjectMap() {
        this.objectMap = Collections.synchronizedMap(new HashMap());
    }
}

