/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.UserSession;

public final class UserSessionUtils {
    private UserSessionUtils() {
        throw new IllegalStateException("this class should not be instantiated");
    }

    public static void addWorkflowDocument(UserSession userSession, WorkflowDocument workflowDocument) {
        Map<String, WorkflowDocument> workflowDocMap = UserSessionUtils.getWorkflowDocumentMap(userSession);
        workflowDocMap.put(workflowDocument.getDocumentId(), workflowDocument);
    }

    public static WorkflowDocument getWorkflowDocument(UserSession userSession, String workflowDocumentId) {
        Map<String, WorkflowDocument> workflowDocMap = UserSessionUtils.getWorkflowDocumentMap(userSession);
        return workflowDocMap.get(workflowDocumentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, WorkflowDocument> getWorkflowDocumentMap(UserSession userSession) {
        UserSession userSession2 = userSession;
        synchronized (userSession2) {
            ConcurrentHashMap<String, WorkflowDocument> workflowDocMap = (ConcurrentHashMap<String, WorkflowDocument>)userSession.retrieveObject("workflowDocumentMap");
            if (workflowDocMap == null) {
                workflowDocMap = new ConcurrentHashMap<String, WorkflowDocument>();
                userSession.addObject("workflowDocumentMap", workflowDocMap);
            }
            return workflowDocMap;
        }
    }
}

