/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.document.authorization;

import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;

@Entity
@Table(name="KRNS_PESSIMISTIC_LOCK_T")
public class PessimisticLock
extends PersistableBusinessObjectBase {
    private static final long serialVersionUID = -5210762282545093555L;
    public static final String DEFAULT_LOCK_DESCRIPTOR = null;
    @Id
    @GeneratedValue(generator="KRNS_LOCK_S")
    @GenericGenerator(name="KRNS_LOCK_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KRNS_LOCK_S"), @Parameter(name="value_column", value="id")})
    @Column(name="PESSIMISTIC_LOCK_ID")
    private Long id;
    @Column(name="PRNCPL_ID")
    private String ownedByPrincipalIdentifier;
    @Column(name="LOCK_DESC_TXT")
    private String lockDescriptor;
    @Column(name="GNRT_DT")
    private Timestamp generatedTimestamp;
    @Column(name="DOC_HDR_ID")
    private String documentNumber;
    @Column(name="SESN_ID")
    private String sessionId;
    @Transient
    private Person ownedByUser;

    @Deprecated
    public PessimisticLock() {
    }

    public PessimisticLock(String documentNumber, String lockDescriptor, Person user, UserSession userSession) {
        this.documentNumber = documentNumber;
        this.ownedByPrincipalIdentifier = user.getPrincipalId();
        this.lockDescriptor = lockDescriptor;
        this.generatedTimestamp = CoreApiServiceLocator.getDateTimeService().getCurrentTimestamp();
        this.sessionId = userSession.getKualiSessionId();
    }

    public boolean isOwnedByUser(Person user) {
        return user.getPrincipalId().equals(this.getOwnedByPrincipalIdentifier());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOwnedByPrincipalIdentifier() {
        return this.ownedByPrincipalIdentifier;
    }

    public void setOwnedByPrincipalIdentifier(String ownedByPrincipalIdentifier) {
        this.ownedByPrincipalIdentifier = ownedByPrincipalIdentifier;
    }

    public String getLockDescriptor() {
        return this.lockDescriptor;
    }

    public void setLockDescriptor(String lockDescriptor) {
        this.lockDescriptor = lockDescriptor;
    }

    public Timestamp getGeneratedTimestamp() {
        return this.generatedTimestamp;
    }

    public void setGeneratedTimestamp(Timestamp generatedTimestamp) {
        this.generatedTimestamp = generatedTimestamp;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public Person getOwnedByUser() {
        this.ownedByUser = KimApiServiceLocator.getPersonService().updatePersonIfNecessary(this.ownedByPrincipalIdentifier, this.ownedByUser);
        return this.ownedByUser;
    }

    public void setOwnedByUser(Person ownedByUser) {
        this.ownedByUser = ownedByUser;
    }
}

