/**
 * Copyright 2005-2017 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.rice.krad.util;

import org.kuali.rice.core.api.mo.common.Coded;

/**
 * Defines the different types of Notes which can be used with the notes
 * and attachments framework. 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public enum NoteType implements Coded {
    
	BUSINESS_OBJECT("BO"), DOCUMENT_HEADER("DH");
    
	private final String noteTypeCode;

    private NoteType(String noteTypeCode) {
        this.noteTypeCode = noteTypeCode;
    }

    @Override
    public String getCode() {
        return this.noteTypeCode;
    }

}