/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.util.Truth;
import org.kuali.rice.core.api.util.type.TypeUtils;
import org.kuali.rice.krad.data.jpa.QueryByCriteria;

@Deprecated
class Criteria {
    private static final Logger LOG = Logger.getLogger(Criteria.class);
    private static final Pattern APOS_PAT = Pattern.compile("'");
    private static final String[] LOOKUP_WILDCARDS = new String[]{"*", "?"};
    private static final String[] ESCAPED_LOOKUP_WILDCARDS = new String[]{"\\*", "\\?"};
    private static final char[] JPQL_WILDCARDS = new char[]{'%', '_'};
    public static final String JPA_ALIAS_PREFIX = "__JPA_ALIAS[[";
    public static final String JPA_PARAM_PREFIX = "__JPA_PARAM[[";
    public static final String JPA_ALIAS_SUFFIX = "]]__";
    private static final String JPA_INITIAL_ALIAS = "__JPA_ALIAS[[0]]__";
    private static final String JPA_PARENT_INITIAL_ALIAS = "__JPA_ALIAS[[-1]]__";
    private static final String JPA_PARAM_PREFIX_WITH_COLON = ":__JPA_PARAM[[";
    private static final int ALIAS_PREFIX_LEN = "__JPA_ALIAS[[".length();
    private static final int PARAM_PREFIX_LEN = "__JPA_PARAM[[".length();
    private static final int ALIAS_SUFFIX_LEN = "]]__".length();
    private Integer searchLimit;
    private int generatedAliasCount;
    private int generatedBindParamCount;
    private boolean distinct = false;
    private final List<String> entityAliases = new ArrayList<String>();
    private final List<String> indexedAliasPlaceholders = new ArrayList<String>();
    private final List<String> namedAliasPlaceholders = new ArrayList<String>();
    private final Map<String, Integer> aliasIndexes = new HashMap<String, Integer>();
    private final StringBuilder selectClause = new StringBuilder();
    private final StringBuilder fromClause = new StringBuilder();
    private final StringBuilder whereClause = new StringBuilder(50);
    private final StringBuilder groupByClause = new StringBuilder();
    private final StringBuilder havingClause = new StringBuilder();
    private final StringBuilder orderByClause = new StringBuilder();
    private final StringBuilder setClause = new StringBuilder();
    private final String initialEntityName;
    protected Map<String, Object> params = new LinkedHashMap<String, Object>();

    Criteria(String entityName) {
        this(entityName, "a", true);
    }

    Criteria(String entityName, String alias) {
        this(entityName, alias, true);
    }

    Criteria(String entityName, boolean includeEntityInSelect) {
        this(entityName, "a", includeEntityInSelect);
    }

    Criteria(String entityName, String alias, boolean includeEntityAliasInSelect) {
        this.initialEntityName = entityName;
        this.from(entityName, alias, includeEntityAliasInSelect);
    }

    private String addAlias(String alias) {
        if (alias == null) {
            alias = "a" + this.generatedAliasCount++;
        }
        while (this.aliasIndexes.containsKey(alias)) {
            alias = "a" + this.generatedAliasCount++;
        }
        this.entityAliases.add(alias);
        this.aliasIndexes.put(alias, this.entityAliases.size() - 1);
        this.indexedAliasPlaceholders.add(new StringBuilder(30).append(JPA_ALIAS_PREFIX).append(this.indexedAliasPlaceholders.size()).append(JPA_ALIAS_SUFFIX).toString());
        this.namedAliasPlaceholders.add(new StringBuilder(30).append(JPA_ALIAS_PREFIX).append('\'').append(alias).append('\'').append(JPA_ALIAS_SUFFIX).toString());
        return alias;
    }

    public void select(String resultExpression) {
        if (resultExpression.contains(JPA_ALIAS_PREFIX)) {
            this.selectClause.append(this.selectClause.length() > 0 ? ", " : "").append(resultExpression);
        } else {
            this.selectClause.append(this.selectClause.length() > 0 ? ", " : "").append(JPA_INITIAL_ALIAS).append('.').append(resultExpression);
        }
    }

    public String from(String entityName, String alias, boolean includeEntityAliasInSelect) {
        alias = this.addAlias(alias);
        if (includeEntityAliasInSelect) {
            this.select(this.namedAliasPlaceholders.get(this.namedAliasPlaceholders.size() - 1));
        }
        this.fromClause.append(this.fromClause.length() > 0 ? ", " : " FROM ").append(entityName).append(" AS ").append(this.namedAliasPlaceholders.get(this.namedAliasPlaceholders.size() - 1));
        return alias;
    }

    public String fromIn(String collectionName, String alias, boolean includeCollectionAliasInSelect) {
        alias = this.addAlias(alias);
        if (includeCollectionAliasInSelect) {
            this.select(this.namedAliasPlaceholders.get(this.namedAliasPlaceholders.size() - 1));
        }
        if (collectionName.contains(JPA_ALIAS_PREFIX)) {
            this.fromClause.append(", IN (").append(collectionName).append(") ").append(this.namedAliasPlaceholders.get(this.namedAliasPlaceholders.size() - 1));
        } else {
            this.fromClause.append(", IN (").append(JPA_INITIAL_ALIAS).append('.').append(collectionName).append(") ").append(this.namedAliasPlaceholders.get(this.namedAliasPlaceholders.size() - 1));
        }
        return alias;
    }

    public String join(String associationName, String alias, boolean includeAssociationAliasInSelect, boolean innerJoin) {
        alias = this.addAlias(alias);
        if (includeAssociationAliasInSelect) {
            this.select(this.namedAliasPlaceholders.get(this.namedAliasPlaceholders.size() - 1));
        }
        if (associationName.contains(JPA_ALIAS_PREFIX)) {
            this.fromClause.append(innerJoin ? " INNER JOIN " : " LEFT JOIN ").append(associationName).append(" AS ").append(this.namedAliasPlaceholders.get(this.namedAliasPlaceholders.size() - 1));
        } else {
            this.fromClause.append(innerJoin ? " INNER JOIN " : " LEFT JOIN ").append(JPA_INITIAL_ALIAS).append('.').append(associationName).append(" AS ").append(this.namedAliasPlaceholders.get(this.namedAliasPlaceholders.size() - 1));
        }
        return alias;
    }

    public void joinFetch(String associationName, boolean innerJoin) {
        if (associationName.contains(JPA_ALIAS_PREFIX)) {
            this.fromClause.append(innerJoin ? " INNER JOIN FETCH " : " LEFT JOIN FETCH ").append(associationName);
        } else {
            this.fromClause.append(innerJoin ? " INNER JOIN FETCH " : " LEFT JOIN FETCH ").append(JPA_INITIAL_ALIAS).append('.').append(associationName);
        }
    }

    public void set(String attributeName, Object value) {
        this.setClause.append(this.setClause.length() > 0 ? ", " : " SET ").append(JPA_INITIAL_ALIAS).append('.').append(attributeName).append(" = ").append(this.addAttr(this.fixPeriods(attributeName), value));
    }

    public void set(Map<String, Object> attributes) {
        for (Map.Entry<String, Object> attribute : attributes.entrySet()) {
            this.setClause.append(this.setClause.length() > 0 ? ", " : " SET ").append(JPA_INITIAL_ALIAS).append('.').append(attribute.getKey()).append(" = ").append(this.addAttr(this.fixPeriods(attribute.getKey()), attribute.getValue()));
        }
    }

    private void fixValue(StringBuilder queryClause, Object value) {
        if (value == null) {
            return;
        }
        Class<?> propertyType = value.getClass();
        if (TypeUtils.isIntegralClass(propertyType) || TypeUtils.isDecimalClass(propertyType)) {
            queryClause.append(value.toString());
        } else if (TypeUtils.isStringClass(propertyType)) {
            queryClause.append('\'').append(this.fixSingleQuotes(value.toString())).append('\'');
        } else if (TypeUtils.isBooleanClass(propertyType)) {
            queryClause.append(value.toString());
        } else if (value instanceof Class) {
            queryClause.append(((Class)value).getName());
        } else {
            queryClause.append(this.addAttr("bind_param" + ++this.generatedBindParamCount, value));
        }
    }

    private String fixSingleQuotes(String value) {
        return APOS_PAT.matcher(value).replaceAll("''");
    }

    private String fixPeriods(String value) {
        return value.replace('.', '_');
    }

    private String fixSearchPattern(String value) {
        StringBuilder fixedPattern = new StringBuilder(value);
        int valueLen = value.length();
        for (int i = 0; i < LOOKUP_WILDCARDS.length; ++i) {
            String lookupWildcard = LOOKUP_WILDCARDS[i];
            String escapedLookupWildcard = ESCAPED_LOOKUP_WILDCARDS[i];
            char jpqlWildcard = JPQL_WILDCARDS[i];
            int wildcardIndex = fixedPattern.indexOf(lookupWildcard);
            int escapedWildcardIndex = fixedPattern.indexOf(escapedLookupWildcard);
            while (wildcardIndex != -1) {
                if (wildcardIndex == 0 || escapedWildcardIndex != wildcardIndex - 1) {
                    fixedPattern.setCharAt(wildcardIndex, jpqlWildcard);
                    wildcardIndex = fixedPattern.indexOf(lookupWildcard, wildcardIndex);
                    continue;
                }
                fixedPattern.replace(escapedWildcardIndex, wildcardIndex + 1, lookupWildcard);
                wildcardIndex = fixedPattern.indexOf(lookupWildcard, wildcardIndex);
                escapedWildcardIndex = fixedPattern.indexOf(escapedLookupWildcard, wildcardIndex);
            }
        }
        return fixedPattern.toString();
    }

    private void preparePrefixIfNecessary(String attribute) {
        this.whereClause.append(this.whereClause.length() > 0 ? " AND " : "");
        if (!attribute.contains(JPA_ALIAS_PREFIX)) {
            this.whereClause.append(JPA_INITIAL_ALIAS).append('.');
        }
    }

    private String prepareAttribute(String attribute, Object value) {
        return value instanceof Class ? ((Class)value).getName() : (attribute.contains(JPA_ALIAS_PREFIX) ? this.addAttr("bind_param" + ++this.generatedBindParamCount, value) : this.addAttr(this.fixPeriods(attribute), value));
    }

    private String[] prepareAttributes(String attribute, Object ... values) {
        int count = values.length;
        String[] fixedAttrs = new String[count];
        if (attribute.contains(JPA_ALIAS_PREFIX)) {
            int tempParamCount = ++this.generatedBindParamCount;
            for (int i = 0; i < count; ++i) {
                fixedAttrs[i] = values[i] instanceof Class ? ((Class)values[i]).getName() : this.addAttr(new StringBuilder(20).append("bind_param").append(tempParamCount).append("_b").append(i + 1).toString(), values[i]);
            }
        } else {
            attribute = this.fixPeriods(attribute);
            for (int i = 0; i < count; ++i) {
                fixedAttrs[i] = values[i] instanceof Class ? ((Class)values[i]).getName() : this.addAttr(new StringBuilder(attribute.length() + 5).append(attribute).append("_b").append(i + 1).toString(), values[i]);
            }
        }
        return fixedAttrs;
    }

    private String preparePrefixAndAttributeIfNecessary(String attribute, Object value) {
        this.whereClause.append(this.whereClause.length() > 0 ? " AND " : "");
        if (value instanceof Class) {
            return ((Class)value).getName();
        }
        if (attribute.contains(JPA_ALIAS_PREFIX)) {
            return this.addAttr("bind_param" + ++this.generatedBindParamCount, value);
        }
        this.whereClause.append(JPA_INITIAL_ALIAS).append('.');
        return this.addAttr(this.fixPeriods(attribute), value);
    }

    private String addAttr(String string, Object value) {
        while (this.params.containsKey(string)) {
            string = "bind_param" + ++this.generatedBindParamCount;
        }
        this.params.put(string, value);
        return new StringBuilder(45).append(JPA_PARAM_PREFIX_WITH_COLON).append('\'').append(string).append('\'').append(JPA_ALIAS_SUFFIX).toString();
    }

    public void between(String attribute, Object value1, Object value2) {
        this.preparePrefixIfNecessary(attribute);
        String[] fixedAttrs = this.prepareAttributes(attribute, value1, value2);
        this.whereClause.append(attribute).append(" BETWEEN ").append(fixedAttrs[0]).append(" AND ").append(fixedAttrs[1]);
    }

    public void notBetween(String attribute, Object value1, Object value2) {
        this.preparePrefixIfNecessary(attribute);
        String[] fixedAttrs = this.prepareAttributes(attribute, value1, value2);
        this.whereClause.append(attribute).append(" NOT BETWEEN ").append(fixedAttrs[0]).append(" AND ").append(fixedAttrs[1]);
    }

    public void eq(String attribute, Object value) {
        String fixedAttr = this.preparePrefixAndAttributeIfNecessary(attribute, value);
        this.whereClause.append(attribute).append(" = ").append(fixedAttr);
    }

    public void gt(String attribute, Object value) {
        String fixedAttr = this.preparePrefixAndAttributeIfNecessary(attribute, value);
        this.whereClause.append(attribute).append(" > ").append(fixedAttr);
    }

    public void gte(String attribute, Object value) {
        String fixedAttr = this.preparePrefixAndAttributeIfNecessary(attribute, value);
        this.whereClause.append(attribute).append(" >= ").append(fixedAttr);
    }

    public void like(String attribute, Object value) {
        String fixedAttr = this.preparePrefixAndAttributeIfNecessary(attribute, this.fixSearchPattern(value.toString()));
        this.whereClause.append(attribute).append(" LIKE ").append(fixedAttr);
    }

    public void notLike(String attribute, Object value) {
        String fixedAttr = this.preparePrefixAndAttributeIfNecessary(attribute, this.fixSearchPattern(value.toString()));
        this.whereClause.append(attribute).append(" NOT LIKE ").append(fixedAttr);
    }

    public void likeEscape(String attribute, Object value, char escapeChar) {
        String fixedAttr = this.preparePrefixAndAttributeIfNecessary(attribute, this.fixSearchPattern(value.toString()));
        this.whereClause.append(attribute).append(" LIKE ").append(fixedAttr).append(" ESCAPE ").append(this.prepareAttribute(JPA_ALIAS_PREFIX, Character.valueOf(escapeChar)));
    }

    public void notLikeEscape(String attribute, Object value, char escapeChar) {
        String fixedAttr = this.preparePrefixAndAttributeIfNecessary(attribute, this.fixSearchPattern(value.toString()));
        this.whereClause.append(attribute).append(" NOT LIKE ").append(fixedAttr).append(" ESCAPE ").append(this.prepareAttribute(JPA_ALIAS_PREFIX, Character.valueOf(escapeChar)));
    }

    public void lt(String attribute, Object value) {
        String fixedAttr = this.preparePrefixAndAttributeIfNecessary(attribute, value);
        this.whereClause.append(attribute).append(" < ").append(fixedAttr);
    }

    public void lte(String attribute, Object value) {
        String fixedAttr = this.preparePrefixAndAttributeIfNecessary(attribute, value);
        this.whereClause.append(attribute).append(" <= ").append(fixedAttr);
    }

    public void ne(String attribute, Object value) {
        String fixedAttr = this.preparePrefixAndAttributeIfNecessary(attribute, value);
        this.whereClause.append(attribute).append(" <> ").append(fixedAttr);
    }

    public void isNull(String attribute) {
        this.preparePrefixIfNecessary(attribute);
        this.whereClause.append(attribute).append(" IS NULL");
    }

    public void notNull(String attribute) {
        this.preparePrefixIfNecessary(attribute);
        this.whereClause.append(attribute).append(" IS NOT NULL");
    }

    public void memberOf(Object value, String collection) {
        String fixedAttr = this.prepareAttribute(collection, value);
        this.preparePrefixIfNecessary(JPA_ALIAS_PREFIX);
        this.whereClause.append(fixedAttr).append(" MEMBER OF ").append(collection.contains(JPA_ALIAS_PREFIX) ? "" : "__JPA_ALIAS[[0]]__.").append(collection);
    }

    public void memberOf(String attribute, String collection) {
        this.preparePrefixIfNecessary(attribute);
        this.whereClause.append(attribute).append(" MEMBER OF ").append(collection.contains(JPA_ALIAS_PREFIX) ? "" : "__JPA_ALIAS[[0]]__.").append(collection);
    }

    public void notMemberOf(Object value, String collection) {
        String fixedAttr = this.prepareAttribute(collection, value);
        this.preparePrefixIfNecessary(JPA_ALIAS_PREFIX);
        this.whereClause.append(fixedAttr).append(" NOT MEMBER OF ").append(collection.contains(JPA_ALIAS_PREFIX) ? "" : "__JPA_ALIAS[[0]]__.").append(collection);
    }

    public void notMemberOf(String attribute, String collection) {
        this.preparePrefixIfNecessary(attribute);
        this.whereClause.append(attribute).append(" NOT MEMBER OF ").append(collection.contains(JPA_ALIAS_PREFIX) ? "" : "__JPA_ALIAS[[0]]__.").append(collection);
    }

    public void isEmpty(String collection) {
        this.preparePrefixIfNecessary(collection);
        this.whereClause.append(collection).append(" IS EMPTY");
    }

    public void notEmpty(String collection) {
        this.preparePrefixIfNecessary(collection);
        this.whereClause.append(collection).append(" IS NOT EMPTY");
    }

    public void in(String attribute, Criteria in) {
        if (in == null) {
            throw new IllegalArgumentException("'IN' Criteria cannot be null");
        }
        this.preparePrefixIfNecessary(attribute);
        this.whereClause.append(attribute).append(" IN ");
        this.subQuery(in);
    }

    public void notIn(String attribute, Criteria notIn) {
        if (notIn == null) {
            throw new IllegalArgumentException("'NOT IN' Criteria cannot be null");
        }
        this.preparePrefixIfNecessary(attribute);
        this.whereClause.append(attribute).append(" NOT IN ");
        this.subQuery(notIn);
    }

    public void in(String attribute, Collection<?> values) {
        this.preparePrefixIfNecessary(attribute);
        this.whereClause.append(attribute).append(" IN (");
        this.appendBodyOfIn(values);
        this.whereClause.append(')');
    }

    public void notIn(String attribute, Collection<?> values) {
        this.preparePrefixIfNecessary(attribute);
        this.whereClause.append(attribute).append(" NOT IN (");
        this.appendBodyOfIn(values);
        this.whereClause.append(')');
    }

    public void in(String attribute, Object ... values) {
        this.preparePrefixIfNecessary(attribute);
        this.whereClause.append(attribute).append(" IN (");
        this.appendBodyOfIn(Arrays.asList(values));
        this.whereClause.append(')');
    }

    public void notIn(String attribute, Object ... values) {
        this.preparePrefixIfNecessary(attribute);
        this.whereClause.append(attribute).append(" NOT IN (");
        this.appendBodyOfIn(Arrays.asList(values));
        this.whereClause.append(')');
    }

    private void appendBodyOfIn(Collection<?> values) {
        Iterator<?> valuesIter = values.iterator();
        if (valuesIter.hasNext()) {
            this.fixValue(this.whereClause, valuesIter.next());
            while (valuesIter.hasNext()) {
                this.whereClause.append(", ");
                this.fixValue(this.whereClause, valuesIter.next());
            }
        }
    }

    public void and(Criteria and) {
        if (and == null) {
            throw new IllegalArgumentException("'AND' Criteria cannot be null");
        }
        if (and.whereClause.length() > 0) {
            int oldLen = this.whereClause.length();
            this.preparePrefixIfNecessary(JPA_ALIAS_PREFIX);
            this.whereClause.append('(').append((CharSequence)and.whereClause).append(')');
            this.copyParams(and, oldLen, true);
        }
    }

    public void not(Criteria not) {
        if (not == null) {
            throw new IllegalArgumentException("'NOT' Criteria cannot be null");
        }
        if (not.whereClause.length() > 0) {
            int oldLen = this.whereClause.length();
            this.preparePrefixIfNecessary(JPA_ALIAS_PREFIX);
            this.whereClause.append("NOT (").append((CharSequence)not.whereClause).append(')');
            this.copyParams(not, oldLen, true);
        }
    }

    public void or(Criteria or) {
        if (or == null) {
            throw new IllegalArgumentException("'OR' Criteria cannot be null");
        }
        if (or.whereClause.length() > 0) {
            int oldLen = this.whereClause.length();
            this.whereClause.append(oldLen > 0 ? " OR (" : "(").append((CharSequence)or.whereClause).append(')');
            this.copyParams(or, oldLen, true);
        }
    }

    public void orNot(Criteria orNot) {
        if (orNot == null) {
            throw new IllegalArgumentException("'OR NOT' Criteria cannot be null");
        }
        if (orNot.whereClause.length() > 0) {
            int oldLen = this.whereClause.length();
            this.whereClause.append(oldLen > 0 ? " OR NOT (" : "NOT (").append((CharSequence)orNot.whereClause).append(')');
            this.copyParams(orNot, oldLen, true);
        }
    }

    public void exists(Criteria exists) {
        if (exists == null) {
            throw new IllegalArgumentException("'EXISTS' Criteria cannot be null");
        }
        this.preparePrefixIfNecessary(JPA_ALIAS_PREFIX);
        this.whereClause.append("EXISTS ");
        this.subQuery(exists);
    }

    public void notExists(Criteria notExists) {
        if (notExists == null) {
            throw new IllegalArgumentException("'NOT EXISTS' Criteria cannot be null");
        }
        this.preparePrefixIfNecessary(JPA_ALIAS_PREFIX);
        this.whereClause.append("NOT EXISTS ");
        this.subQuery(notExists);
    }

    public void rawJpql(String jpql) {
        this.whereClause.append(this.whereClause.length() > 0 ? " " : "").append(jpql).append(' ');
    }

    public void groupBy(String attribute) {
        this.groupByClause.append(this.groupByClause.length() > 0 ? ", " : " GROUP BY ");
        if (!attribute.contains(JPA_ALIAS_PREFIX)) {
            this.groupByClause.append(JPA_INITIAL_ALIAS).append('.');
        }
        this.groupByClause.append(attribute);
    }

    public void having(Criteria having) {
        if (having == null) {
            throw new IllegalArgumentException("'HAVING' Criteria cannot be null");
        }
        if (having.whereClause.length() > 0) {
            int oldLen = this.havingClause.length();
            this.havingClause.append(oldLen > 0 ? " AND " : " HAVING ").append((CharSequence)having.whereClause);
            this.copyParams(having, oldLen, false);
        }
    }

    public void orderBy(String attribute, boolean sortAscending) {
        this.orderByClause.append(this.orderByClause.length() > 0 ? ", " : " ORDER BY ");
        if (!attribute.contains(JPA_ALIAS_PREFIX)) {
            this.orderByClause.append(JPA_INITIAL_ALIAS).append('.');
        }
        this.orderByClause.append(attribute).append(sortAscending ? " ASC" : " DESC");
    }

    private void copyParams(Criteria subCriteria, int startIndex, boolean modifyWhereClause) {
        StringBuilder tempClause = modifyWhereClause ? this.whereClause : this.havingClause;
        HashMap<String, String> modifiedNames = new HashMap<String, String>();
        int paramClose = 0;
        int paramIndex = tempClause.indexOf(JPA_PARAM_PREFIX_WITH_COLON, startIndex);
        String newPlaceholder = null;
        for (Map.Entry<String, Object> param : subCriteria.params.entrySet()) {
            if (this.params.containsKey(param.getKey())) {
                modifiedNames.put(param.getKey(), this.addAttr(param.getKey(), param.getValue()));
                continue;
            }
            this.params.put(param.getKey(), param.getValue());
        }
        while (paramIndex >= 0) {
            paramClose = tempClause.indexOf(JPA_ALIAS_SUFFIX, paramIndex);
            newPlaceholder = (String)modifiedNames.get(tempClause.substring(paramIndex + PARAM_PREFIX_LEN + 2, paramClose - 1));
            if (newPlaceholder != null) {
                tempClause.replace(paramIndex, paramClose + ALIAS_SUFFIX_LEN, newPlaceholder);
            }
            paramIndex = tempClause.indexOf(JPA_PARAM_PREFIX_WITH_COLON, paramIndex + 1);
        }
    }

    private void subQuery(Criteria subCriteria) {
        int i;
        HashMap<String, String> modifiedAliases = new HashMap<String, String>();
        int count = subCriteria.entityAliases.size();
        int paramIndex = 0;
        int paramClose = 0;
        String newPlaceholder = null;
        for (i = this.entityAliases.size() - 1; i >= 0; --i) {
            modifiedAliases.put(JPA_ALIAS_PREFIX + ~i + JPA_ALIAS_SUFFIX, this.indexedAliasPlaceholders.get(i));
        }
        for (i = 0; i < count; ++i) {
            String oldAlias = subCriteria.entityAliases.get(i);
            if (!this.addAlias(oldAlias).equals(oldAlias)) {
                modifiedAliases.put(subCriteria.namedAliasPlaceholders.get(i), this.namedAliasPlaceholders.get(this.namedAliasPlaceholders.size() - 1));
            }
            modifiedAliases.put(subCriteria.indexedAliasPlaceholders.get(i), this.indexedAliasPlaceholders.get(this.indexedAliasPlaceholders.size() - 1));
        }
        count = this.whereClause.length();
        this.whereClause.append(subCriteria.distinct ? "(SELECT DISTINCT " : "(SELECT ").append((CharSequence)subCriteria.selectClause).append((CharSequence)subCriteria.fromClause).append(subCriteria.whereClause.length() > 0 ? " WHERE " : "").append((CharSequence)subCriteria.whereClause).append((CharSequence)subCriteria.groupByClause).append((CharSequence)subCriteria.havingClause).append(')');
        paramIndex = this.whereClause.indexOf(JPA_ALIAS_PREFIX, count);
        while (paramIndex >= 0) {
            paramClose = this.whereClause.indexOf(JPA_ALIAS_SUFFIX, paramIndex) + ALIAS_SUFFIX_LEN;
            newPlaceholder = (String)modifiedAliases.get(this.whereClause.substring(paramIndex, paramClose));
            if (newPlaceholder != null) {
                this.whereClause.replace(paramIndex, paramClose, newPlaceholder);
            }
            paramIndex = this.whereClause.indexOf(JPA_ALIAS_PREFIX, paramIndex + 1);
        }
        this.copyParams(subCriteria, count, true);
    }

    public String toQuery(QueryByCriteria.QueryByCriteriaType type) {
        return this.toQuery(type, new String[0]);
    }

    public String toQuery(QueryByCriteria.QueryByCriteriaType type, String[] queryAttr) {
        StringBuilder newQuery;
        int querySize = this.selectClause.length() + this.fromClause.length() + this.whereClause.length() + this.groupByClause.length() + this.havingClause.length() + this.orderByClause.length() + 7;
        switch (type) {
            case SELECT: {
                if (queryAttr != null && queryAttr.length > 0) {
                    if (this.selectClause.length() > 0) {
                        this.selectClause.delete(0, this.selectClause.length());
                    }
                    for (int i = 0; i < queryAttr.length; ++i) {
                        this.select(queryAttr[i]);
                    }
                }
                newQuery = new StringBuilder(querySize + (this.distinct ? 16 : 7)).append(this.distinct ? "SELECT DISTINCT " : "SELECT ").append((CharSequence)this.selectClause).append((CharSequence)this.fromClause).append(this.whereClause.length() > 0 ? " WHERE " : "").append((CharSequence)this.whereClause).append((CharSequence)this.groupByClause).append((CharSequence)this.havingClause).append((CharSequence)this.orderByClause);
                break;
            }
            case UPDATE: {
                newQuery = new StringBuilder(querySize + this.setClause.length() + 7).append("UPDATE ").append(this.initialEntityName).append(" AS ").append(this.getAlias()).append((CharSequence)this.setClause).append(this.whereClause.length() > 0 ? " WHERE " : "").append((CharSequence)this.whereClause);
                break;
            }
            case DELETE: {
                newQuery = new StringBuilder(querySize + 6).append("DELETE").append((CharSequence)this.fromClause).append(this.whereClause.length() > 0 ? " WHERE " : "").append((CharSequence)this.whereClause);
                break;
            }
            default: {
                return null;
            }
        }
        return this.fix(newQuery);
    }

    public String toCountQuery() {
        StringBuilder newQuery = new StringBuilder(this.fromClause.length() + this.whereClause.length() + this.groupByClause.length() + this.havingClause.length() + this.orderByClause.length() + 15 + 7).append("SELECT COUNT(*)").append((CharSequence)this.fromClause).append(this.whereClause.length() > 0 ? " WHERE " : "").append((CharSequence)this.whereClause).append((CharSequence)this.groupByClause).append((CharSequence)this.havingClause).append((CharSequence)this.orderByClause);
        return this.fix(newQuery);
    }

    private String fix(StringBuilder newQuery) {
        HashMap<String, String> modifiedAliases = new HashMap<String, String>();
        for (int i = this.entityAliases.size() - 1; i >= 0; --i) {
            modifiedAliases.put(this.indexedAliasPlaceholders.get(i), this.entityAliases.get(i));
            modifiedAliases.put(this.namedAliasPlaceholders.get(i), this.entityAliases.get(i));
        }
        String newParam = null;
        int paramClose = 0;
        int paramIndex = newQuery.indexOf(JPA_ALIAS_PREFIX);
        while (paramIndex >= 0) {
            paramClose = newQuery.indexOf(JPA_ALIAS_SUFFIX, paramIndex) + ALIAS_SUFFIX_LEN;
            newParam = (String)modifiedAliases.get(newQuery.substring(paramIndex, paramClose));
            if (newParam == null) {
                LOG.error((Object)("Detected an unresolvable JPA alias when constructing query: " + newQuery.substring(paramIndex, paramClose)));
                throw new IllegalStateException("Detected an unresolvable alias: " + newQuery.substring(paramIndex, paramClose));
            }
            newQuery.replace(paramIndex, paramClose, newParam);
            paramIndex = newQuery.indexOf(JPA_ALIAS_PREFIX, paramIndex + 1);
        }
        paramIndex = newQuery.indexOf(JPA_PARAM_PREFIX);
        while (paramIndex >= 0) {
            paramClose = newQuery.indexOf(JPA_ALIAS_SUFFIX, paramIndex);
            newParam = newQuery.substring(paramIndex + PARAM_PREFIX_LEN + 1, paramClose - 1);
            if (!this.params.containsKey(newParam)) {
                LOG.error((Object)("Detected an unresolvable input parameter when constructing query: " + newQuery.substring(paramIndex, paramClose + ALIAS_SUFFIX_LEN)));
                throw new IllegalStateException("Detected an unresolvable input parameter: " + newQuery.substring(paramIndex, paramClose + ALIAS_SUFFIX_LEN));
            }
            newQuery.replace(paramIndex, paramClose + ALIAS_SUFFIX_LEN, newParam);
            paramIndex = newQuery.indexOf(JPA_PARAM_PREFIX, paramIndex + 1);
        }
        String finishedQuery = newQuery.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"********** SEARCH JPQL QUERY **********");
            LOG.debug((Object)finishedQuery);
            LOG.debug((Object)"***************************************");
        }
        return finishedQuery;
    }

    public void prepareParameters(Query query) {
        for (Map.Entry<String, Object> param : this.params.entrySet()) {
            Object value = param.getValue();
            if (value == null) continue;
            if (value instanceof String && query.getParameter(param.getKey()).getParameterType().equals(Boolean.class)) {
                value = Truth.strToBooleanIgnoreCase((String)((String)value), (Boolean)Boolean.FALSE);
            }
            query.setParameter(param.getKey(), value);
        }
    }

    public Integer getSearchLimit() {
        return this.searchLimit;
    }

    public void setSearchLimit(Integer searchLimit) {
        this.searchLimit = searchLimit;
    }

    public void distinct(boolean distinct) {
        this.distinct = distinct;
    }

    public String getAlias() {
        return this.entityAliases.get(0);
    }

    public String getAlias(int index) {
        return this.entityAliases.get(index);
    }

    public int getAliasIndex(String alias) {
        Integer tempIndex = this.aliasIndexes.get(alias);
        return tempIndex != null ? tempIndex : -1;
    }

    public List<String> getAliases() {
        return new ArrayList<String>(this.entityAliases);
    }

    public String getEntityName() {
        return this.initialEntityName;
    }
}

