/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.persistence.EntityManager;
import javax.persistence.NonUniqueResultException;
import javax.persistence.metamodel.ManagedType;
import org.apache.log4j.Logger;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.krad.data.CompoundKey;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.data.jpa.JpaCriteriaQuery;
import org.kuali.rice.krad.data.metadata.DataObjectMetadata;
import org.kuali.rice.krad.data.provider.PersistenceProvider;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.ChainedPersistenceExceptionTranslator;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class JpaPersistenceProvider
implements PersistenceProvider,
BeanFactoryAware {
    private static final Logger LOG = Logger.getLogger(JpaPersistenceProvider.class);
    public static final String AUTO_FLUSH = "rice.krad.data.jpa.autoFlush";
    private EntityManager sharedEntityManager;
    private DataObjectService dataObjectService;
    private PersistenceExceptionTranslator persistenceExceptionTranslator;

    public EntityManager getSharedEntityManager() {
        return this.sharedEntityManager;
    }

    public void setSharedEntityManager(EntityManager sharedEntityManager) {
        this.sharedEntityManager = sharedEntityManager;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ListableBeanFactory)) {
            throw new IllegalArgumentException("Cannot use PersistenceExceptionTranslator autodetection without ListableBeanFactory");
        }
        this.persistenceExceptionTranslator = this.detectPersistenceExceptionTranslators((ListableBeanFactory)beanFactory);
    }

    protected PersistenceExceptionTranslator detectPersistenceExceptionTranslators(ListableBeanFactory beanFactory) {
        Map pets = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, PersistenceExceptionTranslator.class, (boolean)false, (boolean)false);
        ChainedPersistenceExceptionTranslator cpet = new ChainedPersistenceExceptionTranslator();
        for (PersistenceExceptionTranslator pet : pets.values()) {
            cpet.addDelegate(pet);
        }
        cpet.addDelegate((PersistenceExceptionTranslator)new DefaultPersistenceExceptionTranslator());
        return cpet;
    }

    @Override
    public <T> T save(final T dataObject, final PersistenceOption ... options) {
        return this.doWithExceptionTranslation(new Callable<T>(){

            @Override
            public T call() {
                JpaPersistenceProvider.this.verifyDataObjectWritable(dataObject);
                HashSet optionSet = Sets.newHashSet((Object[])options);
                Object mergedDataObject = JpaPersistenceProvider.this.sharedEntityManager.merge(dataObject);
                if (optionSet.contains(PersistenceOption.FLUSH) || optionSet.contains(PersistenceOption.LINK_KEYS) || LazyConfigHolder.autoFlush) {
                    JpaPersistenceProvider.this.sharedEntityManager.flush();
                }
                return mergedDataObject;
            }
        });
    }

    @Override
    public <T> T find(final Class<T> type, final Object id) {
        return this.doWithExceptionTranslation(new Callable<T>(){

            @Override
            public T call() {
                if (id instanceof CompoundKey) {
                    QueryResults results = JpaPersistenceProvider.this.findMatching(type, QueryByCriteria.Builder.andAttributes(((CompoundKey)id).getKeys()).build());
                    if (results.getResults().size() > 1) {
                        throw new NonUniqueResultException("Error Compound Key: " + id + " on class " + type.getName() + " returned more than one row.");
                    }
                    if (!results.getResults().isEmpty()) {
                        return results.getResults().get(0);
                    }
                    return null;
                }
                return JpaPersistenceProvider.this.sharedEntityManager.find(type, id);
            }
        });
    }

    @Override
    public <T> QueryResults<T> findMatching(final Class<T> type, final QueryByCriteria queryByCriteria) {
        return (QueryResults)this.doWithExceptionTranslation(new Callable<QueryResults<T>>(){

            @Override
            public QueryResults<T> call() {
                return new JpaCriteriaQuery(JpaPersistenceProvider.this.sharedEntityManager).lookup(type, queryByCriteria);
            }
        });
    }

    @Override
    public void delete(final Object dataObject) {
        this.doWithExceptionTranslation(new Callable<Object>(){

            @Override
            public Object call() {
                JpaPersistenceProvider.this.verifyDataObjectWritable(dataObject);
                JpaPersistenceProvider.this.sharedEntityManager.remove(JpaPersistenceProvider.this.sharedEntityManager.merge(dataObject));
                return null;
            }
        });
    }

    @Override
    public <T> T copyInstance(final T dataObject) {
        return this.doWithExceptionTranslation(new Callable<T>(){

            @Override
            public T call() {
                return ((JpaEntityManager)JpaPersistenceProvider.this.sharedEntityManager.unwrap(JpaEntityManager.class)).getDatabaseSession().copy(dataObject);
            }
        });
    }

    @Override
    public boolean handles(final Class<?> type) {
        return this.doWithExceptionTranslation(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    ManagedType managedType = JpaPersistenceProvider.this.sharedEntityManager.getMetamodel().managedType(type);
                    return managedType != null;
                }
                catch (IllegalArgumentException iae) {
                    return Boolean.FALSE;
                }
                catch (IllegalStateException ex) {
                    LOG.warn((Object)("sharedEntityManager " + JpaPersistenceProvider.this.sharedEntityManager + " is not in a state to be used: " + ex.getMessage()));
                    return Boolean.FALSE;
                }
            }
        });
    }

    @Override
    public void flush(Class<?> type) {
        this.doWithExceptionTranslation(new Callable<Object>(){

            @Override
            public Object call() {
                JpaPersistenceProvider.this.sharedEntityManager.flush();
                return null;
            }
        });
    }

    protected void verifyDataObjectWritable(Object dataObject) {
        DataObjectMetadata metaData = this.dataObjectService.getMetadataRepository().getMetadata(dataObject.getClass());
        if (metaData == null) {
            throw new IllegalArgumentException("Given data object class is not loaded into the MetadataRepository: " + dataObject.getClass());
        }
        if (metaData.isReadOnly()) {
            throw new UnsupportedOperationException(dataObject.getClass() + " is read-only");
        }
    }

    protected <T> T doWithExceptionTranslation(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (RuntimeException ex) {
            throw DataAccessUtils.translateIfNecessary((RuntimeException)ex, (PersistenceExceptionTranslator)this.persistenceExceptionTranslator);
        }
        catch (Exception ex) {
            throw new RiceRuntimeException("Unexpected checked exception during data access.", (Throwable)ex);
        }
    }

    private static final class DefaultPersistenceExceptionTranslator
    implements PersistenceExceptionTranslator {
        private DefaultPersistenceExceptionTranslator() {
        }

        public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
            return EntityManagerFactoryUtils.convertJpaAccessExceptionIfPossible((RuntimeException)ex);
        }
    }

    private static final class LazyConfigHolder {
        private static final boolean autoFlush = ConfigContext.getCurrentContextConfig().getBooleanProperty("rice.krad.data.jpa.autoFlush", false);

        private LazyConfigHolder() {
        }
    }
}

