/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa;

import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.data.jpa.Criteria;
import org.kuali.rice.krad.data.jpa.QueryByCriteria;
import org.kuali.rice.krad.data.jpa.QueryTranslatorBase;
import org.springframework.util.ClassUtils;

class JpaQueryTranslator
extends QueryTranslatorBase<Criteria, Query> {
    protected EntityManager entityManager;

    JpaQueryTranslator(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public Query createQuery(Class queryClazz, Criteria criteria) {
        return new QueryByCriteria(this.entityManager, criteria).toQuery();
    }

    @Override
    protected Criteria createCriteria(Class entityClass) {
        return new Criteria(entityClass.getName());
    }

    @Override
    protected Criteria createInnerCriteria(Criteria parent) {
        try {
            return this.createCriteria(ClassUtils.getDefaultClassLoader().loadClass(parent.getEntityName()));
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
    }

    @Override
    public void convertQueryFlags(org.kuali.rice.core.api.criteria.QueryByCriteria qbc, Query query) {
        int startAtIndex = qbc.getStartAtIndex() != null ? qbc.getStartAtIndex() : 0;
        query.setFirstResult(startAtIndex);
        if (qbc.getMaxResults() != null) {
            query.setMaxResults(qbc.getMaxResults().intValue());
        }
    }

    @Override
    protected void addNotNull(Criteria criteria, String propertyPath) {
        criteria.notNull(propertyPath);
    }

    @Override
    protected void addIsNull(Criteria criteria, String propertyPath) {
        criteria.isNull(propertyPath);
    }

    @Override
    protected void addEqualTo(Criteria criteria, String propertyPath, Object value) {
        criteria.eq(propertyPath, value);
    }

    @Override
    protected void addGreaterOrEqualTo(Criteria criteria, String propertyPath, Object value) {
        criteria.gte(propertyPath, value);
    }

    @Override
    protected void addGreaterThan(Criteria criteria, String propertyPath, Object value) {
        criteria.gt(propertyPath, value);
    }

    @Override
    protected void addLessOrEqualTo(Criteria criteria, String propertyPath, Object value) {
        criteria.lte(propertyPath, value);
    }

    @Override
    protected void addLessThan(Criteria criteria, String propertyPath, Object value) {
        criteria.lt(propertyPath, value);
    }

    @Override
    protected void addLike(Criteria criteria, String propertyPath, Object value) {
        criteria.like(propertyPath, value);
    }

    @Override
    protected void addNotEqualTo(Criteria criteria, String propertyPath, Object value) {
        criteria.ne(propertyPath, value);
    }

    @Override
    protected void addNotLike(Criteria criteria, String propertyPath, Object value) {
        criteria.notLike(propertyPath, value);
    }

    @Override
    protected void addIn(Criteria criteria, String propertyPath, Collection values) {
        criteria.in(propertyPath, values);
    }

    @Override
    protected void addNotIn(Criteria criteria, String propertyPath, Collection values) {
        criteria.notIn(propertyPath, values);
    }

    @Override
    protected void addAnd(Criteria criteria, Criteria inner) {
        criteria.and(inner);
    }

    @Override
    protected void addOr(Criteria criteria, Criteria inner) {
        criteria.or(inner);
    }

    @Override
    protected String genUpperFunc(String pp) {
        pp = StringUtils.contains((String)pp, (String)"__JPA_ALIAS[[") ? "UPPER(" + pp + ")" : "UPPER(__JPA_ALIAS[[0]]__." + pp + ")";
        return pp;
    }
}

