/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.data.jpa.QueryTranslatorBase;

class NativeJpaQueryTranslator
extends QueryTranslatorBase<TranslationContext, TypedQuery> {
    protected static final String[] LOOKUP_WILDCARDS = new String[]{"*", "?"};
    protected static final String[] ESCAPED_LOOKUP_WILDCARDS = new String[]{"\\*", "\\?"};
    protected static final char[] JPQL_WILDCARDS = new char[]{'%', '_'};
    protected EntityManager entityManager;

    public NativeJpaQueryTranslator(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public TypedQuery createQuery(Class queryClazz, TranslationContext criteria) {
        CriteriaQuery jpaQuery = criteria.query;
        if (!criteria.predicates.isEmpty()) {
            jpaQuery = jpaQuery.where((Expression)criteria.getCriteriaPredicate());
        }
        return this.entityManager.createQuery(jpaQuery);
    }

    @Override
    protected TranslationContext createCriteria(Class queryClazz) {
        return new TranslationContext(this.entityManager, queryClazz);
    }

    @Override
    protected TranslationContext createInnerCriteria(TranslationContext parent) {
        return new TranslationContext(parent);
    }

    @Override
    public void convertQueryFlags(QueryByCriteria qbc, TypedQuery query) {
        int startAtIndex = qbc.getStartAtIndex() != null ? qbc.getStartAtIndex() : 0;
        query.setFirstResult(startAtIndex);
        if (qbc.getMaxResults() != null) {
            query.setMaxResults(qbc.getMaxResults().intValue());
        }
    }

    @Override
    protected void addAnd(TranslationContext criteria, TranslationContext inner) {
        criteria.and(inner);
    }

    @Override
    protected void addNotNull(TranslationContext criteria, String propertyPath) {
        criteria.addPredicate(criteria.builder.isNotNull((Expression)criteria.attr(propertyPath)));
    }

    @Override
    protected void addIsNull(TranslationContext criteria, String propertyPath) {
        criteria.addPredicate(criteria.builder.isNull((Expression)criteria.attr(propertyPath)));
    }

    @Override
    protected void addEqualTo(TranslationContext criteria, String propertyPath, Object value) {
        criteria.addPredicate(criteria.builder.equal((Expression)criteria.attr(propertyPath), value));
    }

    @Override
    protected void addEqualToIgnoreCase(TranslationContext criteria, String propertyPath, String value) {
        criteria.addPredicate(criteria.builder.equal(criteria.builder.upper((Expression)criteria.attr(propertyPath)), (Object)value.toUpperCase()));
    }

    @Override
    protected void addGreaterOrEqualTo(TranslationContext criteria, String propertyPath, Object value) {
        criteria.addPredicate(criteria.builder.greaterThanOrEqualTo((Expression)criteria.attr(propertyPath), (Comparable)value));
    }

    @Override
    protected void addGreaterThan(TranslationContext criteria, String propertyPath, Object value) {
        criteria.addPredicate(criteria.builder.greaterThan((Expression)criteria.attr(propertyPath), (Comparable)value));
    }

    @Override
    protected void addLessOrEqualTo(TranslationContext criteria, String propertyPath, Object value) {
        criteria.addPredicate(criteria.builder.lessThanOrEqualTo((Expression)criteria.attr(propertyPath), (Comparable)value));
    }

    @Override
    protected void addLessThan(TranslationContext criteria, String propertyPath, Object value) {
        criteria.addPredicate(criteria.builder.lessThan((Expression)criteria.attr(propertyPath), (Comparable)value));
    }

    @Override
    protected void addLike(TranslationContext criteria, String propertyPath, Object value) {
        criteria.addPredicate(criteria.builder.like((Expression)criteria.attr(propertyPath), this.fixSearchPattern(value.toString())));
    }

    @Override
    protected void addLikeIgnoreCase(TranslationContext criteria, String propertyPath, String value) {
        criteria.addPredicate(criteria.builder.like(criteria.builder.upper((Expression)criteria.attr(propertyPath)), this.fixSearchPattern(value.toUpperCase())));
    }

    protected String fixSearchPattern(String value) {
        StringBuilder fixedPattern = new StringBuilder(value);
        for (int i = 0; i < LOOKUP_WILDCARDS.length; ++i) {
            String lookupWildcard = LOOKUP_WILDCARDS[i];
            String escapedLookupWildcard = ESCAPED_LOOKUP_WILDCARDS[i];
            char jpqlWildcard = JPQL_WILDCARDS[i];
            int wildcardIndex = fixedPattern.indexOf(lookupWildcard);
            int escapedWildcardIndex = fixedPattern.indexOf(escapedLookupWildcard);
            while (wildcardIndex != -1) {
                if (wildcardIndex == 0 || escapedWildcardIndex != wildcardIndex - 1) {
                    fixedPattern.setCharAt(wildcardIndex, jpqlWildcard);
                    wildcardIndex = fixedPattern.indexOf(lookupWildcard, wildcardIndex);
                    continue;
                }
                fixedPattern.replace(escapedWildcardIndex, wildcardIndex + 1, lookupWildcard);
                wildcardIndex = fixedPattern.indexOf(lookupWildcard, wildcardIndex);
                escapedWildcardIndex = fixedPattern.indexOf(escapedLookupWildcard, wildcardIndex);
            }
        }
        return fixedPattern.toString();
    }

    @Override
    protected void addNotEqualTo(TranslationContext criteria, String propertyPath, Object value) {
        criteria.addPredicate(criteria.builder.notEqual((Expression)criteria.attr(propertyPath), value));
    }

    @Override
    protected void addNotEqualToIgnoreCase(TranslationContext criteria, String propertyPath, String value) {
        criteria.addPredicate(criteria.builder.notEqual(criteria.builder.upper((Expression)criteria.attr(propertyPath)), (Object)value.toUpperCase()));
    }

    @Override
    protected void addNotLike(TranslationContext criteria, String propertyPath, Object value) {
        criteria.addPredicate(criteria.builder.notLike((Expression)criteria.attr(propertyPath), this.fixSearchPattern(value.toString())));
    }

    @Override
    protected void addIn(TranslationContext criteria, String propertyPath, Collection values) {
        criteria.addPredicate(criteria.attr(propertyPath).in(values));
    }

    @Override
    protected void addNotIn(TranslationContext criteria, String propertyPath, Collection values) {
        criteria.addPredicate(criteria.builder.not((Expression)criteria.attr(propertyPath).in(values)));
    }

    @Override
    protected void addOr(TranslationContext criteria, TranslationContext inner) {
        criteria.or(inner);
    }

    @Override
    protected String genUpperFunc(String pp) {
        throw new IllegalStateException("genUpperFunc should not have been invoked for NativeJpaQueryTranslator");
    }

    public static class TranslationContext {
        CriteriaBuilder builder;
        CriteriaQuery query;
        Root root;
        List<Predicate> predicates = new ArrayList<Predicate>();

        TranslationContext(EntityManager entityManager, Class queryClass) {
            this.builder = entityManager.getCriteriaBuilder();
            this.query = this.builder.createQuery(queryClass);
            this.root = this.query.from(this.query.getResultType());
        }

        TranslationContext(TranslationContext parent) {
            this.builder = parent.builder;
            this.query = parent.query;
            this.root = parent.root;
        }

        void addPredicate(Predicate predicate) {
            this.predicates.add(predicate);
        }

        void and(TranslationContext predicate) {
            this.addPredicate(predicate.getCriteriaPredicate());
        }

        void or(TranslationContext predicate) {
            ArrayList<Predicate> newpredicates = new ArrayList<Predicate>();
            Predicate criteriaPredicate = this.getCriteriaPredicate();
            Predicate orPredicate = null;
            orPredicate = criteriaPredicate != null ? this.builder.or(new Predicate[]{predicate.getCriteriaPredicate(), this.getCriteriaPredicate()}) : this.builder.or(new Predicate[]{predicate.getCriteriaPredicate()});
            newpredicates.add(orPredicate);
            this.predicates = newpredicates;
        }

        Predicate getCriteriaPredicate() {
            if (this.predicates.size() == 1) {
                return this.predicates.get(0);
            }
            if (this.predicates.size() > 1) {
                return this.builder.and(this.predicates.toArray(new Predicate[this.predicates.size()]));
            }
            return null;
        }

        Path attr(String attr) {
            String[] attrArray;
            if (StringUtils.isBlank((String)attr)) {
                throw new IllegalArgumentException("Encountered an empty attribute path");
            }
            Root path = this.root;
            for (String attrElement : attrArray = attr.split("\\.")) {
                if (StringUtils.isBlank((String)attrElement)) {
                    throw new IllegalArgumentException("Encountered an empty path element in property path: " + attr);
                }
                path = path.get(attrElement);
            }
            return path;
        }
    }
}

