/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.criteria.AndPredicate;
import org.kuali.rice.core.api.criteria.CompositePredicate;
import org.kuali.rice.core.api.criteria.CriteriaValue;
import org.kuali.rice.core.api.criteria.EqualIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.EqualPredicate;
import org.kuali.rice.core.api.criteria.GreaterThanOrEqualPredicate;
import org.kuali.rice.core.api.criteria.GreaterThanPredicate;
import org.kuali.rice.core.api.criteria.InIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.InPredicate;
import org.kuali.rice.core.api.criteria.LessThanOrEqualPredicate;
import org.kuali.rice.core.api.criteria.LessThanPredicate;
import org.kuali.rice.core.api.criteria.LikeIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.LikePredicate;
import org.kuali.rice.core.api.criteria.MultiValuedPredicate;
import org.kuali.rice.core.api.criteria.NotEqualIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.NotEqualPredicate;
import org.kuali.rice.core.api.criteria.NotInIgnoreCasePredicate;
import org.kuali.rice.core.api.criteria.NotInPredicate;
import org.kuali.rice.core.api.criteria.NotLikePredicate;
import org.kuali.rice.core.api.criteria.NotNullPredicate;
import org.kuali.rice.core.api.criteria.NullPredicate;
import org.kuali.rice.core.api.criteria.OrPredicate;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PropertyPathPredicate;
import org.kuali.rice.core.api.criteria.SingleValuedPredicate;
import org.kuali.rice.krad.data.jpa.QueryTranslator;

abstract class QueryTranslatorBase<C, Q>
implements QueryTranslator<C, Q> {
    QueryTranslatorBase() {
    }

    protected abstract C createCriteria(Class var1);

    protected abstract C createInnerCriteria(C var1);

    protected abstract String genUpperFunc(String var1);

    protected abstract void addNotNull(C var1, String var2);

    protected abstract void addIsNull(C var1, String var2);

    protected abstract void addEqualTo(C var1, String var2, Object var3);

    protected abstract void addGreaterOrEqualTo(C var1, String var2, Object var3);

    protected abstract void addGreaterThan(C var1, String var2, Object var3);

    protected abstract void addLessOrEqualTo(C var1, String var2, Object var3);

    protected abstract void addLessThan(C var1, String var2, Object var3);

    protected abstract void addLike(C var1, String var2, Object var3);

    protected abstract void addNotEqualTo(C var1, String var2, Object var3);

    protected abstract void addNotLike(C var1, String var2, Object var3);

    protected abstract void addIn(C var1, String var2, Collection var3);

    protected abstract void addNotIn(C var1, String var2, Collection var3);

    protected abstract void addAnd(C var1, C var2);

    protected abstract void addOr(C var1, C var2);

    protected void addEqualToIgnoreCase(C criteria, String propertyPath, String value) {
        this.addEqualTo(criteria, this.genUpperFunc(propertyPath), value.toUpperCase());
    }

    protected void addNotEqualToIgnoreCase(C criteria, String propertyPath, String value) {
        this.addNotEqualTo(criteria, this.genUpperFunc(propertyPath), value.toUpperCase());
    }

    protected void addLikeIgnoreCase(C criteria, String propertyPath, String value) {
        this.addLike(criteria, this.genUpperFunc(propertyPath), value.toUpperCase());
    }

    @Override
    public C translateCriteria(Class queryClazz, Predicate predicate) {
        C parent = this.createCriteria(queryClazz);
        if (predicate != null) {
            this.addPredicate(predicate, parent);
        }
        return parent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addPredicate(Predicate p, C parent) {
        if (p instanceof PropertyPathPredicate) {
            String pp = ((PropertyPathPredicate)p).getPropertyPath();
            if (p instanceof NotNullPredicate) {
                this.addNotNull(parent, pp);
                return;
            } else if (p instanceof NullPredicate) {
                this.addIsNull(parent, pp);
                return;
            } else if (p instanceof SingleValuedPredicate) {
                this.addSingleValuePredicate((SingleValuedPredicate)p, parent);
                return;
            } else {
                if (!(p instanceof MultiValuedPredicate)) throw new UnsupportedPredicateException(p);
                this.addMultiValuePredicate((MultiValuedPredicate)p, parent);
            }
            return;
        } else {
            if (!(p instanceof CompositePredicate)) throw new UnsupportedPredicateException(p);
            this.addCompositePredicate((CompositePredicate)p, parent);
        }
    }

    protected void addSingleValuePredicate(SingleValuedPredicate p, C parent) {
        Object value = QueryTranslatorBase.getVal(p.getValue());
        String pp = p.getPropertyPath();
        if (p instanceof EqualPredicate) {
            this.addEqualTo(parent, pp, value);
        } else if (p instanceof EqualIgnoreCasePredicate) {
            this.addEqualToIgnoreCase(parent, pp, (String)value);
        } else if (p instanceof GreaterThanOrEqualPredicate) {
            this.addGreaterOrEqualTo(parent, pp, value);
        } else if (p instanceof GreaterThanPredicate) {
            this.addGreaterThan(parent, pp, value);
        } else if (p instanceof LessThanOrEqualPredicate) {
            this.addLessOrEqualTo(parent, pp, value);
        } else if (p instanceof LessThanPredicate) {
            this.addLessThan(parent, pp, value);
        } else if (p instanceof LikePredicate) {
            this.addLike(parent, pp, value);
        } else if (p instanceof LikeIgnoreCasePredicate) {
            this.addLikeIgnoreCase(parent, pp, (String)value);
        } else if (p instanceof NotEqualPredicate) {
            this.addNotEqualTo(parent, pp, value);
        } else if (p instanceof NotEqualIgnoreCasePredicate) {
            this.addNotEqualToIgnoreCase(parent, pp, (String)value);
        } else if (p instanceof NotLikePredicate) {
            this.addNotLike(parent, pp, value);
        } else {
            throw new UnsupportedPredicateException((Predicate)p);
        }
    }

    protected void addMultiValuePredicate(MultiValuedPredicate p, C parent) {
        String pp = p.getPropertyPath();
        if (p instanceof InPredicate) {
            Set<?> values = QueryTranslatorBase.getVals(p.getValues());
            this.addIn(parent, pp, values);
        } else if (p instanceof InIgnoreCasePredicate) {
            Set<String> values = QueryTranslatorBase.toUpper(QueryTranslatorBase.getValsUnsafe(((InIgnoreCasePredicate)p).getValues()));
            this.addIn(parent, this.genUpperFunc(pp), values);
        } else if (p instanceof NotInPredicate) {
            Set<?> values = QueryTranslatorBase.getVals(p.getValues());
            this.addNotIn(parent, pp, values);
        } else if (p instanceof NotInIgnoreCasePredicate) {
            Set<String> values = QueryTranslatorBase.toUpper(QueryTranslatorBase.getValsUnsafe(((NotInIgnoreCasePredicate)p).getValues()));
            this.addNotIn(parent, this.genUpperFunc(pp), values);
        } else {
            throw new UnsupportedPredicateException((Predicate)p);
        }
    }

    protected void addCompositePredicate(CompositePredicate p, C parent) {
        for (Predicate ip : p.getPredicates()) {
            C inner = this.createInnerCriteria(parent);
            this.addPredicate(ip, inner);
            if (p instanceof AndPredicate) {
                this.addAnd(parent, inner);
                continue;
            }
            if (p instanceof OrPredicate) {
                this.addOr(parent, inner);
                continue;
            }
            throw new UnsupportedPredicateException((Predicate)p);
        }
    }

    protected static <U extends CriteriaValue<?>> Object getVal(U toConv) {
        Object o = toConv.getValue();
        if (o instanceof DateTime) {
            return new Timestamp(((DateTime)o).getMillis());
        }
        return o;
    }

    protected static <T, U extends CriteriaValue<T>> Set<T> getValsUnsafe(Set<? extends U> toConv) {
        return QueryTranslatorBase.getVals(toConv);
    }

    protected static Set<?> getVals(Set<? extends CriteriaValue<?>> toConv) {
        HashSet<Object> values = new HashSet<Object>();
        for (CriteriaValue<?> value : toConv) {
            values.add(QueryTranslatorBase.getVal(value));
        }
        return values;
    }

    private static Set<String> toUpper(Set<String> strs) {
        HashSet<String> values = new HashSet<String>();
        for (String value : strs) {
            values.add(value.toUpperCase());
        }
        return values;
    }

    protected static class UnsupportedPredicateException
    extends RuntimeException {
        protected UnsupportedPredicateException(Predicate predicate) {
            super("Unsupported predicate [" + String.valueOf(predicate) + "]");
        }
    }
}

