/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa.eclipselink;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.config.SessionCustomizer;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.JNDIConnector;
import org.eclipse.persistence.sessions.Session;
import org.kuali.rice.krad.data.jpa.DisableVersioning;
import org.kuali.rice.krad.data.jpa.Filter;
import org.kuali.rice.krad.data.jpa.FilterGenerator;
import org.kuali.rice.krad.data.jpa.FilterGenerators;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.RemoveMapping;
import org.kuali.rice.krad.data.jpa.RemoveMappings;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

public class KradEclipseLinkCustomizer
implements SessionCustomizer {
    private static ConcurrentMap<String, List<Sequence>> sequenceMap = new ConcurrentHashMap<String, List<Sequence>>(8, 0.9f, 1);
    private static ConcurrentMap<String, Boolean> modDescMap = new ConcurrentHashMap<String, Boolean>();
    private static ConcurrentMap<String, List<FilterGenerator>> queryCustomizerMap = new ConcurrentHashMap<String, List<FilterGenerator>>();

    public void customize(Session session) throws Exception {
        String sessionName = session.getName();
        List sequences = (List)sequenceMap.get(sessionName);
        if (sequences == null && (sequences = sequenceMap.putIfAbsent(sessionName, this.loadSequences(session))) == null) {
            sequences = (List)sequenceMap.get(sessionName);
        }
        this.loadQueryCustomizers(session);
        DatabaseLogin login = session.getLogin();
        for (Sequence sequence : sequences) {
            login.addSequence(sequence);
        }
        this.handleDescriptorModifications(session);
    }

    protected void loadQueryCustomizers(Session session) {
        Map descriptors = session.getDescriptors();
        for (Class entityClass : descriptors.keySet()) {
            for (Field field : entityClass.getDeclaredFields()) {
                String queryCustEntry = entityClass.getName() + "_" + field.getName();
                this.buildQueryCustomizers(entityClass, field, queryCustEntry);
                List queryCustomizers = (List)queryCustomizerMap.get(queryCustEntry);
                if (queryCustomizers == null || queryCustomizers.isEmpty()) continue;
                Filter.customizeField(queryCustomizers, (ClassDescriptor)descriptors.get(entityClass), field.getName());
            }
        }
    }

    protected void buildQueryCustomizers(Class<?> entityClass, Field field, String key) {
        FilterGenerators customizers = field.getAnnotation(FilterGenerators.class);
        ArrayList<FilterGenerator> filterGenerators = new ArrayList<FilterGenerator>();
        if (customizers != null) {
            filterGenerators.addAll(Arrays.asList(customizers.value()));
        } else {
            FilterGenerator customizer = field.getAnnotation(FilterGenerator.class);
            if (customizer != null) {
                filterGenerators.add(customizer);
            }
        }
        for (FilterGenerator customizer : filterGenerators) {
            ArrayList<FilterGenerator> filterCustomizers = (ArrayList<FilterGenerator>)queryCustomizerMap.get(key);
            if (filterCustomizers == null) {
                filterCustomizers = new ArrayList<FilterGenerator>();
                filterCustomizers.add(customizer);
                queryCustomizerMap.putIfAbsent(key, filterCustomizers);
                continue;
            }
            filterCustomizers.add(customizer);
            queryCustomizerMap.put(key, filterCustomizers);
        }
    }

    protected void handleDescriptorModifications(Session session) {
        String sessionName = session.getName();
        Boolean descModified = (Boolean)modDescMap.get(sessionName);
        if (descModified == null && (descModified = modDescMap.putIfAbsent(sessionName, Boolean.FALSE)) == null) {
            descModified = (Boolean)modDescMap.get(sessionName);
        }
        if (Boolean.FALSE.equals(descModified)) {
            modDescMap.put(sessionName, Boolean.TRUE);
            this.handleDisableVersioning(session);
            this.handleRemoveMapping(session);
        }
    }

    protected void handleDisableVersioning(Session session) {
        Map descriptors = session.getDescriptors();
        if (descriptors == null || descriptors.isEmpty()) {
            return;
        }
        for (ClassDescriptor classDescriptor : descriptors.values()) {
            OptimisticLockingPolicy olPolicy;
            if (classDescriptor == null || AnnotationUtils.findAnnotation((Class)classDescriptor.getJavaClass(), DisableVersioning.class) == null || (olPolicy = classDescriptor.getOptimisticLockingPolicy()) == null) continue;
            classDescriptor.setOptimisticLockingPolicy(null);
        }
    }

    protected void handleRemoveMapping(Session session) {
        Map descriptors = session.getDescriptors();
        if (descriptors == null || descriptors.isEmpty()) {
            return;
        }
        for (ClassDescriptor classDescriptor : descriptors.values()) {
            List<RemoveMapping> removeMappings = this.scanForRemoveMappings(classDescriptor);
            if (removeMappings.isEmpty()) continue;
            ArrayList<DatabaseMapping> mappingsToRemove = new ArrayList<DatabaseMapping>();
            for (RemoveMapping removeMapping : removeMappings) {
                if (StringUtils.isBlank((String)removeMapping.name())) {
                    throw DescriptorException.attributeNameNotSpecified();
                }
                DatabaseMapping databaseMapping = classDescriptor.getMappingForAttributeName(removeMapping.name());
                if (databaseMapping == null) {
                    throw DescriptorException.mappingForAttributeIsMissing((String)removeMapping.name(), (ClassDescriptor)classDescriptor);
                }
                mappingsToRemove.add(databaseMapping);
            }
            for (DatabaseMapping mappingToRemove : mappingsToRemove) {
                classDescriptor.removeMappingForAttributeName(mappingToRemove.getAttributeName());
            }
        }
    }

    protected List<RemoveMapping> scanForRemoveMappings(ClassDescriptor classDescriptor) {
        ArrayList<RemoveMapping> removeMappings = new ArrayList<RemoveMapping>();
        RemoveMappings removeMappingsAnnotation = (RemoveMappings)AnnotationUtils.findAnnotation((Class)classDescriptor.getJavaClass(), RemoveMappings.class);
        if (removeMappingsAnnotation == null) {
            RemoveMapping removeMappingAnnotation = (RemoveMapping)AnnotationUtils.findAnnotation((Class)classDescriptor.getJavaClass(), RemoveMapping.class);
            if (removeMappingAnnotation != null) {
                removeMappings.add(removeMappingAnnotation);
            }
        } else {
            for (RemoveMapping removeMapping : removeMappingsAnnotation.value()) {
                removeMappings.add(removeMapping);
            }
        }
        return removeMappings;
    }

    protected List<Sequence> loadSequences(Session session) {
        Map descriptors = session.getDescriptors();
        ArrayList<PortableSequenceGenerator> sequenceGenerators = new ArrayList<PortableSequenceGenerator>();
        for (Class entityClass : descriptors.keySet()) {
            PortableSequenceGenerator sequenceGenerator = (PortableSequenceGenerator)AnnotationUtils.findAnnotation((Class)entityClass, PortableSequenceGenerator.class);
            if (sequenceGenerator != null) {
                sequenceGenerators.add(sequenceGenerator);
            }
            this.loadFieldSequences(entityClass, sequenceGenerators);
            for (Method method : entityClass.getMethods()) {
                PortableSequenceGenerator methodSequenceGenerator = method.getAnnotation(PortableSequenceGenerator.class);
                if (methodSequenceGenerator == null) continue;
                sequenceGenerators.add(methodSequenceGenerator);
            }
        }
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        for (PortableSequenceGenerator sequenceGenerator : sequenceGenerators) {
            MaxValueIncrementerSequenceWrapper sequence = new MaxValueIncrementerSequenceWrapper(sequenceGenerator);
            sequences.add(sequence);
        }
        return sequences;
    }

    protected void loadFieldSequences(Class<?> entityClass, List<PortableSequenceGenerator> sequenceGenerators) {
        for (Field field : entityClass.getDeclaredFields()) {
            PortableSequenceGenerator fieldSequenceGenerator = field.getAnnotation(PortableSequenceGenerator.class);
            if (fieldSequenceGenerator == null) continue;
            sequenceGenerators.add(fieldSequenceGenerator);
        }
        if (entityClass.getSuperclass() != null) {
            this.loadFieldSequences(entityClass.getSuperclass(), sequenceGenerators);
        }
    }

    private static final class MaxValueIncrementerSequenceWrapper
    extends Sequence {
        private static final long serialVersionUID = 2375805962996574386L;
        private final String sequenceName;

        MaxValueIncrementerSequenceWrapper(PortableSequenceGenerator sequenceGenerator) {
            super(sequenceGenerator.name(), 0);
            this.sequenceName = StringUtils.isBlank((String)sequenceGenerator.sequenceName()) ? sequenceGenerator.name() : sequenceGenerator.sequenceName();
        }

        public boolean shouldAcquireValueAfterInsert() {
            return false;
        }

        public boolean shouldUseTransaction() {
            return true;
        }

        public boolean shouldUsePreallocation() {
            return false;
        }

        public Object getGeneratedValue(Accessor accessor, AbstractSession writeSession, String seqName) {
            DataSource dataSource = ((JNDIConnector)writeSession.getLogin().getConnector()).getDataSource();
            DataFieldMaxValueIncrementer incrementer = MaxValueIncrementerFactory.getIncrementer(dataSource, this.sequenceName);
            return incrementer.nextLongValue();
        }

        public Vector<?> getGeneratedVector(Accessor accessor, AbstractSession writeSession, String seqName, int size) {
            throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName() + " does pre-generate sequence ids");
        }

        public void onConnect() {
        }

        public void onDisconnect() {
        }

        public MaxValueIncrementerSequenceWrapper clone() {
            return (MaxValueIncrementerSequenceWrapper)((Object)super.clone());
        }
    }
}

