/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.platform;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import org.kuali.rice.krad.data.platform.DatabasePlatformInfo;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public final class DatabasePlatforms {
    public static final String ORACLE = "Oracle";
    public static final String MYSQL = "MySQL";
    private static final ConcurrentMap<DataSource, DatabasePlatformInfo> platformCache = new ConcurrentHashMap<DataSource, DatabasePlatformInfo>();

    public static DatabasePlatformInfo detectPlatform(DataSource dataSource) {
        JdbcTemplate template;
        if (dataSource == null) {
            throw new IllegalArgumentException("DataSource must not be null.");
        }
        DatabasePlatformInfo platformInfo = (DatabasePlatformInfo)platformCache.get(dataSource);
        if (platformInfo == null && (platformInfo = platformCache.putIfAbsent(dataSource, (DatabasePlatformInfo)(template = new JdbcTemplate(dataSource)).execute((ConnectionCallback)new ConnectionCallback<DatabasePlatformInfo>(){

            public DatabasePlatformInfo doInConnection(Connection connection) throws SQLException, DataAccessException {
                DatabaseMetaData metadata = connection.getMetaData();
                String vendorName = metadata.getDatabaseProductName();
                int version = metadata.getDatabaseMajorVersion();
                return new DatabasePlatformInfo(vendorName, version);
            }
        }))) == null) {
            platformInfo = (DatabasePlatformInfo)platformCache.get(dataSource);
        }
        return platformInfo;
    }

    private DatabasePlatforms() {
    }
}

