/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.provider;

import java.util.ArrayList;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kuali.rice.krad.data.jpa.testbo.TestDataObject;
import org.kuali.rice.krad.data.metadata.DataObjectMetadata;
import org.kuali.rice.krad.data.provider.spring.SpringMetadataProviderImpl;

public class SpringMetadataProviderImplTest {
    SpringMetadataProviderImpl provider;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        BasicConfigurator.configure();
        Logger.getLogger(SpringMetadataProviderImpl.class).setLevel(Level.DEBUG);
    }

    @Before
    public void setUp() throws Exception {
        this.provider = new SpringMetadataProviderImpl();
    }

    @Test
    public void testInitializeMetadata() {
        ArrayList<String> springFileLocations = new ArrayList<String>();
        springFileLocations.add("classpath:org/kuali/rice/krad/data/provider/spring/krad-metadata-parent-beans.xml");
        springFileLocations.add("classpath:org/kuali/rice/krad/data/provider/spring/*");
        this.provider.setResourceLocations(springFileLocations);
        this.provider.initializeMetadata(null);
        Assert.assertNotNull((String)"Metadata map should not be null", (Object)this.provider.provideMetadata());
        Assert.assertFalse((String)"Metadata map should not have been empty", (boolean)this.provider.provideMetadata().isEmpty());
        DataObjectMetadata metadata = (DataObjectMetadata)this.provider.provideMetadata().get(TestDataObject.class);
        Assert.assertNotNull((String)"Metadata should have been retrieved for TestDataObject", (Object)metadata);
        Assert.assertEquals((String)"Label not read properly from metadata provider", (Object)"A Spring-Provided Label", (Object)metadata.getLabel());
        Assert.assertEquals((String)"backing object name not read properly from metadata provider", (Object)"ANOTHER_TABLE_NAME_T", (Object)metadata.getBackingObjectName());
    }
}

