/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.provider.annotation.impl;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.jpa.eclipselink.EclipseLinkJpaMetadataProviderImpl;
import org.kuali.rice.krad.data.jpa.testbo.ReferencedDataObject;
import org.kuali.rice.krad.data.jpa.testbo.SomeOtherCollection;
import org.kuali.rice.krad.data.jpa.testbo.TestDataObject;
import org.kuali.rice.krad.data.metadata.DataObjectAttribute;
import org.kuali.rice.krad.data.metadata.DataObjectAttributeRelationship;
import org.kuali.rice.krad.data.metadata.DataObjectCollection;
import org.kuali.rice.krad.data.metadata.DataObjectMetadata;
import org.kuali.rice.krad.data.provider.annotation.impl.AnnotationMetadataProviderImpl;
import org.kuali.rice.krad.data.provider.impl.CompositeMetadataProviderImpl;
import org.mockito.Mockito;

public class AnnotationMetadataProviderImplTest {
    static DataObjectService dataObjectService;
    static EclipseLinkJpaMetadataProviderImpl jpaMetadataProvider;
    CompositeMetadataProviderImpl compositeProvider;
    AnnotationMetadataProviderImpl annotationMetadataProvider;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        BasicConfigurator.configure();
        Logger.getLogger(CompositeMetadataProviderImpl.class).setLevel(Level.DEBUG);
        Logger.getLogger(AnnotationMetadataProviderImpl.class).setLevel(Level.DEBUG);
        Logger.getLogger(EclipseLinkJpaMetadataProviderImpl.class).setLevel(Level.DEBUG);
        dataObjectService = (DataObjectService)Mockito.mock(DataObjectService.class);
        jpaMetadataProvider = new EclipseLinkJpaMetadataProviderImpl();
        EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory((String)"krad-data-unit-test");
        jpaMetadataProvider.setEntityManager(entityManagerFactory.createEntityManager());
    }

    @Before
    public void setUp() throws Exception {
        this.annotationMetadataProvider = new AnnotationMetadataProviderImpl();
        this.annotationMetadataProvider.setDataObjectService(dataObjectService);
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(jpaMetadataProvider);
        providers.add(this.annotationMetadataProvider);
        this.compositeProvider = new CompositeMetadataProviderImpl();
        this.compositeProvider.setProviders(providers);
    }

    @Test
    public void testInitializeMetadataNoTypesProvided() {
        AnnotationMetadataProviderImpl provider = new AnnotationMetadataProviderImpl();
        provider.initializeMetadata(null);
        Assert.assertTrue((boolean)provider.isInitializationAttempted());
        Assert.assertTrue((boolean)provider.getSupportedTypes().isEmpty());
        Assert.assertFalse((boolean)provider.handles(TestDataObject.class));
    }

    @Test
    public void testProvideMetadata() {
        Assert.assertNotNull((String)"Metadata map should not be null", (Object)this.compositeProvider.provideMetadata());
        Assert.assertFalse((String)"Metadata map should not have been empty", (boolean)this.compositeProvider.provideMetadata().isEmpty());
        DataObjectMetadata metadata = (DataObjectMetadata)this.compositeProvider.provideMetadata().get(TestDataObject.class);
        Assert.assertNotNull((String)"Metadata should have been retrieved for TestDataObject", (Object)metadata);
        Assert.assertEquals((String)"Label not read properly from annotation metadata provider", (Object)"Label From Annotation", (Object)metadata.getLabel());
        Assert.assertFalse((String)"Attributes should still be present from the JPA metadata", (boolean)metadata.getAttributes().isEmpty());
        System.err.println(metadata);
    }

    @Test
    public void testBusinessKeyMetadata() {
        DataObjectMetadata metadata = (DataObjectMetadata)this.compositeProvider.provideMetadata().get(TestDataObject.class);
        Assert.assertEquals((String)"With no definition, the PK list and business key list should have been equal", (Object)metadata.getPrimaryKeyAttributeNames(), (Object)metadata.getBusinessKeyAttributeNames());
        metadata = (DataObjectMetadata)this.compositeProvider.provideMetadata().get(ReferencedDataObject.class);
        Assert.assertNotEquals((String)"When @BusinessKey used, the PK list and business key list should not have been equal", (Object)metadata.getPrimaryKeyAttributeNames(), (Object)metadata.getBusinessKeyAttributeNames());
        Assert.assertEquals((String)"When a business key is defined, the primary display attribute should be the last field on that", (Object)"someOtherStringProperty", (Object)metadata.getPrimaryDisplayAttributeName());
    }

    @Test
    public void testMergedAttribute() {
        DataObjectMetadata metadata = (DataObjectMetadata)this.compositeProvider.provideMetadata().get(TestDataObject.class);
        Assert.assertNotNull((String)"Metadata should have been retrieved for TestDataObject", (Object)metadata);
        List attributes = metadata.getAttributes();
        Assert.assertFalse((String)"Attributes should still be present from the JPA metadata", (boolean)attributes.isEmpty());
        Assert.assertNotNull((String)"getAttribute(stringProperty) should not have returned null", (Object)metadata.getAttribute("stringProperty"));
        Assert.assertEquals((String)"getAttribute(nonPersistedProperty) label incorrect", (Object)"Attribute Label From Annotation", (Object)metadata.getAttribute("stringProperty").getLabel());
    }

    @Test
    public void testNonPersistableProperty() {
        DataObjectMetadata metadata = (DataObjectMetadata)this.compositeProvider.provideMetadata().get(TestDataObject.class);
        Assert.assertNotNull((String)"Metadata should have been retrieved for TestDataObject", (Object)metadata);
        System.err.println(metadata);
        DataObjectAttribute attr = metadata.getAttribute("keyAndString");
        Assert.assertNotNull((String)"keyAndString property does not exist", (Object)attr);
        Assert.assertEquals((String)"keyAndString label incorrect", (Object)"Test Data Object", (Object)attr.getLabel());
    }

    @Test
    public void testInheritedProperties() {
        DataObjectMetadata metadata = (DataObjectMetadata)this.compositeProvider.provideMetadata().get(TestDataObject.class);
        Assert.assertNotNull((String)"Metadata should have been retrieved for TestDataObject", (Object)metadata);
        String propName = "referencedObject.someOtherStringProperty";
        DataObjectAttribute attr = metadata.getAttribute(propName);
        Assert.assertNotNull((String)("getAttribute(" + propName + ") should not have returned null"), (Object)attr);
        Assert.assertTrue((String)"Attribute should have isInherited", (boolean)attr.isInherited());
        Assert.assertEquals((String)"Inherited data object type not set", ReferencedDataObject.class, (Object)attr.getInheritedFromType());
        Assert.assertEquals((String)"Inherited data object parent attribute not set", (Object)"referencedObject", (Object)attr.getInheritedFromParentAttributeName());
        Assert.assertEquals((String)"Inherited data object attribute not set", (Object)"someOtherStringProperty", (Object)attr.getInheritedFromAttributeName());
        Assert.assertEquals((String)"Label incorrect", (Object)"RDOs Business Key", (Object)attr.getLabel());
    }

    @Test
    public void testOrderingOfInheritedProperties() {
        DataObjectMetadata metadata = (DataObjectMetadata)this.compositeProvider.provideMetadata().get(TestDataObject.class);
        Assert.assertNotNull((String)"Metadata should have been retrieved for TestDataObject", (Object)metadata);
        List attributes = metadata.getAttributes();
        int indexOfPriorProperty = -1;
        for (int i = 0; i < attributes.size(); ++i) {
            if (!((DataObjectAttribute)attributes.get(i)).getName().equals("nonStandardDataType")) continue;
            indexOfPriorProperty = i;
            break;
        }
        Assert.assertFalse((String)"Unable to find nonStandardDataType Property", (indexOfPriorProperty == -1 ? 1 : 0) != 0);
        Assert.assertFalse((String)"nonStandardDataType should not have been the last property", (indexOfPriorProperty + 1 == attributes.size() ? 1 : 0) != 0);
        DataObjectAttribute attr = (DataObjectAttribute)attributes.get(indexOfPriorProperty + 1);
        Assert.assertEquals((String)"Property property after nonStandardDataType not correct: ", (Object)"referencedObject.someOtherStringProperty", (Object)attr.getName());
    }

    @Test
    public void testInheritedProperties_labelOverride() {
        DataObjectMetadata metadata = (DataObjectMetadata)this.compositeProvider.provideMetadata().get(TestDataObject.class);
        Assert.assertNotNull((String)"Metadata should have been retrieved for TestDataObject", (Object)metadata);
        Assert.assertNotNull((String)"getAttribute(anotherReferencedObject.someOtherStringProperty) should not have returned null", (Object)metadata.getAttribute("anotherReferencedObject.someOtherStringProperty"));
        Assert.assertEquals((String)"Label incorrect", (Object)"Overridden Inherited Property Label", (Object)metadata.getAttribute("anotherReferencedObject.someOtherStringProperty").getLabel());
    }

    @Test
    public void testReadOnlyAnnotation() {
        DataObjectMetadata metadata = (DataObjectMetadata)this.compositeProvider.provideMetadata().get(TestDataObject.class);
        Assert.assertNotNull((String)"Metadata should have been retrieved for TestDataObject", (Object)metadata);
        Assert.assertNotNull((String)"getAttribute(readOnlyProperty) should not have returned null", (Object)metadata.getAttribute("readOnlyProperty"));
        Assert.assertEquals((String)"readonly flag not set", (Object)true, (Object)metadata.getAttribute("readOnlyProperty").isReadOnly());
    }

    @Test
    public void testForceUppercaseAnnotation() {
        DataObjectMetadata metadata = (DataObjectMetadata)this.compositeProvider.provideMetadata().get(TestDataObject.class);
        Assert.assertNotNull((String)"Metadata should have been retrieved for TestDataObject", (Object)metadata);
        Assert.assertNotNull((String)"getAttribute(primaryKeyProperty) should not have returned null", (Object)metadata.getAttribute("primaryKeyProperty"));
        Assert.assertTrue((String)"forceUppercase flag not set", (boolean)metadata.getAttribute("primaryKeyProperty").isForceUppercase());
        Assert.assertNotNull((String)"getAttribute(readOnlyProperty) should not have returned null", (Object)metadata.getAttribute("readOnlyProperty"));
        Assert.assertFalse((String)"forceUppercase flag should not have been set", (boolean)metadata.getAttribute("readOnlyProperty").isForceUppercase());
    }

    @Test
    public void testCollectionAnnotation_derivedType() {
        DataObjectMetadata metadata = (DataObjectMetadata)this.compositeProvider.provideMetadata().get(TestDataObject.class);
        Assert.assertNotNull((String)"Metadata should have been retrieved for TestDataObject", (Object)metadata);
        DataObjectCollection collection = metadata.getCollection("someOtherCollection");
        Assert.assertNotNull((String)"someOtherCollection not defined", (Object)collection);
        System.err.println(collection);
        Assert.assertEquals((String)"element class is incorrect", SomeOtherCollection.class, (Object)collection.getRelatedType());
        Assert.assertEquals((String)"collection label incorrect", (Object)"Some Other Collection", (Object)collection.getLabel());
        Assert.assertEquals((String)"collection item label incorrect", (Object)"Some Other Collection", (Object)collection.getElementLabel());
        Assert.assertNotNull((String)"attribute relationships must not be null", (Object)collection.getAttributeRelationships());
        Assert.assertEquals((String)"Wrong number of relationship columns", (long)1L, (long)collection.getAttributeRelationships().size());
        Assert.assertEquals((String)"Parent attribute name incorrect", (Object)"dateProperty", (Object)((DataObjectAttributeRelationship)collection.getAttributeRelationships().get(0)).getParentAttributeName());
        Assert.assertEquals((String)"Child attribute name incorrect", (Object)"collectionDateProperty", (Object)((DataObjectAttributeRelationship)collection.getAttributeRelationships().get(0)).getChildAttributeName());
    }
}

