/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa;

import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.persistence.EntityManager;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceException;
import javax.persistence.metamodel.ManagedType;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.sessions.CopyGroup;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.krad.data.CompoundKey;
import org.kuali.rice.krad.data.CopyOption;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.DataObjectWrapper;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.data.jpa.JpaCriteriaQuery;
import org.kuali.rice.krad.data.metadata.DataObjectCollection;
import org.kuali.rice.krad.data.metadata.DataObjectMetadata;
import org.kuali.rice.krad.data.metadata.DataObjectRelationship;
import org.kuali.rice.krad.data.provider.PersistenceProvider;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.ChainedPersistenceExceptionTranslator;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.transaction.annotation.Transactional;

public class JpaPersistenceProvider
implements PersistenceProvider,
BeanFactoryAware {
    private static final Logger LOG = Logger.getLogger(JpaPersistenceProvider.class);
    public static final String AUTO_FLUSH = "rice.krad.data.jpa.autoFlush";
    private EntityManager sharedEntityManager;
    private DataObjectService dataObjectService;
    private PersistenceExceptionTranslator persistenceExceptionTranslator;
    private Set<Class<?>> managedTypesCache;

    public EntityManager getSharedEntityManager() {
        return this.sharedEntityManager;
    }

    public void setSharedEntityManager(EntityManager sharedEntityManager) {
        this.sharedEntityManager = sharedEntityManager;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ListableBeanFactory)) {
            throw new IllegalArgumentException("Cannot use PersistenceExceptionTranslator autodetection without ListableBeanFactory");
        }
        this.persistenceExceptionTranslator = this.detectPersistenceExceptionTranslators((ListableBeanFactory)beanFactory);
    }

    protected PersistenceExceptionTranslator detectPersistenceExceptionTranslators(ListableBeanFactory beanFactory) {
        Map pets = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, PersistenceExceptionTranslator.class, (boolean)false, (boolean)false);
        ChainedPersistenceExceptionTranslator cpet = new ChainedPersistenceExceptionTranslator();
        for (PersistenceExceptionTranslator pet : pets.values()) {
            cpet.addDelegate(pet);
        }
        cpet.addDelegate((PersistenceExceptionTranslator)new DefaultPersistenceExceptionTranslator());
        return cpet;
    }

    @Override
    @Transactional
    public <T> T save(final T dataObject, final PersistenceOption ... options) {
        return this.doWithExceptionTranslation(new Callable<T>(){

            @Override
            public T call() {
                JpaPersistenceProvider.this.verifyDataObjectWritable(dataObject);
                HashSet optionSet = Sets.newHashSet((Object[])options);
                Object mergedDataObject = JpaPersistenceProvider.this.sharedEntityManager.merge(dataObject);
                if (optionSet.contains(PersistenceOption.FLUSH) || optionSet.contains(PersistenceOption.LINK_KEYS) || LazyConfigHolder.autoFlush) {
                    JpaPersistenceProvider.this.sharedEntityManager.flush();
                }
                if (JpaPersistenceProvider.this.sharedEntityManager.getEntityManagerFactory().getCache() != null) {
                    try {
                        Object dataObjectKey = JpaPersistenceProvider.this.sharedEntityManager.getEntityManagerFactory().getPersistenceUnitUtil().getIdentifier(mergedDataObject);
                        if (dataObjectKey != null) {
                            JpaPersistenceProvider.this.sharedEntityManager.getEntityManagerFactory().getCache().evict(dataObject.getClass(), dataObjectKey);
                        }
                    }
                    catch (PersistenceException persistenceException) {
                        // empty catch block
                    }
                }
                return mergedDataObject;
            }
        });
    }

    @Override
    @Transactional(readOnly=true)
    public <T> T find(final Class<T> type, final Object id) {
        return this.doWithExceptionTranslation(new Callable<T>(){

            @Override
            public T call() {
                if (id instanceof CompoundKey) {
                    QueryResults results = JpaPersistenceProvider.this.findMatching(type, QueryByCriteria.Builder.andAttributes(((CompoundKey)id).getKeys()).build());
                    if (results.getResults().size() > 1) {
                        throw new NonUniqueResultException("Error Compound Key: " + id + " on class " + type.getName() + " returned more than one row.");
                    }
                    if (!results.getResults().isEmpty()) {
                        return results.getResults().get(0);
                    }
                    return null;
                }
                return JpaPersistenceProvider.this.sharedEntityManager.find(type, id);
            }
        });
    }

    @Override
    @Transactional(readOnly=true)
    public <T> QueryResults<T> findMatching(final Class<T> type, final QueryByCriteria queryByCriteria) {
        return (QueryResults)this.doWithExceptionTranslation(new Callable<QueryResults<T>>(){

            @Override
            public QueryResults<T> call() {
                return new JpaCriteriaQuery(JpaPersistenceProvider.this.sharedEntityManager).lookup(type, queryByCriteria);
            }
        });
    }

    @Override
    @Transactional(readOnly=true)
    public <T> QueryResults<T> findAll(final Class<T> type) {
        return (QueryResults)this.doWithExceptionTranslation(new Callable<QueryResults<T>>(){

            @Override
            public QueryResults<T> call() {
                return new JpaCriteriaQuery(JpaPersistenceProvider.this.getSharedEntityManager()).lookup(type, QueryByCriteria.Builder.create().build());
            }
        });
    }

    @Override
    @Transactional
    public void delete(final Object dataObject) {
        this.doWithExceptionTranslation(new Callable<Object>(){

            @Override
            public Object call() {
                JpaPersistenceProvider.this.verifyDataObjectWritable(dataObject);
                if (JpaPersistenceProvider.this.sharedEntityManager.getEntityManagerFactory().getCache() != null) {
                    try {
                        Object dataObjectKey = JpaPersistenceProvider.this.sharedEntityManager.getEntityManagerFactory().getPersistenceUnitUtil().getIdentifier(dataObject);
                        if (dataObjectKey != null) {
                            JpaPersistenceProvider.this.sharedEntityManager.getEntityManagerFactory().getCache().evict(dataObject.getClass(), dataObjectKey);
                        }
                    }
                    catch (PersistenceException dataObjectKey) {
                        // empty catch block
                    }
                }
                Object mergedDataObject = JpaPersistenceProvider.this.sharedEntityManager.merge(dataObject);
                JpaPersistenceProvider.this.sharedEntityManager.remove(mergedDataObject);
                return null;
            }
        });
    }

    @Override
    @Transactional
    public <T> void deleteMatching(final Class<T> type, final QueryByCriteria queryByCriteria) {
        this.doWithExceptionTranslation(new Callable<Object>(){

            @Override
            public Object call() {
                new JpaCriteriaQuery(JpaPersistenceProvider.this.getSharedEntityManager()).deleteMatching(type, queryByCriteria);
                if (JpaPersistenceProvider.this.sharedEntityManager.getEntityManagerFactory().getCache() != null) {
                    JpaPersistenceProvider.this.sharedEntityManager.getEntityManagerFactory().getCache().evict(type);
                }
                return null;
            }
        });
    }

    @Override
    @Transactional
    public <T> void deleteAll(final Class<T> type) {
        this.doWithExceptionTranslation(new Callable<Object>(){

            @Override
            public Object call() {
                new JpaCriteriaQuery(JpaPersistenceProvider.this.getSharedEntityManager()).deleteAll(type);
                if (JpaPersistenceProvider.this.sharedEntityManager.getEntityManagerFactory().getCache() != null) {
                    JpaPersistenceProvider.this.sharedEntityManager.getEntityManagerFactory().getCache().evict(type);
                }
                return null;
            }
        });
    }

    @Override
    @Transactional
    public <T> T copyInstance(final T dataObject, CopyOption ... options) {
        boolean shouldResetVersionNumber;
        final CopyGroup copyGroup = new CopyGroup();
        if (ArrayUtils.contains((Object[])options, (Object)CopyOption.RESET_PK_FIELDS)) {
            copyGroup.setShouldResetPrimaryKey(true);
        }
        if (shouldResetVersionNumber = ArrayUtils.contains((Object[])options, (Object)CopyOption.RESET_VERSION_NUMBER)) {
            copyGroup.setShouldResetVersion(true);
        }
        final boolean shouldResetObjectId = ArrayUtils.contains((Object[])options, (Object)CopyOption.RESET_OBJECT_ID);
        return this.doWithExceptionTranslation(new Callable<T>(){

            @Override
            public T call() {
                Object copiedObject = ((JpaEntityManager)JpaPersistenceProvider.this.sharedEntityManager.unwrap(JpaEntityManager.class)).getDatabaseSession().copy(dataObject, (AttributeGroup)copyGroup);
                if (shouldResetObjectId) {
                    JpaPersistenceProvider.this.clearObjectIdOnUpdatableObjects(copiedObject, new HashSet<Object>());
                }
                if (shouldResetVersionNumber) {
                    JpaPersistenceProvider.this.clearVersionNumberOnUpdatableObjects(copiedObject, new HashSet<Object>());
                }
                return copiedObject;
            }
        });
    }

    protected void clearObjectIdOnUpdatableObjects(Object dataObject, Set<Object> visitedObjects) {
        DataObjectWrapper<Object> wrapper;
        if (dataObject == null) {
            return;
        }
        if (visitedObjects.contains(dataObject)) {
            return;
        }
        visitedObjects.add(dataObject);
        if (dataObject instanceof GloballyUnique) {
            try {
                PropertyUtils.setSimpleProperty((Object)dataObject, (String)"objectId", null);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                LOG.warn((Object)("Unable to clear the objectId from copyInstance on an object: " + dataObject), (Throwable)ex);
            }
        }
        if ((wrapper = KradDataServiceLocator.getDataObjectService().wrap(dataObject)).getMetadata() != null) {
            for (DataObjectRelationship dataObjectRelationship : wrapper.getMetadata().getRelationships()) {
                if (!dataObjectRelationship.isSavedWithParent()) continue;
                this.clearObjectIdOnUpdatableObjects(wrapper.getPropertyValue(dataObjectRelationship.getName()), visitedObjects);
            }
            for (DataObjectCollection dataObjectCollection : wrapper.getMetadata().getCollections()) {
                Collection collection;
                if (!dataObjectCollection.isSavedWithParent() || (collection = (Collection)wrapper.getPropertyValue(dataObjectCollection.getName())) == null) continue;
                for (Object element : collection) {
                    this.clearObjectIdOnUpdatableObjects(element, visitedObjects);
                }
            }
        }
    }

    protected void clearVersionNumberOnUpdatableObjects(Object dataObject, Set<Object> visitedObjects) {
        DataObjectWrapper<Object> wrapper;
        if (dataObject == null) {
            return;
        }
        if (visitedObjects.contains(dataObject)) {
            return;
        }
        visitedObjects.add(dataObject);
        if (dataObject instanceof Versioned) {
            try {
                PropertyUtils.setSimpleProperty((Object)dataObject, (String)"versionNumber", null);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                LOG.warn((Object)("Unable to clear the objectId from copyInstance on an object: " + dataObject), (Throwable)ex);
            }
        }
        if ((wrapper = KradDataServiceLocator.getDataObjectService().wrap(dataObject)).getMetadata() != null) {
            for (DataObjectRelationship dataObjectRelationship : wrapper.getMetadata().getRelationships()) {
                if (!dataObjectRelationship.isSavedWithParent()) continue;
                this.clearVersionNumberOnUpdatableObjects(wrapper.getPropertyValue(dataObjectRelationship.getName()), visitedObjects);
            }
            for (DataObjectCollection dataObjectCollection : wrapper.getMetadata().getCollections()) {
                Collection collection;
                if (!dataObjectCollection.isSavedWithParent() || (collection = (Collection)wrapper.getPropertyValue(dataObjectCollection.getName())) == null) continue;
                for (Object element : collection) {
                    this.clearVersionNumberOnUpdatableObjects(element, visitedObjects);
                }
            }
        }
    }

    @Override
    public boolean handles(Class<?> type) {
        if (this.managedTypesCache == null) {
            this.managedTypesCache = new HashSet();
            Set managedTypes = this.sharedEntityManager.getMetamodel().getManagedTypes();
            for (ManagedType managedType : managedTypes) {
                this.managedTypesCache.add(managedType.getJavaType());
            }
        }
        return this.managedTypesCache.contains(type);
    }

    @Override
    @Transactional(readOnly=true)
    public void flush(Class<?> type) {
        this.doWithExceptionTranslation(new Callable<Object>(){

            @Override
            public Object call() {
                JpaPersistenceProvider.this.sharedEntityManager.flush();
                return null;
            }
        });
    }

    protected void verifyDataObjectWritable(Object dataObject) {
        DataObjectMetadata metaData = this.dataObjectService.getMetadataRepository().getMetadata(dataObject.getClass());
        if (metaData == null) {
            throw new IllegalArgumentException("Given data object class is not loaded into the MetadataRepository: " + dataObject.getClass());
        }
        if (metaData.isReadOnly()) {
            throw new UnsupportedOperationException(dataObject.getClass() + " is read-only");
        }
    }

    protected <T> T doWithExceptionTranslation(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (RuntimeException ex) {
            throw DataAccessUtils.translateIfNecessary((RuntimeException)ex, (PersistenceExceptionTranslator)this.persistenceExceptionTranslator);
        }
        catch (Exception ex) {
            throw new RiceRuntimeException("Unexpected checked exception during data access.", (Throwable)ex);
        }
    }

    private static final class DefaultPersistenceExceptionTranslator
    implements PersistenceExceptionTranslator {
        private DefaultPersistenceExceptionTranslator() {
        }

        public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
            return EntityManagerFactoryUtils.convertJpaAccessExceptionIfPossible((RuntimeException)ex);
        }
    }

    private static final class LazyConfigHolder {
        private static final boolean autoFlush = ConfigContext.getCurrentContextConfig().getBooleanProperty("rice.krad.data.jpa.autoFlush", false);

        private LazyConfigHolder() {
        }
    }
}

