/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.web.health;

import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonProperty;

public class HealthMetric {
    @JsonProperty(value="Measure")
    private final String measure;
    @JsonProperty(value="Metric")
    private final String metric;
    @JsonProperty(value="Value")
    private final Object value;

    public HealthMetric(String name, Object value) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("Metric name must not be blank");
        }
        String[] nameParts = name.split(":");
        if (nameParts.length != 2 || nameParts[0].isEmpty() || nameParts[1].isEmpty()) {
            throw new IllegalArgumentException("Metric name was not valid, should be two non-blank parts separated by ':'. Instead was " + name);
        }
        this.measure = nameParts[0];
        this.metric = nameParts[1];
        this.value = value;
    }

    public HealthMetric(String measure, String metric, Object value) {
        if (StringUtils.isBlank((String)measure)) {
            throw new IllegalArgumentException("measure name must not be blank");
        }
        if (StringUtils.isBlank((String)metric)) {
            throw new IllegalArgumentException("metric name must not be blank");
        }
        this.measure = measure;
        this.metric = metric;
        this.value = value;
    }

    public String getMeasure() {
        return this.measure;
    }

    public String getMetric() {
        return this.metric;
    }

    public Object getValue() {
        return this.value;
    }
}

