/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.web.health;

import com.amazonaws.services.s3.AmazonS3;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.health.HealthCheck;
import java.util.List;

public class AmazonS3ConnectionHealthGauge
extends HealthCheck
implements Gauge<Boolean> {
    private final AmazonS3 amazonS3;

    public AmazonS3ConnectionHealthGauge(AmazonS3 amazonS3) {
        this.amazonS3 = amazonS3;
    }

    public Boolean getValue() {
        HealthCheck.Result result = this.execute();
        return result.isHealthy();
    }

    protected HealthCheck.Result check() throws Exception {
        List buckets = this.amazonS3.listBuckets();
        if (buckets.isEmpty()) {
            return HealthCheck.Result.unhealthy((String)"Amazon S3 returned an empty list of buckets, there should be at least one.");
        }
        return HealthCheck.Result.healthy();
    }
}

