/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.kim;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.coreservice.api.CoreServiceApiServiceLocator;
import org.kuali.rice.coreservice.api.namespace.Namespace;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.impl.permission.PermissionBo;
import org.kuali.rice.krad.kim.NamespacePermissionTypeServiceImpl;

public class NamespaceWildcardAllowedAndOrStringExactMatchPermissionTypeServiceImpl
extends NamespacePermissionTypeServiceImpl {
    protected static final String NAMESPACE_CODE = "namespaceCode";
    protected String exactMatchStringAttributeName;
    protected boolean namespaceRequiredOnStoredMap;
    private List<String> requiredAttributes = new ArrayList<String>();

    protected List<String> getRequiredAttributes() {
        return Collections.unmodifiableList(this.requiredAttributes);
    }

    @Override
    protected List<Permission> performPermissionMatches(Map<String, String> requestedDetails, List<Permission> permissionsList) {
        List<Permission> matchingWithNamespace;
        ArrayList<Permission> matchingPermissions = new ArrayList<Permission>();
        ArrayList<Permission> matchingBlankPermissions = new ArrayList<Permission>();
        String requestedAttributeValue = requestedDetails.get(this.exactMatchStringAttributeName);
        for (Permission kpi : permissionsList) {
            PermissionBo bo = PermissionBo.from((Permission)kpi);
            String permissionAttributeValue = (String)bo.getDetails().get(this.exactMatchStringAttributeName);
            if (StringUtils.equals((String)requestedAttributeValue, (String)permissionAttributeValue)) {
                matchingPermissions.add(kpi);
                continue;
            }
            if (!StringUtils.isBlank((String)permissionAttributeValue)) continue;
            matchingBlankPermissions.add(kpi);
        }
        if (!matchingPermissions.isEmpty()) {
            matchingWithNamespace = super.performPermissionMatches(requestedDetails, matchingPermissions);
            if (!this.namespaceRequiredOnStoredMap && matchingWithNamespace.isEmpty()) {
                return matchingPermissions;
            }
            return matchingWithNamespace;
        }
        if (!matchingBlankPermissions.isEmpty()) {
            matchingWithNamespace = super.performPermissionMatches(requestedDetails, matchingBlankPermissions);
            if (!this.namespaceRequiredOnStoredMap && matchingWithNamespace.isEmpty()) {
                return matchingBlankPermissions;
            }
            return matchingWithNamespace;
        }
        return matchingPermissions;
    }

    public void setExactMatchStringAttributeName(String exactMatchStringAttributeName) {
        this.exactMatchStringAttributeName = exactMatchStringAttributeName;
        this.requiredAttributes.add(exactMatchStringAttributeName);
    }

    public void setNamespaceRequiredOnStoredMap(boolean namespaceRequiredOnStoredMap) {
        this.namespaceRequiredOnStoredMap = namespaceRequiredOnStoredMap;
    }

    protected List<RemotableAttributeError> validateReferencesExistAndActive(KimType kimType, Map<String, String> attributes, List<RemotableAttributeError> previousValidationErrors) {
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        HashMap<String, String> nonNamespaceCodeAttributes = new HashMap<String, String>(attributes);
        if (attributes.containsKey(NAMESPACE_CODE)) {
            Namespace namespace;
            nonNamespaceCodeAttributes.remove(NAMESPACE_CODE);
            Namespace namespace2 = namespace = StringUtils.isBlank((String)attributes.get(NAMESPACE_CODE)) ? null : CoreServiceApiServiceLocator.getNamespaceService().getNamespace(attributes.get(NAMESPACE_CODE));
            if (namespace != null) {
                errors.addAll(super.validateReferencesExistAndActive(kimType, Collections.singletonMap(NAMESPACE_CODE, namespace.getCode()), previousValidationErrors));
            } else {
                errors.addAll(super.validateReferencesExistAndActive(kimType, Collections.singletonMap(NAMESPACE_CODE, attributes.get(NAMESPACE_CODE)), previousValidationErrors));
            }
        }
        errors.addAll(super.validateReferencesExistAndActive(kimType, nonNamespaceCodeAttributes, previousValidationErrors));
        return errors;
    }
}

