/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.exception.ExceptionIncident;
import org.kuali.rice.krad.exception.KualiExceptionIncident;
import org.kuali.rice.krad.service.KualiExceptionIncidentService;
import org.kuali.rice.krad.service.impl.KualiFeedbackServiceImpl;

public class KualiExceptionIncidentServiceImpl
extends KualiFeedbackServiceImpl
implements KualiExceptionIncidentService {
    private Logger LOG = Logger.getLogger(KualiExceptionIncidentServiceImpl.class);
    private String incidentMailingList;
    public static final String REPORT_MAIL_LIST = String.format("%s.REPORT_MAIL_LIST", KualiExceptionIncidentServiceImpl.class.getSimpleName());

    @Override
    protected String getToAddressesPropertyName() {
        return REPORT_MAIL_LIST;
    }

    public void report(KualiExceptionIncident exceptionIncident) throws Exception {
        String lm;
        if (this.LOG.isTraceEnabled()) {
            lm = String.format("ENTRY %s", exceptionIncident == null ? "null" : exceptionIncident.toString());
            this.LOG.trace((Object)lm);
        }
        this.emailReport(exceptionIncident.getProperty("exceptionReportSubject"), exceptionIncident.getProperty("exceptionReportMessage"));
        if (this.LOG.isTraceEnabled()) {
            lm = String.format("EXIT", new Object[0]);
            this.LOG.trace((Object)lm);
        }
    }

    public List<String> split(String s, String token) {
        if (this.LOG.isTraceEnabled()) {
            String lm = String.format("ENTRY %s;%s", s, token);
            this.LOG.trace((Object)lm);
        }
        String[] sarray = s.split(token);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < sarray.length && sarray[i].length() > 0; ++i) {
            list.add(sarray[i]);
        }
        if (this.LOG.isTraceEnabled()) {
            String lm = String.format("EXIT %s", ((Object)list).toString());
            this.LOG.trace((Object)lm);
        }
        return list;
    }

    public KualiExceptionIncident getExceptionIncident(Exception exception, Map<String, String> properties) {
        if (exception == null) {
            return this.getExceptionIncident(properties);
        }
        if (this.LOG.isTraceEnabled()) {
            String lm = String.format("ENTRY %s;%s", exception.getMessage(), properties.toString());
            this.LOG.trace((Object)lm);
        }
        ExceptionIncident ei = new ExceptionIncident(exception, properties);
        if (this.LOG.isTraceEnabled()) {
            String lm = String.format("EXIT %s", ei.toProperties().toString());
            this.LOG.trace((Object)lm);
        }
        return ei;
    }

    public KualiExceptionIncident getExceptionIncident(Map<String, String> properties) {
        if (this.LOG.isTraceEnabled()) {
            String lm = String.format("ENTRY %s", properties.toString());
            this.LOG.trace((Object)lm);
        }
        ExceptionIncident ei = new ExceptionIncident(properties);
        if (this.LOG.isTraceEnabled()) {
            String lm = String.format("EXIT %s", ei.toProperties().toString());
            this.LOG.trace((Object)lm);
        }
        return ei;
    }

    public String getIncidentMailingList() {
        return this.incidentMailingList;
    }

    public void setIncidentMailingList(String incidentMailingList) {
        this.incidentMailingList = incidentMailingList;
    }
}

