/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.service.impl;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.krad.datadictionary.validator.ValidationController;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.service.ViewHelperService;
import org.kuali.rice.krad.uif.service.ViewService;
import org.kuali.rice.krad.uif.service.ViewTypeService;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.web.form.UifFormBase;

public class ViewServiceImpl
implements ViewService {
    private static final Logger LOG = Logger.getLogger(ViewServiceImpl.class);
    private DataDictionaryService dataDictionaryService;
    private List<ViewTypeService> viewTypeServices;

    public View getViewById(String viewId) {
        View view;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("retrieving view instance for id: " + viewId));
        }
        if ((view = this.dataDictionaryService.getViewById(viewId)) == null) {
            LOG.warn((Object)("View not found for id: " + viewId));
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Updating view status to CREATED for view: " + view.getId()));
            }
            view.setViewStatus("C");
        }
        return view;
    }

    public View getViewByType(UifConstants.ViewType viewType, Map<String, String> parameters) {
        ViewTypeService typeService = this.getViewTypeService(viewType);
        if (typeService == null) {
            throw new RuntimeException("Unable to find view type service for view type name: " + viewType);
        }
        Map typeParameters = typeService.getParametersFromRequest(parameters);
        View view = this.dataDictionaryService.getViewByTypeIndex(viewType, typeParameters);
        if (view == null) {
            LOG.warn((Object)("View not found for type: " + viewType));
        } else {
            LOG.debug((Object)("Updating view status to CREATED for view: " + view.getId()));
            view.setViewStatus("C");
        }
        return view;
    }

    public String getViewIdForViewType(UifConstants.ViewType viewType, Map<String, String> parameters) {
        ViewTypeService typeService = this.getViewTypeService(viewType);
        if (typeService == null) {
            throw new RuntimeException("Unable to find view type service for view type name: " + viewType);
        }
        Map typeParameters = typeService.getParametersFromRequest(parameters);
        return this.dataDictionaryService.getViewIdByTypeIndex(viewType, typeParameters);
    }

    public void buildView(View view, Object model, Map<String, String> parameters) {
        ViewHelperService helperService = view.getViewHelperService();
        helperService.populateViewFromRequestParameters(view, parameters);
        ((UifFormBase)model).setViewRequestParameters(view.getViewRequestParameters());
        this.performViewLifecycle(view, model, parameters);
        if (CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsBoolean("validate.views.onbuild")) {
            ValidationController validator = new ValidationController(true, true, true, true, false);
            Log tempLogger = LogFactory.getLog(ViewServiceImpl.class);
            validator.validate((Component)view, tempLogger, false);
        }
    }

    protected void performViewLifecycle(View view, Object model, Map<String, String> parameters) {
        ViewHelperService helperService = view.getViewHelperService();
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("performing initialize phase for view: " + view.getId()));
        }
        helperService.performInitialization(view, model);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("processing indexing for view: " + view.getId()));
        }
        view.index();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating view status to INITIALIZED for view: " + view.getId()));
        }
        view.setViewStatus("I");
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("performing apply model phase for view: " + view.getId()));
        }
        helperService.performApplyModel(view, model);
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("reindexing after apply model for view: " + view.getId()));
        }
        view.index();
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("performing finalize phase for view: " + view.getId()));
        }
        helperService.performFinalize(view, model);
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("processing final indexing for view: " + view.getId()));
        }
        view.index();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating view status to FINAL for view: " + view.getId()));
        }
        view.setViewStatus("F");
    }

    public ViewTypeService getViewTypeService(UifConstants.ViewType viewType) {
        if (this.viewTypeServices != null) {
            for (ViewTypeService typeService : this.viewTypeServices) {
                if (!viewType.equals((Object)typeService.getViewTypeName())) continue;
                return typeService;
            }
        }
        return null;
    }

    public List<ViewTypeService> getViewTypeServices() {
        return this.viewTypeServices;
    }

    public void setViewTypeServices(List<ViewTypeService> viewTypeServices) {
        this.viewTypeServices = viewTypeServices;
    }

    protected DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

