/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.coreservice.api.CoreServiceApiServiceLocator;
import org.kuali.rice.coreservice.api.component.Component;
import org.kuali.rice.coreservice.api.component.ComponentService;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.krad.datadictionary.DataObjectEntry;
import org.kuali.rice.krad.datadictionary.DocumentEntry;
import org.kuali.rice.krad.datadictionary.TransactionalDocumentEntry;
import org.kuali.rice.krad.document.TransactionalDocument;
import org.kuali.rice.krad.service.DataDictionaryComponentPublisherService;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.util.KRADUtils;

public class DataDictionaryComponentPublisherServiceImpl
implements DataDictionaryComponentPublisherService {
    private static final Logger LOG = Logger.getLogger(DataDictionaryComponentPublisherServiceImpl.class);
    private static final String DEFAULT_COMPONENT_SET_ID_PREFIX = "DD:";
    private DataDictionaryService dataDictionaryService;
    private KualiModuleService kualiModuleService;
    private ComponentService componentService;
    private String applicationId;

    public void publishAllComponents() {
        List<Component> componentsToPublish = this.getComponentsToPublish();
        this.getComponentService().publishDerivedComponents(this.generateComponentSetId(), componentsToPublish);
    }

    protected String generateComponentSetId() {
        if (StringUtils.isBlank((String)this.getApplicationId())) {
            throw new ConfigurationException("A valid non-null, non-blank application id was not injected into " + this.getClass().getName());
        }
        return DEFAULT_COMPONENT_SET_ID_PREFIX + this.getApplicationId();
    }

    protected List<Component> getComponentsToPublish() {
        Component component;
        ArrayList<Component> components = new ArrayList<Component>();
        HashMap<String, Component> uniqueComponentMap = new HashMap<String, Component>();
        for (DataObjectEntry dataObjectEntry : this.getDataDictionaryService().getDataDictionary().getDataObjectEntries().values()) {
            try {
                component = this.deriveComponentFromDataObjectEntry(dataObjectEntry);
                uniqueComponentMap.put(component.getCode(), component);
            }
            catch (Exception e) {
                LOG.error((Object)("An exception was encountered when attempting to publish all components for business object class: " + dataObjectEntry.getDataObjectClass()), (Throwable)e);
            }
        }
        for (DocumentEntry documentEntry : this.getDataDictionaryService().getDataDictionary().getDocumentEntries().values()) {
            if (!(documentEntry instanceof TransactionalDocumentEntry)) continue;
            try {
                component = this.deriveComponentFromDocumentEntry(documentEntry);
                uniqueComponentMap.put(component.getCode(), component);
            }
            catch (Exception e) {
                LOG.error((Object)("An exception was encountered when attempting to publish all components for transactional document class: " + documentEntry.getDocumentClass()), (Throwable)e);
            }
        }
        components.addAll(uniqueComponentMap.values());
        return components;
    }

    protected Component deriveComponentFromClass(Class<?> componentSourceClass) {
        String componentCode = this.getKualiModuleService().getComponentCode(componentSourceClass);
        String componentName = this.deriveComponentName(componentSourceClass);
        String namespace = this.getKualiModuleService().getNamespaceCode(componentSourceClass);
        if (StringUtils.isBlank((String)componentName)) {
            componentName = componentCode;
        }
        Component.Builder detailType = Component.Builder.create((String)namespace, (String)componentCode, (String)componentName);
        return detailType.build();
    }

    protected Component deriveComponentFromDataObjectEntry(DataObjectEntry dataObjectEntry) {
        if (dataObjectEntry.getBaseDataObjectClass() != null) {
            return this.deriveComponentFromClass(dataObjectEntry.getBaseDataObjectClass());
        }
        return this.deriveComponentFromClass(dataObjectEntry.getDataObjectClass());
    }

    protected Component deriveComponentFromDocumentEntry(DocumentEntry documentEntry) {
        Class documentClass = documentEntry.getBaseDocumentClass();
        if (documentClass == null) {
            documentClass = documentEntry.getDocumentClass();
        }
        return this.deriveComponentFromClass(documentClass);
    }

    protected String deriveComponentName(Class<?> componentSourceClass) {
        if (componentSourceClass == null) {
            throw new IllegalArgumentException("The deriveComponentName method requires non-null componentSourceClass");
        }
        if (componentSourceClass.isAnnotationPresent(ParameterConstants.COMPONENT.class)) {
            DataObjectEntry doe = this.getDataDictionaryService().getDataDictionary().getDataObjectEntry(componentSourceClass.getName());
            if (doe != null) {
                return doe.getObjectLabel();
            }
            return componentSourceClass.getAnnotation(ParameterConstants.COMPONENT.class).component();
        }
        if (TransactionalDocument.class.isAssignableFrom(componentSourceClass)) {
            return this.getDataDictionaryService().getDocumentLabelByClass(componentSourceClass);
        }
        DataObjectEntry doe = this.getDataDictionaryService().getDataDictionary().getDataObjectEntry(componentSourceClass.getName());
        if (doe != null) {
            return doe.getObjectLabel();
        }
        return KRADUtils.getBusinessTitleForClass(componentSourceClass);
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public KualiModuleService getKualiModuleService() {
        return this.kualiModuleService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    public ComponentService getComponentService() {
        if (this.componentService == null) {
            this.componentService = CoreServiceApiServiceLocator.getComponentService();
        }
        return this.componentService;
    }

    public void setComponentService(ComponentService componentService) {
        this.componentService = componentService;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }
}

