/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;
import org.kuali.rice.krad.datadictionary.validation.SingleAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.constraint.ConfigurationBasedRegexPatternConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.datadictionary.validation.processor.ValidCharactersConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;

public class YearPatternConstraintTest {
    private final String PATTERN_CONSTRAINT = "validationPatternRegex.year";
    private AttributeDefinition yearDefinition;
    private DictionaryValidationResult dictionaryValidationResult;
    private ValidCharactersConstraintProcessor processor;
    private String validYear;
    private String validYear1;
    private String validYear2;
    private String invalidYearEmpty;
    private String invalidYear;
    private String invalidYear1;
    private String invalidYear2;
    private String invalidYear3;
    private ConfigurationBasedRegexPatternConstraint yearPatternConstraint;

    @Before
    public void setUp() throws Exception {
        String regex = this.getProperty("validationPatternRegex.year");
        this.processor = new ValidCharactersConstraintProcessor();
        this.dictionaryValidationResult = new DictionaryValidationResult();
        this.dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        this.validYear = "1901";
        this.validYear1 = "2050";
        this.validYear2 = "1837";
        this.invalidYearEmpty = "";
        this.invalidYear = "00";
        this.invalidYear1 = "337";
        this.invalidYear2 = "2300";
        this.invalidYear3 = "99999";
        this.yearPatternConstraint = new ConfigurationBasedRegexPatternConstraint();
        this.yearPatternConstraint.setValue(regex);
        this.yearDefinition = new AttributeDefinition();
        this.yearDefinition.setName("year");
        this.yearDefinition.setValidCharactersConstraint((ValidCharactersConstraint)this.yearPatternConstraint);
    }

    @Test
    public void testValueInvalidYearEmpty() {
        ConstraintValidationResult result = this.process(this.invalidYearEmpty, "year", (ValidCharactersConstraint)this.yearPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.INAPPLICABLE, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueValidYear() {
        ConstraintValidationResult result = this.process(this.validYear, "year", (ValidCharactersConstraint)this.yearPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueValidYear1() {
        ConstraintValidationResult result = this.process(this.validYear1, "Myear", (ValidCharactersConstraint)this.yearPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueValidYear2() {
        ConstraintValidationResult result = this.process(this.validYear2, "year", (ValidCharactersConstraint)this.yearPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidYear() {
        ConstraintValidationResult result = this.process(this.invalidYear, "year", (ValidCharactersConstraint)this.yearPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidYear1() {
        ConstraintValidationResult result = this.process(this.invalidYear1, "year", (ValidCharactersConstraint)this.yearPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidYear2() {
        ConstraintValidationResult result = this.process(this.invalidYear2, "year", (ValidCharactersConstraint)this.yearPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidYear3() {
        ConstraintValidationResult result = this.process(this.invalidYear3, "year", (ValidCharactersConstraint)this.yearPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    private ConstraintValidationResult process(Object object, String attributeName, ValidCharactersConstraint constraint) {
        SingleAttributeValueReader attributeValueReader = new SingleAttributeValueReader(object, "org.kuali.rice.kns.datadictionary.validation.MockAddress", attributeName, this.yearDefinition);
        Object value = attributeValueReader.getValue();
        return this.processor.process(this.dictionaryValidationResult, value, constraint, (AttributeValueReader)attributeValueReader).getFirstConstraintValidationResult();
    }

    private String getProperty(String key) {
        String value = null;
        String filePath = "org/kuali/rice/krad/ApplicationResources.properties";
        Properties properties = new Properties();
        try {
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
            properties.load(in);
            value = properties.getProperty(key);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return value;
    }
}

