/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.validation.Address;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.DictionaryObjectAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;
import org.kuali.rice.krad.datadictionary.validation.constraint.ConfigurationBasedRegexPatternConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.datadictionary.validation.processor.ValidCharactersConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;

public class ZipcodePatternConstraintTest {
    private final String PATTERN_CONSTRAINT = "validationPatternRegex.zipcode";
    private AttributeDefinition postalCodeDefinition;
    private BusinessObjectEntry addressEntry;
    private DictionaryValidationResult dictionaryValidationResult;
    private ValidCharactersConstraintProcessor processor;
    private Address washingtonDCAddress = new Address("893 Presidential Ave", "(A_123) Suite 800.", "Washington", "DC", "12345", "USA", null);
    private Address newYorkNYAddress = new Address("Presidential Street", "(A-123) Suite 800", "New York", "NY", "12345-1234", "USA", null);
    private Address sydneySDAddress = new Address("Presidential Street-Ave.", "Suite_800.", "Sydney", "SD", "ZH-123456", "Australia", null);
    private Address holandHDAddress = new Address("Presidential Street-Ave.", "Suite_800.", "Holand", "HD", "12345-123", "Holand", null);
    private Address bombayMHAddress = new Address("Presidential Street-Ave.", "Suite_800.", "Bombay", "MH", "380002", "India", null);
    private ConfigurationBasedRegexPatternConstraint postalCodePatternConstraint;

    @Before
    public void setUp() throws Exception {
        String regex = this.getProperty("validationPatternRegex.zipcode");
        this.processor = new ValidCharactersConstraintProcessor();
        this.dictionaryValidationResult = new DictionaryValidationResult();
        this.dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        this.addressEntry = new BusinessObjectEntry();
        ArrayList<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();
        this.postalCodePatternConstraint = new ConfigurationBasedRegexPatternConstraint();
        this.postalCodePatternConstraint.setValue(regex);
        this.postalCodeDefinition = new AttributeDefinition();
        this.postalCodeDefinition.setName("postalCode");
        this.postalCodeDefinition.setValidCharactersConstraint((ValidCharactersConstraint)this.postalCodePatternConstraint);
        attributes.add(this.postalCodeDefinition);
        this.addressEntry.setAttributes(attributes);
    }

    @Test
    public void testValueValidZipcode() {
        ConstraintValidationResult result = this.process(this.washingtonDCAddress, "postalCode", (ValidCharactersConstraint)this.postalCodePatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueValidZipcode1() {
        ConstraintValidationResult result = this.process(this.newYorkNYAddress, "postalCode", (ValidCharactersConstraint)this.postalCodePatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidZipcode() {
        ConstraintValidationResult result = this.process(this.sydneySDAddress, "postalCode", (ValidCharactersConstraint)this.postalCodePatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidZipcode1() {
        ConstraintValidationResult result = this.process(this.holandHDAddress, "postalCode", (ValidCharactersConstraint)this.postalCodePatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidZipcode2() {
        ConstraintValidationResult result = this.process(this.bombayMHAddress, "postalCode", (ValidCharactersConstraint)this.postalCodePatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    private ConstraintValidationResult process(Object object, String attributeName, ValidCharactersConstraint constraint) {
        DictionaryObjectAttributeValueReader attributeValueReader = new DictionaryObjectAttributeValueReader(object, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry);
        attributeValueReader.setAttributeName(attributeName);
        Object value = attributeValueReader.getValue();
        return this.processor.process(this.dictionaryValidationResult, value, constraint, (AttributeValueReader)attributeValueReader).getFirstConstraintValidationResult();
    }

    private String getProperty(String key) {
        String value = null;
        String filePath = "org/kuali/rice/krad/ApplicationResources.properties";
        Properties properties = new Properties();
        try {
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
            properties.load(in);
            value = properties.getProperty(key);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return value;
    }
}

