/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.DictionaryObjectAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.Employee;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;
import org.kuali.rice.krad.datadictionary.validation.constraint.ConfigurationBasedRegexPatternConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.datadictionary.validation.processor.ValidCharactersConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;

public class EmailAddressPatternConstraintTest {
    private final String PATTERN_CONSTRAINT = "validationPatternRegex.emailAddress";
    private AttributeDefinition contactEmailDefinition;
    private BusinessObjectEntry addressEntry;
    private DictionaryValidationResult dictionaryValidationResult;
    private ValidCharactersConstraintProcessor processor;
    private Employee validEmailEmployee = new Employee();
    private Employee validEmailEmployee1 = new Employee();
    private Employee validEmailEmployee2 = new Employee();
    private Employee validEmailEmployee3 = new Employee();
    private Employee validEmailEmployee4 = new Employee();
    private Employee validEmailEmployee5 = new Employee();
    private Employee invalidEmailEmployeeEmpty = new Employee();
    private Employee invalidEmailEmployee = new Employee();
    private Employee invalidEmailEmployee1 = new Employee();
    private Employee invalidEmailEmployee2 = new Employee();
    private Employee invalidEmailEmployee3 = new Employee();
    private Employee invalidEmailEmployee4 = new Employee();
    private Employee invalidEmailEmployee5 = new Employee();
    private Employee invalidEmailEmployee6 = new Employee();
    private Employee invalidEmailEmployee7 = new Employee();
    private ConfigurationBasedRegexPatternConstraint contactEmailAddressPatternConstraint;

    @Before
    public void setUp() throws Exception {
        String regex = this.getProperty("validationPatternRegex.emailAddress");
        this.processor = new ValidCharactersConstraintProcessor();
        this.dictionaryValidationResult = new DictionaryValidationResult();
        this.dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        this.addressEntry = new BusinessObjectEntry();
        ArrayList<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();
        this.validEmailEmployee.setContactEmail("ww5@a.b.c.org");
        this.validEmailEmployee1.setContactEmail("something.else@a2.com");
        this.validEmailEmployee2.setContactEmail("something_else@something.else.com");
        this.validEmailEmployee3.setContactEmail("something-else@et-tu.com");
        this.validEmailEmployee4.setContactEmail("dmerkal@gmail.com");
        this.validEmailEmployee5.setContactEmail("m.modi@gmail.com");
        this.invalidEmailEmployeeEmpty.setContactEmail("");
        this.invalidEmailEmployee.setContactEmail("@a.b.c.org");
        this.invalidEmailEmployee1.setContactEmail("a");
        this.invalidEmailEmployee2.setContactEmail("1@a.b.c.org");
        this.invalidEmailEmployee3.setContactEmail("1@org");
        this.invalidEmailEmployee4.setContactEmail("1@a");
        this.invalidEmailEmployee5.setContactEmail(".@a.org");
        this.invalidEmailEmployee6.setContactEmail("_@a.org");
        this.invalidEmailEmployee7.setContactEmail("something@a.o-rg");
        this.contactEmailAddressPatternConstraint = new ConfigurationBasedRegexPatternConstraint();
        this.contactEmailAddressPatternConstraint.setMessageKey("validate.dummykey");
        this.contactEmailAddressPatternConstraint.setValidationMessageParams(new ArrayList());
        this.contactEmailAddressPatternConstraint.setValue(regex);
        this.contactEmailDefinition = new AttributeDefinition();
        this.contactEmailDefinition.setName("contactEmail");
        this.contactEmailDefinition.setValidCharactersConstraint((ValidCharactersConstraint)this.contactEmailAddressPatternConstraint);
        attributes.add(this.contactEmailDefinition);
        this.addressEntry.setAttributes(attributes);
    }

    @Test
    public void testValueInvalidEmailAddressEmpty() {
        ConstraintValidationResult result = this.process(this.invalidEmailEmployeeEmpty, "contactEmail", (ValidCharactersConstraint)this.contactEmailAddressPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.INAPPLICABLE, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueValidEmailAddress() {
        ConstraintValidationResult result = this.process(this.validEmailEmployee, "contactEmail", (ValidCharactersConstraint)this.contactEmailAddressPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueValidEmailAddress1() {
        ConstraintValidationResult result = this.process(this.validEmailEmployee1, "contactEmail", (ValidCharactersConstraint)this.contactEmailAddressPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueValidEmailAddress2() {
        ConstraintValidationResult result = this.process(this.validEmailEmployee2, "contactEmail", (ValidCharactersConstraint)this.contactEmailAddressPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueValidEmailAddress3() {
        ConstraintValidationResult result = this.process(this.validEmailEmployee3, "contactEmail", (ValidCharactersConstraint)this.contactEmailAddressPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueValidEmailAddress4() {
        ConstraintValidationResult result = this.process(this.validEmailEmployee4, "contactEmail", (ValidCharactersConstraint)this.contactEmailAddressPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueValidEmailAddress5() {
        ConstraintValidationResult result = this.process(this.validEmailEmployee5, "contactEmail", (ValidCharactersConstraint)this.contactEmailAddressPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidEmailAddress() {
        ConstraintValidationResult result = this.process(this.invalidEmailEmployee, "contactEmail", (ValidCharactersConstraint)this.contactEmailAddressPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidEmailAddress1() {
        ConstraintValidationResult result = this.process(this.invalidEmailEmployee1, "contactEmail", (ValidCharactersConstraint)this.contactEmailAddressPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidEmailAddress2() {
        ConstraintValidationResult result = this.process(this.invalidEmailEmployee2, "contactEmail", (ValidCharactersConstraint)this.contactEmailAddressPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidEmailAddress3() {
        ConstraintValidationResult result = this.process(this.invalidEmailEmployee3, "contactEmail", (ValidCharactersConstraint)this.contactEmailAddressPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidEmailAddress4() {
        ConstraintValidationResult result = this.process(this.invalidEmailEmployee4, "contactEmail", (ValidCharactersConstraint)this.contactEmailAddressPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidEmailAddress5() {
        ConstraintValidationResult result = this.process(this.invalidEmailEmployee5, "contactEmail", (ValidCharactersConstraint)this.contactEmailAddressPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidEmailAddress6() {
        ConstraintValidationResult result = this.process(this.invalidEmailEmployee6, "contactEmail", (ValidCharactersConstraint)this.contactEmailAddressPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidEmailAddress7() {
        ConstraintValidationResult result = this.process(this.invalidEmailEmployee7, "contactEmail", (ValidCharactersConstraint)this.contactEmailAddressPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    private ConstraintValidationResult process(Object object, String attributeName, ValidCharactersConstraint constraint) {
        DictionaryObjectAttributeValueReader attributeValueReader = new DictionaryObjectAttributeValueReader(object, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry);
        attributeValueReader.setAttributeName(attributeName);
        Object value = attributeValueReader.getValue();
        return this.processor.process(this.dictionaryValidationResult, value, constraint, (AttributeValueReader)attributeValueReader).getFirstConstraintValidationResult();
    }

    private String getProperty(String key) {
        String value = null;
        String filePath = "org/kuali/rice/krad/ApplicationResources.properties";
        Properties properties = new Properties();
        try {
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
            properties.load(in);
            value = properties.getProperty(key);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return value;
    }
}

