/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.processor;

import java.util.ArrayList;
import java.util.Collections;
import org.junit.Before;
import org.kuali.rice.core.api.uif.DataType;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.DictionaryObjectAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;
import org.kuali.rice.krad.datadictionary.validation.constraint.CaseConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.Constraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.MustOccurConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.PrerequisiteConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.WhenConstraint;
import org.kuali.rice.krad.datadictionary.validation.processor.ConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.ProcessorResult;

public abstract class BaseConstraintProcessorTest<P extends ConstraintProcessor> {
    protected AttributeDefinition street1Definition;
    protected AttributeDefinition street2Definition;
    protected AttributeDefinition stateDefinition;
    protected AttributeDefinition postalCodeDefinition;
    protected AttributeDefinition countryDefinition;
    protected BusinessObjectEntry addressEntry;
    protected DictionaryValidationResult dictionaryValidationResult;
    protected P processor;
    protected CaseConstraint countryIsUSACaseConstraint;
    protected MustOccurConstraint topLevelConstraint;

    @Before
    public void setUp() throws Exception {
        this.processor = this.newProcessor();
        this.dictionaryValidationResult = new DictionaryValidationResult();
        this.dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        this.addressEntry = new BusinessObjectEntry();
        ArrayList<MustOccurConstraint> mustOccurConstraints = new ArrayList<MustOccurConstraint>();
        PrerequisiteConstraint postalCodeConstraint = new PrerequisiteConstraint();
        postalCodeConstraint.setPropertyName("postalCode");
        PrerequisiteConstraint cityConstraint = new PrerequisiteConstraint();
        cityConstraint.setPropertyName("city");
        PrerequisiteConstraint stateConstraint = new PrerequisiteConstraint();
        stateConstraint.setPropertyName("state");
        ArrayList<PrerequisiteConstraint> cityStateDependencyConstraints = new ArrayList<PrerequisiteConstraint>();
        cityStateDependencyConstraints.add(cityConstraint);
        cityStateDependencyConstraints.add(stateConstraint);
        MustOccurConstraint cityStateConstraint = new MustOccurConstraint();
        cityStateConstraint.setMin(Integer.valueOf(2));
        cityStateConstraint.setMax(Integer.valueOf(2));
        cityStateConstraint.setPrerequisiteConstraints(cityStateDependencyConstraints);
        this.topLevelConstraint = new MustOccurConstraint();
        this.topLevelConstraint.setMax(Integer.valueOf(2));
        this.topLevelConstraint.setMin(Integer.valueOf(1));
        this.topLevelConstraint.setPrerequisiteConstraints(Collections.singletonList(postalCodeConstraint));
        this.topLevelConstraint.setMustOccurConstraints(Collections.singletonList(cityStateConstraint));
        mustOccurConstraints.add(this.topLevelConstraint);
        this.addressEntry.setMustOccurConstraints(mustOccurConstraints);
        ArrayList<WhenConstraint> whenConstraints = new ArrayList<WhenConstraint>();
        PrerequisiteConstraint prerequisiteConstraint = new PrerequisiteConstraint();
        prerequisiteConstraint.setPropertyName("state");
        WhenConstraint whenConstraint1 = new WhenConstraint();
        whenConstraint1.setValue((Object)"USA");
        whenConstraint1.setConstraint((Constraint)prerequisiteConstraint);
        whenConstraints.add(whenConstraint1);
        this.countryIsUSACaseConstraint = new CaseConstraint();
        this.countryIsUSACaseConstraint.setCaseSensitive(false);
        this.countryIsUSACaseConstraint.setWhenConstraint(whenConstraints);
        ArrayList<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();
        ValidCharactersConstraint street1ValidCharactersConstraint = new ValidCharactersConstraint();
        street1ValidCharactersConstraint.setValue("regex:\\d{3}\\s+\\w+\\s+Ave");
        this.street1Definition = new AttributeDefinition();
        this.street1Definition.setName("street1");
        this.street1Definition.setValidCharactersConstraint(street1ValidCharactersConstraint);
        attributes.add(this.street1Definition);
        this.street2Definition = new AttributeDefinition();
        this.street2Definition.setName("street2");
        attributes.add(this.street2Definition);
        AttributeDefinition cityDefinition = new AttributeDefinition();
        cityDefinition.setName("city");
        attributes.add(cityDefinition);
        ValidCharactersConstraint stateValidCharactersConstraint = new ValidCharactersConstraint();
        stateValidCharactersConstraint.setValue("ABCD");
        this.stateDefinition = new AttributeDefinition();
        this.stateDefinition.setName("state");
        this.stateDefinition.setValidCharactersConstraint(stateValidCharactersConstraint);
        attributes.add(this.stateDefinition);
        this.postalCodeDefinition = new AttributeDefinition();
        this.postalCodeDefinition.setName("postalCode");
        this.postalCodeDefinition.setExclusiveMin("1000");
        this.postalCodeDefinition.setInclusiveMax("99999");
        this.postalCodeDefinition.setDataType(DataType.LONG);
        attributes.add(this.postalCodeDefinition);
        this.countryDefinition = new AttributeDefinition();
        this.countryDefinition.setName("country");
        this.countryDefinition.setCaseConstraint(this.countryIsUSACaseConstraint);
        attributes.add(this.countryDefinition);
        this.addressEntry.setAttributes(attributes);
    }

    protected ConstraintValidationResult process(Object object, String attributeName, Constraint constraint) {
        return this.processRaw(object, attributeName, constraint).getFirstConstraintValidationResult();
    }

    protected ProcessorResult processRaw(Object object, String attributeName, Constraint constraint) {
        DictionaryObjectAttributeValueReader attributeValueReader = new DictionaryObjectAttributeValueReader(object, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry);
        attributeValueReader.setAttributeName(attributeName);
        Object value = attributeName != null ? attributeValueReader.getValue() : object;
        return this.processor.process(this.dictionaryValidationResult, value, constraint, (AttributeValueReader)attributeValueReader);
    }

    protected abstract P newProcessor();
}

