/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.processor;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.uif.DataType;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.validation.Address;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.DictionaryObjectAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;
import org.kuali.rice.krad.datadictionary.validation.constraint.RangeConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.datadictionary.validation.processor.RangeConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;

public class RangeConstraintProcessorTest {
    private AttributeDefinition street1Definition;
    private AttributeDefinition street2Definition;
    private AttributeDefinition stateDefinition;
    private AttributeDefinition postalCodeDefinition;
    private BusinessObjectEntry addressEntry;
    private DictionaryValidationResult dictionaryValidationResult;
    private RangeConstraintProcessor processor;
    private Address washingtonDCAddress = new Address("893 Presidential Ave", "Suite 800", "Washington", "DC", "20500", "USA", null);
    private Address newYorkNYAddress = new Address("5 Presidential Street", "Suite 800", "New York", "NY", "10012", "USA", null);
    private Address timbucktooAddress = new Address("5 Presidential Street", "Suite 800", "Timbucktoo", "ZZ", "100000", "USA", null);
    private Address sydneyAUSAddress = new Address("5 Presidential Street", "Suite 800", "Sydney", "ZZ", "999", "USA", null);
    private Address londonUKAddress = new Address("5 Presidential Street", "Suite 800", "Timbucktoo", "ZZ", "99999", "USA", null);
    private Address torontoONAddress = new Address("5 Presidential Street", "Suite 800", "Sydney", "ZZ", "1000", "USA", null);

    @Before
    public void setUp() throws Exception {
        this.processor = new RangeConstraintProcessor();
        this.dictionaryValidationResult = new DictionaryValidationResult();
        this.dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        this.addressEntry = new BusinessObjectEntry();
        ArrayList<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();
        ValidCharactersConstraint street1ValidCharactersConstraint = new ValidCharactersConstraint();
        street1ValidCharactersConstraint.setValue("regex:\\d{3}\\s+\\w+\\s+Ave");
        this.street1Definition = new AttributeDefinition();
        this.street1Definition.setName("street1");
        this.street1Definition.setValidCharactersConstraint(street1ValidCharactersConstraint);
        attributes.add(this.street1Definition);
        this.street2Definition = new AttributeDefinition();
        this.street2Definition.setName("street2");
        attributes.add(this.street2Definition);
        AttributeDefinition cityDefinition = new AttributeDefinition();
        cityDefinition.setName("city");
        attributes.add(cityDefinition);
        ValidCharactersConstraint stateValidCharactersConstraint = new ValidCharactersConstraint();
        stateValidCharactersConstraint.setValue("ABCD");
        this.stateDefinition = new AttributeDefinition();
        this.stateDefinition.setName("state");
        this.stateDefinition.setValidCharactersConstraint(stateValidCharactersConstraint);
        attributes.add(this.stateDefinition);
        this.postalCodeDefinition = new AttributeDefinition();
        this.postalCodeDefinition.setName("postalCode");
        this.postalCodeDefinition.setExclusiveMin("1000");
        this.postalCodeDefinition.setInclusiveMax("99999");
        this.postalCodeDefinition.setDataType(DataType.LONG);
        attributes.add(this.postalCodeDefinition);
        AttributeDefinition countryDefinition = new AttributeDefinition();
        countryDefinition.setName("country");
        attributes.add(countryDefinition);
        this.addressEntry.setAttributes(attributes);
    }

    @Test
    public void testNumberWithinRange1() {
        ConstraintValidationResult result = this.process(this.washingtonDCAddress, "postalCode", this.postalCodeDefinition);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new RangeConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testNumberWithinRange2() {
        ConstraintValidationResult result = this.process(this.newYorkNYAddress, "postalCode", this.postalCodeDefinition);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new RangeConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testNumberAboveRange() {
        ConstraintValidationResult result = this.process(this.timbucktooAddress, "postalCode", this.postalCodeDefinition);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new RangeConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testNumberBelowRange() {
        ConstraintValidationResult result = this.process(this.sydneyAUSAddress, "postalCode", this.postalCodeDefinition);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new RangeConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testNumberAtTopOfRange() {
        ConstraintValidationResult result = this.process(this.londonUKAddress, "postalCode", this.postalCodeDefinition);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new RangeConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testNumberAtBottomOfRange() {
        ConstraintValidationResult result = this.process(this.torontoONAddress, "postalCode", this.postalCodeDefinition);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new RangeConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    private ConstraintValidationResult process(Object object, String attributeName, AttributeDefinition definition) {
        DictionaryObjectAttributeValueReader attributeValueReader = new DictionaryObjectAttributeValueReader(object, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry);
        attributeValueReader.setAttributeName(attributeName);
        Object value = attributeValueReader.getValue();
        return this.processor.process(this.dictionaryValidationResult, value, (RangeConstraint)definition.getSimpleConstraint(), (AttributeValueReader)attributeValueReader).getFirstConstraintValidationResult();
    }
}

