/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.component;

import java.util.TreeMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.Action;

public class ComponentBaseTest {
    private Component component;
    private TreeMap<String, String> dataAttributes;

    @Before
    public void setUp() throws Exception {
        this.component = new Action();
        this.component.setId("action1");
        this.dataAttributes = new TreeMap();
        this.dataAttributes.put("iconTemplateName", "cool-icon-%s.png");
        this.dataAttributes.put("transitions", "3");
        this.component.setDataAttributes(this.dataAttributes);
    }

    @Test
    public void testGetSimpleDataAttributes() throws Exception {
        Assert.assertNotNull((Object)this.component.getSimpleDataAttributes());
        String expected = " data-iconTemplateName=\"cool-icon-%s.png\" data-transitions=\"3\"";
        Assert.assertEquals((String)"simple attributes did not match", (Object)expected, (Object)this.component.getSimpleDataAttributes());
    }

    @Test
    public void testGetSimpleDataAttributesWhenNull() throws Exception {
        this.component.setDataAttributes(null);
        Assert.assertEquals((String)"simple attributes did not match", (Object)"", (Object)this.component.getSimpleDataAttributes());
    }
}

