/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentBase;
import org.kuali.rice.krad.uif.component.ReferenceCopy;
import org.kuali.rice.krad.uif.control.CheckboxControl;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.FieldBase;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.util.ComponentUtils;

public class ComponentUtilsTest {
    private String componentId;
    private Component component;

    @Before
    public void setup() {
        this.component = new InputField();
        this.componentId = "field1";
        this.component.setId(this.componentId);
        this.component.setBaseId(this.componentId);
    }

    private FieldBase initializeFieldBase() {
        FieldBase fieldBase = new FieldBase();
        fieldBase = (FieldBase)this.initializeComponentBase((ComponentBase)fieldBase);
        fieldBase.setShortLabel("Label");
        return fieldBase;
    }

    private DataField initializeDataField() {
        DataField dataField = new DataField();
        dataField = (DataField)this.initializeComponentBase((ComponentBase)dataField);
        dataField.setAddHiddenWhenReadOnly(true);
        ArrayList<String> additionalHiddenPropertyNames = new ArrayList<String>();
        additionalHiddenPropertyNames.add("HiddenA");
        additionalHiddenPropertyNames.add("HiddenB");
        additionalHiddenPropertyNames.add("HiddenC");
        dataField.setAdditionalHiddenPropertyNames(additionalHiddenPropertyNames);
        dataField.setApplyMask(true);
        dataField.setDefaultValue("default");
        dataField.setDictionaryAttributeName("DictionaryName");
        dataField.setDictionaryObjectEntry("DictionaryObjectEntry");
        dataField.setEscapeHtmlInPropertyValue(true);
        dataField.setForcedValue("Forced");
        dataField.setMultiLineReadOnlyDisplay(true);
        return dataField;
    }

    private ComponentBase initializeComponentBase(ComponentBase componentBase) {
        ArrayList<String> additionalComponentsToRefresh = new ArrayList<String>();
        additionalComponentsToRefresh.add("A");
        additionalComponentsToRefresh.add("B");
        additionalComponentsToRefresh.add("C");
        componentBase.setAdditionalComponentsToRefresh(additionalComponentsToRefresh);
        ArrayList<String> additionalCssClasses = new ArrayList<String>();
        additionalCssClasses.add("Class1");
        additionalCssClasses.add("Class2");
        additionalCssClasses.add("Class3");
        componentBase.setAdditionalCssClasses(additionalCssClasses);
        componentBase.setAlign("right");
        ArrayList<String> cellCssClasses = new ArrayList<String>();
        cellCssClasses.add("CellClass1");
        cellCssClasses.add("CellClass2");
        cellCssClasses.add("CellClass3");
        componentBase.setCellCssClasses(cellCssClasses);
        componentBase.setCellStyle("Style1");
        componentBase.setCellWidth("20px");
        componentBase.setColSpan(2);
        componentBase.setConditionalRefresh("Refresh");
        ArrayList<String> cssClasses = new ArrayList<String>();
        cssClasses.add("CssClass1");
        cssClasses.add("CssClass2");
        cssClasses.add("CssClass3");
        componentBase.setCssClasses(cssClasses);
        HashMap<String, String> dataAttributes = new HashMap<String, String>();
        dataAttributes.put("One", "A");
        dataAttributes.put("Two", "B");
        dataAttributes.put("Three", "C");
        componentBase.setDataAttributes(dataAttributes);
        componentBase.setFinalizeMethodToCall("methodA");
        componentBase.setMethodToCallOnRefresh("methodB");
        componentBase.setOnBlurScript("onblurscript");
        componentBase.setOnChangeScript("onchangescript");
        componentBase.setOnClickScript("onclickscript");
        componentBase.setOnCloseScript("onclosescript");
        componentBase.setOnDblClickScript("ondblclickscript");
        componentBase.setOnDocumentReadyScript("ondocreadyscript");
        componentBase.setOnFocusScript("onfocusscript");
        componentBase.setOnKeyDownScript("onkeydownscript");
        componentBase.setOnKeyPressScript("onkeypressscript");
        componentBase.setOnKeyUpScript("onkeyupscript");
        componentBase.setOnLoadScript("onloadscript");
        componentBase.setOnMouseDownScript("onmousedownscript");
        componentBase.setOnMouseMoveScript("onmousemovescript");
        componentBase.setOnMouseOutScript("onmouseoutscript");
        componentBase.setOnMouseOverScript("onmouseoverscript");
        componentBase.setOnMouseUpScript("onmouseupscript");
        componentBase.setOnSubmitScript("onsubmitscript");
        componentBase.setOnUnloadScript("onunloadscript");
        componentBase.setOrder(5);
        componentBase.setPostRenderContent("PostRenderContent");
        componentBase.setPreRenderContent("PreRenderContent");
        componentBase.setProgressiveRender("ProgressiveRender");
        componentBase.setReadOnly(false);
        componentBase.setRefreshedByAction(false);
        componentBase.setRefreshTimer(12);
        ArrayList<String> refreshWhenChangedPropertyNames = new ArrayList<String>();
        refreshWhenChangedPropertyNames.add("property1");
        refreshWhenChangedPropertyNames.add("property2");
        refreshWhenChangedPropertyNames.add("property3");
        componentBase.setRefreshWhenChangedPropertyNames(refreshWhenChangedPropertyNames);
        componentBase.setRenderedHtmlOutput("<output>");
        componentBase.setRowSpan(3);
        componentBase.setStyle("slick");
        componentBase.setTemplate("TemplateA");
        componentBase.setTemplateName("TemplateName");
        HashMap<String, String> templateOptions = new HashMap<String, String>();
        templateOptions.put("Option1", "Value1");
        templateOptions.put("Option1", "Value2");
        templateOptions.put("Option1", "Value3");
        componentBase.setTemplateOptions(templateOptions);
        componentBase.setTemplateOptionsJSString("OptionsJS");
        componentBase.setTitle("Title");
        componentBase.setValign("middle");
        componentBase.setWidth("30px");
        return componentBase;
    }

    @Test
    public void testUpdateIdWithSuffix() {
        ComponentUtils.updateIdWithSuffix((Component)this.component, null);
        Assert.assertTrue((boolean)this.component.getId().equalsIgnoreCase(this.componentId));
        String suffix = "_field";
        ComponentUtils.updateIdWithSuffix((Component)this.component, (String)suffix);
        Assert.assertTrue((boolean)this.component.getId().equalsIgnoreCase(this.componentId + suffix));
    }

    @Test
    public void testCopyUsingCloningWithFieldBaseSucceeds() {
        FieldBase fieldBaseOriginal = this.initializeFieldBase();
        FieldBase fieldBaseCopy = ComponentUtilsTest.copy(fieldBaseOriginal);
        Assert.assertTrue((boolean)this.ComponentCopyPropertiesMatch((ComponentBase)fieldBaseOriginal, (ComponentBase)fieldBaseCopy));
        Assert.assertTrue((boolean)fieldBaseOriginal.getShortLabel().equals(fieldBaseCopy.getShortLabel()));
    }

    public static <T extends Component> T copy(T component) {
        return (T)((Component)component.copy());
    }

    @Test
    public void testCopyUsingCloningWithDataFieldSucceeds() {
        DataField dataFieldOriginal = this.initializeDataField();
        DataField dataFieldCopy = ComponentUtilsTest.copy(dataFieldOriginal);
        Assert.assertTrue((boolean)this.ComponentCopyPropertiesMatch((ComponentBase)dataFieldOriginal, (ComponentBase)dataFieldCopy));
    }

    private boolean ComponentCopyPropertiesMatch(ComponentBase originalComponent, ComponentBase copiedComponent) {
        boolean result = true;
        List missingComponentsToRefresh = originalComponent.getAdditionalComponentsToRefresh();
        missingComponentsToRefresh.removeAll(copiedComponent.getAdditionalComponentsToRefresh());
        if (!missingComponentsToRefresh.isEmpty()) {
            result = false;
        }
        List missingAdditionalCssClasses = originalComponent.getAdditionalCssClasses();
        missingAdditionalCssClasses.removeAll(copiedComponent.getAdditionalCssClasses());
        if (!missingAdditionalCssClasses.isEmpty()) {
            result = false;
        }
        if (!originalComponent.getAlign().equals(copiedComponent.getAlign())) {
            result = false;
        }
        List missingCellCssClasses = originalComponent.getCellCssClasses();
        missingCellCssClasses.removeAll(copiedComponent.getCellCssClasses());
        if (!missingCellCssClasses.isEmpty()) {
            result = false;
        }
        if (!originalComponent.getCellStyle().equals(copiedComponent.getCellStyle())) {
            result = false;
        }
        if (!originalComponent.getCellWidth().equals(copiedComponent.getCellWidth())) {
            result = false;
        }
        if (originalComponent.getColSpan() != copiedComponent.getColSpan()) {
            result = false;
        }
        if (!originalComponent.getConditionalRefresh().equals(copiedComponent.getConditionalRefresh())) {
            result = false;
        }
        List missingCssClasses = originalComponent.getCssClasses();
        missingCssClasses.removeAll(copiedComponent.getCssClasses());
        if (!missingCssClasses.isEmpty()) {
            result = false;
        }
        HashSet dataAttributes = new HashSet(originalComponent.getDataAttributes().values());
        dataAttributes.removeAll(copiedComponent.getDataAttributes().values());
        if (!dataAttributes.isEmpty()) {
            result = false;
        }
        if (!originalComponent.getFinalizeMethodToCall().equals(copiedComponent.getFinalizeMethodToCall())) {
            result = false;
        }
        if (!originalComponent.getMethodToCallOnRefresh().equals(copiedComponent.getMethodToCallOnRefresh())) {
            result = false;
        }
        if (!originalComponent.getOnBlurScript().equals(copiedComponent.getOnBlurScript())) {
            result = false;
        }
        if (!originalComponent.getOnChangeScript().equals(copiedComponent.getOnChangeScript())) {
            result = false;
        }
        if (!originalComponent.getOnClickScript().equals(copiedComponent.getOnClickScript())) {
            result = false;
        }
        if (!originalComponent.getOnCloseScript().equals(copiedComponent.getOnCloseScript())) {
            result = false;
        }
        if (!originalComponent.getOnDblClickScript().equals(copiedComponent.getOnDblClickScript())) {
            result = false;
        }
        if (!originalComponent.getOnDocumentReadyScript().equals(copiedComponent.getOnDocumentReadyScript())) {
            result = false;
        }
        if (!originalComponent.getOnFocusScript().equals(copiedComponent.getOnFocusScript())) {
            result = false;
        }
        if (!originalComponent.getOnKeyDownScript().equals(copiedComponent.getOnKeyDownScript())) {
            result = false;
        }
        if (!originalComponent.getOnKeyPressScript().equals(copiedComponent.getOnKeyPressScript())) {
            result = false;
        }
        if (!originalComponent.getOnKeyUpScript().equals(copiedComponent.getOnKeyUpScript())) {
            result = false;
        }
        if (!originalComponent.getOnLoadScript().equals(copiedComponent.getOnLoadScript())) {
            result = false;
        }
        if (!originalComponent.getOnMouseDownScript().equals(copiedComponent.getOnMouseDownScript())) {
            result = false;
        }
        if (!originalComponent.getOnMouseMoveScript().equals(copiedComponent.getOnMouseMoveScript())) {
            result = false;
        }
        if (!originalComponent.getOnMouseOutScript().equals(copiedComponent.getOnMouseOutScript())) {
            result = false;
        }
        if (!originalComponent.getOnMouseOverScript().equals(copiedComponent.getOnMouseOverScript())) {
            result = false;
        }
        if (!originalComponent.getOnMouseUpScript().equals(copiedComponent.getOnMouseUpScript())) {
            result = false;
        }
        if (!originalComponent.getOnSubmitScript().equals(copiedComponent.getOnSubmitScript())) {
            result = false;
        }
        if (!originalComponent.getOnUnloadScript().equals(copiedComponent.getOnUnloadScript())) {
            result = false;
        }
        if (originalComponent.getOrder() != copiedComponent.getOrder()) {
            result = false;
        }
        if (!originalComponent.getPostRenderContent().equals(copiedComponent.getPostRenderContent())) {
            result = false;
        }
        if (!originalComponent.getPreRenderContent().equals(copiedComponent.getPreRenderContent())) {
            result = false;
        }
        if (!originalComponent.getProgressiveRender().equals(copiedComponent.getProgressiveRender())) {
            result = false;
        }
        if (originalComponent.getRequired() != copiedComponent.getRequired()) {
            result = false;
        }
        if (originalComponent.getRefreshTimer() != copiedComponent.getRefreshTimer()) {
            result = false;
        }
        List missingRefreshWhenChangedPropertyNames = originalComponent.getRefreshWhenChangedPropertyNames();
        missingRefreshWhenChangedPropertyNames.removeAll(copiedComponent.getRefreshWhenChangedPropertyNames());
        if (!missingRefreshWhenChangedPropertyNames.isEmpty()) {
            result = false;
        }
        if (!originalComponent.getRenderedHtmlOutput().equals(copiedComponent.getRenderedHtmlOutput())) {
            result = false;
        }
        if (originalComponent.getRowSpan() != copiedComponent.getRowSpan()) {
            result = false;
        }
        if (!originalComponent.getStyle().equals(copiedComponent.getStyle())) {
            result = false;
        }
        if (!originalComponent.getTemplate().equals(copiedComponent.getTemplate())) {
            result = false;
        }
        if (!originalComponent.getTemplateName().equals(copiedComponent.getTemplateName())) {
            result = false;
        }
        HashSet templateOptions = new HashSet(originalComponent.getTemplateOptions().values());
        templateOptions.removeAll(copiedComponent.getTemplateOptions().values());
        if (!templateOptions.isEmpty()) {
            result = false;
        }
        if (!originalComponent.getTemplateOptionsJSString().equals(copiedComponent.getTemplateOptionsJSString())) {
            result = false;
        }
        if (!originalComponent.getTitle().equals(copiedComponent.getTitle())) {
            result = false;
        }
        if (!originalComponent.getValign().equals(copiedComponent.getValign())) {
            result = false;
        }
        if (!originalComponent.getWidth().equals(copiedComponent.getWidth())) {
            result = false;
        }
        return result;
    }

    @Ignore
    @Test
    public void testCopyUsingCloningWithDataTableSucceeds() {
        CheckboxControl dataTableOriginal = new CheckboxControl();
        this.initializeClass(dataTableOriginal);
        CheckboxControl dataTableCopy = ComponentUtilsTest.copy(dataTableOriginal);
        Assert.assertTrue((boolean)this.propertiesMatch(dataTableOriginal, dataTableCopy));
    }

    private void initializeClass(Object originalObject) {
        Class<?> originalClass = originalObject.getClass();
        long index = 0L;
        for (Field field : originalClass.getDeclaredFields()) {
            if (field.isAnnotationPresent(ReferenceCopy.class)) continue;
            try {
                if (field.getType().equals(String.class)) {
                    field.setAccessible(true);
                    field.set(originalObject, "Test" + index);
                }
                if (field.getType().equals(Long.TYPE)) {
                    field.setAccessible(true);
                    field.setLong(originalObject, index);
                }
                if (field.getType().equals(Integer.TYPE)) {
                    field.setAccessible(true);
                    field.setInt(originalObject, (int)index);
                }
                if (field.getType().equals(List.class)) {
                    field.setAccessible(true);
                    ParameterizedType myListType = (ParameterizedType)field.getGenericType();
                    int something = 2;
                    Object[] objects = new Object[]{new FieldBase()};
                    List<Object> fieldList = Arrays.asList(objects);
                    field.set(originalObject, fieldList);
                    List retrievedList = (List)field.get(originalObject);
                    int n = 3;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            ++index;
        }
    }

    private boolean propertiesMatch(Object originalObject, Object copiedObject) {
        Class<?> originalClass = originalObject.getClass();
        Class<?> copiedClass = copiedObject.getClass();
        for (Field field : originalClass.getDeclaredFields()) {
            boolean propertiesMatch;
            if (field.isAnnotationPresent(ReferenceCopy.class)) continue;
            if (field.getType().equals(String.class) && !(propertiesMatch = this.stringPropertiesMatch(originalObject, copiedObject, copiedClass, field))) {
                return false;
            }
            if (field.getType().equals(Long.TYPE) && !(propertiesMatch = this.longPropertiesMatch(originalObject, copiedObject, copiedClass, field))) {
                return false;
            }
            if (!field.getType().equals(Integer.TYPE) || (propertiesMatch = this.intPropertiesMatch(originalObject, copiedObject, copiedClass, field))) continue;
            return false;
        }
        return true;
    }

    private boolean intPropertiesMatch(Object originalObject, Object copiedObject, Class copiedClass, Field field) {
        try {
            field.setAccessible(true);
            int oritinalInt = field.getInt(originalObject);
            Field copiedClassField = copiedClass.getDeclaredField(field.getName());
            copiedClassField.setAccessible(true);
            int copiedInt = copiedClassField.getInt(copiedObject);
            return oritinalInt == copiedInt;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    private boolean longPropertiesMatch(Object originalObject, Object copiedObject, Class copiedClass, Field field) {
        try {
            field.setAccessible(true);
            Long originalLong = field.getLong(originalObject);
            Field copiedClassField = copiedClass.getDeclaredField(field.getName());
            copiedClassField.setAccessible(true);
            Long copiedLong = copiedClassField.getLong(copiedObject);
            return originalLong.equals(copiedLong);
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    private boolean stringPropertiesMatch(Object originalObject, Object copiedObject, Class copiedClass, Field field) {
        try {
            field.setAccessible(true);
            String originalString = (String)field.get(originalObject);
            String copiedString = new String();
            Field copiedClassField = copiedClass.getDeclaredField(field.getName());
            copiedClassField.setAccessible(true);
            copiedString = (String)copiedClassField.get(copiedObject);
            return originalString.equals(copiedString);
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }
}

