/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBean;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBeanBase;
import org.kuali.rice.krad.uif.util.ExpressionUtils;

public class ExpressionUtilsTest {
    @Test
    public void testPopulatePropertyExpressionsFromGraph() {
        HashMap<String, String> expressionGraph = new HashMap<String, String>();
        expressionGraph.put("property1", "@{expr1}");
        expressionGraph.put("property2", "@{expr2}");
        expressionGraph.put("property3['key1']", "@{key1expr}");
        expressionGraph.put("property4.property1", "@{nexpr1}");
        expressionGraph.put("property4.property4.property3['key2']", "@{nkey2expr}");
        MockConfigurable configurable = new MockConfigurable();
        MockConfigurable configurable2 = new MockConfigurable();
        MockConfigurable configurable3 = new MockConfigurable();
        configurable2.setProperty4(configurable3);
        configurable.setProperty4(configurable2);
        configurable.setExpressionGraph(expressionGraph);
        ExpressionUtils.populatePropertyExpressionsFromGraph((UifDictionaryBean)configurable, (boolean)false);
        Assert.assertEquals((String)"Expression count not correct in root configurable", (int)3, (int)configurable.getPropertyExpressions().size());
        Assert.assertEquals((String)"Expression not correct for property1", (String)"@{expr1}", (String)configurable.getPropertyExpression("property1"));
        Assert.assertEquals((String)"Expression not correct for property2", (String)"@{expr2}", (String)configurable.getPropertyExpression("property2"));
        Assert.assertEquals((String)"Expression not correct for map property3", (String)"@{key1expr}", (String)configurable.getPropertyExpression("property3['key1']"));
        Assert.assertEquals((String)"Expression count not correct in nested configurable", (int)1, (int)configurable.getProperty4().getPropertyExpressions().size());
        Assert.assertEquals((String)"Expression not correct for nested property1", (String)"@{nexpr1}", (String)configurable.getProperty4().getPropertyExpression("property1"));
        Assert.assertEquals((String)"Expression count not correct in two level nested configurable", (int)1, (int)configurable.getProperty4().getProperty4().getPropertyExpressions().size());
        Assert.assertEquals((String)"Expression not correct for nested map property3", (String)"@{nkey2expr}", (String)configurable.getProperty4().getProperty4().getPropertyExpression("property3['key2']"));
    }

    @Test
    public void testPopulatePropertyExpressionsFromGraph_RefreshGraphs() {
        HashMap<String, String> expressionGraph = new HashMap<String, String>();
        expressionGraph.put("property1", "@{expr1}");
        expressionGraph.put("property2", "@{expr2}");
        expressionGraph.put("property3['key1']", "@{key1expr}");
        expressionGraph.put("property4.property1", "@{nexpr1}");
        expressionGraph.put("property4.property4.property3['key2']", "@{nkey2expr}");
        MockConfigurable configurable = new MockConfigurable();
        MockConfigurable configurable2 = new MockConfigurable();
        MockConfigurable configurable3 = new MockConfigurable();
        configurable2.setProperty4(configurable3);
        configurable.setProperty4(configurable2);
        configurable.setExpressionGraph(expressionGraph);
        ExpressionUtils.populatePropertyExpressionsFromGraph((UifDictionaryBean)configurable, (boolean)true);
        Assert.assertEquals((String)"Refresh expression count not correct in root configurable", (int)5, (int)configurable.getRefreshExpressionGraph().size());
        Assert.assertEquals((String)"Refresh expression count not correct in nested configurable", (int)2, (int)configurable.getProperty4().getRefreshExpressionGraph().size());
        Assert.assertEquals((String)"Refresh expression count not correct in two level nested configurable", (int)1, (int)configurable.getProperty4().getProperty4().getRefreshExpressionGraph().size());
    }

    public class MockConfigurable
    extends UifDictionaryBeanBase {
        private String property1;
        private String property2;
        private Map<String, String> property3 = new HashMap<String, String>();
        private MockConfigurable property4;

        public String getProperty1() {
            return this.property1;
        }

        public void setProperty1(String property1) {
            this.property1 = property1;
        }

        public String getProperty2() {
            return this.property2;
        }

        public void setProperty2(String property2) {
            this.property2 = property2;
        }

        public Map<String, String> getProperty3() {
            return this.property3;
        }

        public void setProperty3(Map<String, String> property3) {
            this.property3 = property3;
        }

        public MockConfigurable getProperty4() {
            return this.property4;
        }

        public void setProperty4(MockConfigurable property4) {
            this.property4 = property4;
        }
    }
}

