/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.uif.util.ObjectPathExpressionParser;
import org.kuali.rice.krad.uif.util.ProcessLoggingUnitTest;

public class ObjectPathExpressionParserTest
extends ProcessLoggingUnitTest {
    @Test
    public void testParsePathExpression() {
        Assert.assertEquals((Object)"foo+bar", (Object)ObjectPathExpressionParser.parsePathExpression(null, (String)"foo.bar", (ObjectPathExpressionParser.PathEntry)new DoIt()).toString());
        Assert.assertEquals((Object)"foo<bar>", (Object)ObjectPathExpressionParser.parsePathExpression(null, (String)"foo[bar]", (ObjectPathExpressionParser.PathEntry)new DoIt()).toString());
        Assert.assertEquals((Object)"foo<bar>+baz", (Object)ObjectPathExpressionParser.parsePathExpression(null, (String)"foo[bar].baz", (ObjectPathExpressionParser.PathEntry)new DoIt()).toString());
        Assert.assertEquals((Object)"foo<bar<baz>>", (Object)ObjectPathExpressionParser.parsePathExpression(null, (String)"foo[bar[baz]]", (ObjectPathExpressionParser.PathEntry)new DoIt()).toString());
        Assert.assertEquals((Object)"foo+bar-bar.baz+fez", (Object)ObjectPathExpressionParser.parsePathExpression(null, (String)"foo(bar-bar.baz)+fez", (ObjectPathExpressionParser.PathEntry)new DoIt()).toString());
    }

    private static class DoIt
    implements ObjectPathExpressionParser.PathEntry {
        private DoIt() {
        }

        public String parse(Object node, String next, boolean inherit) {
            if (next == null) {
                return "";
            }
            String snode = (String)node;
            StringBuilder rv = new StringBuilder();
            if (snode != null && snode.length() > 0) {
                rv.append(snode);
            }
            if (inherit) {
                rv.append('<');
            } else if (rv.length() > 0) {
                rv.append('+');
            }
            rv.append(next);
            if (inherit) {
                rv.append('>');
            }
            return rv.toString();
        }

        public Object prepare(Object prev) {
            return prev;
        }

        public String dereference(Object prev) {
            return (String)prev;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TestAnnotation {
        public String afoo();
    }
}

