/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.ProcessLoggingUnitTest;

public class ObjectPropertyUtilsTest
extends ProcessLoggingUnitTest {
    @Test
    public void testSetBoolean() {
        TestBean tb = new TestBean();
        ObjectPropertyUtils.setPropertyValue((Object)tb, (String)"booleanProp", (Object)"true");
        Assert.assertTrue((boolean)tb.isBooleanProp());
    }

    @Test
    public void testGetPropertyDescriptor() {
        TestBean tb = new TestBean();
        PropertyDescriptor[] pds = ObjectPropertyUtils.getPropertyDescriptors((Object)tb);
        boolean rwProp = false;
        boolean roProp = false;
        boolean woProp = false;
        boolean foobar = false;
        for (PropertyDescriptor pd : pds) {
            if (pd.getName().equals("rwProp")) {
                rwProp = true;
            }
            if (pd.getName().equals("roProp")) {
                roProp = true;
            }
            if (pd.getName().equals("woProp")) {
                woProp = true;
            }
            if (!pd.getName().equals("foobar")) continue;
            foobar = true;
        }
        Assert.assertTrue((boolean)rwProp);
        Assert.assertTrue((boolean)roProp);
        Assert.assertTrue((boolean)woProp);
        Assert.assertFalse((boolean)foobar);
    }

    @Test
    public void testGet() {
        TestBean tb = new TestBean();
        tb.setRwProp("foobar");
        Assert.assertEquals((Object)"foobar", (Object)ObjectPropertyUtils.getPropertyValue((Object)tb, (String)"rwProp"));
        tb.roProp = "barbaz";
        Assert.assertEquals((Object)"barbaz", (Object)ObjectPropertyUtils.getPropertyValue((Object)tb, (String)"roProp"));
        try {
            ObjectPropertyUtils.getPropertyValue((Object)tb, (String)"woProp");
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testLookup() {
        TestBean tb = new TestBean();
        tb.roProp = "barbaz";
        Assert.assertEquals((Object)"barbaz", (Object)ObjectPropertyUtils.getPropertyValue((Object)tb, (String)"roProp"));
        HashMap<String, Object> tm = new HashMap<String, Object>();
        tb.setMapProp(tm);
        tm.put("barbaz", "hooray!");
        Assert.assertEquals((Object)"hooray!", (Object)ObjectPropertyUtils.getPropertyValue((Object)tb, (String)"mapProp['barbaz']"));
        Assert.assertEquals((Object)"hooray!", (Object)ObjectPropertyUtils.getPropertyValue((Object)tb, (String)"mapProp[\"barbaz\"]"));
        TestBean tb2 = new TestBean();
        tb2.setRwProp("foodbar");
        tb.setNext(tb2);
        tm.put("blah", new Object[]{"next", "rwProp"});
        tm.put("baz", tb2);
        Assert.assertTrue((boolean)ObjectPropertyUtils.isReadableProperty((Object)tb, (String)"mapProp[\"baz\"].rwProp"));
        Assert.assertEquals((Object)"barbaz", (Object)ObjectPropertyUtils.getPropertyValue((Object)tb, (String)"roProp"));
        Assert.assertEquals((Object)"foodbar", (Object)ObjectPropertyUtils.getPropertyValue((Object)tb, (String)"next.rwProp"));
        tb.setStuffs(Arrays.asList("foo", "bar", "baz"));
        Assert.assertEquals((Object)"bar", (Object)ObjectPropertyUtils.getPropertyValue((Object)tb, (String)"stuffs[1]"));
        TestBean rb = new TestBean();
        TestBean nb = new TestBean();
        TestBean lb = new TestBean();
        rb.setNext(nb);
        nb.setNext(lb);
        Assert.assertEquals(String.class, (Object)ObjectPropertyUtils.getPropertyType((Object)rb, (String)"next.next.rwProp"));
        rb.setRwProp("baz");
        nb.setRwProp("bar");
        lb.setRwProp("foo");
        Assert.assertEquals((Object)"foo", (Object)ObjectPropertyUtils.getPropertyValue((Object)rb, (String)"next.next.rwProp"));
    }

    @Test
    public void testSet() {
        TestBean tb = new TestBean();
        ObjectPropertyUtils.setPropertyValue((Object)tb, (String)"rwProp", (Object)"foobar");
        Assert.assertEquals((Object)"foobar", (Object)tb.getRwProp());
        ObjectPropertyUtils.setPropertyValue((Object)tb, (String)"woProp", (Object)"barbaz");
        Assert.assertEquals((Object)"barbaz", (Object)tb.woProp);
        try {
            ObjectPropertyUtils.setPropertyValue((Object)tb, (String)"roProp", (Object)"bazfoo");
            Assert.fail((String)"expected exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        long now = System.currentTimeMillis();
        ObjectPropertyUtils.setPropertyValue((Object)tb, (String)"dateProp", (Object)new Date(now));
        Assert.assertEquals((long)now, (long)tb.getDateProp().getTime());
    }

    @Test
    public void testPathSet() {
        TestBean tb = new TestBean();
        ObjectPropertyUtils.setPropertyValue((Object)tb, (String)"rwProp", (Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)tb.getRwProp());
        ObjectPropertyUtils.setPropertyValue((Object)tb, (String)"next", (Object)new TestBean());
        ObjectPropertyUtils.setPropertyValue((Object)tb, (String)"next.next", (Object)new TestBean());
        ObjectPropertyUtils.setPropertyValue((Object)tb, (String)"next.next.woProp", (Object)"baz");
        Assert.assertEquals((Object)"baz", (Object)tb.getNext().getNext().woProp);
    }

    @Test
    public void testBulk() {
        HashMap<String, String> pd = new HashMap<String, String>();
        pd.put("rwProp", "foobar");
        pd.put("intProp", "3");
        pd.put("booleanProp", "true");
        pd.put("stuffs", "foo,bar,baz");
        for (int i = 0; i < 10000; ++i) {
            TestBean tb = new TestBean();
            ObjectPropertyUtils.copyPropertiesToObject(pd, (Object)tb);
            Assert.assertEquals((Object)"foobar", (Object)tb.getRwProp());
            Assert.assertEquals((long)3L, (long)tb.getIntProp());
            Assert.assertEquals((Object)true, (Object)tb.isBooleanProp());
            Assert.assertEquals((long)3L, (long)tb.getStuffs().size());
            Assert.assertEquals((Object)"foo", (Object)tb.getStuffs().get(0));
            Assert.assertEquals((Object)"bar", (Object)tb.getStuffs().get(1));
            Assert.assertEquals((Object)"baz", (Object)tb.getStuffs().get(2));
        }
    }

    public class TestBean
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String rwProp;
        private String woProp;
        private String roProp;
        private Boolean bitProp;
        private boolean booleanProp;
        private Timestamp timestampProp;
        private java.util.Date dateProp;
        private int intProp;
        private BigDecimal bigDecimalProp;
        private Integer integerProp;
        private TestBean next;
        private List<String> stuffs;
        private Object[] arrayProp;
        private Map<String, Object> mapProp;

        public String getRwProp() {
            return this.rwProp;
        }

        public void setRwProp(String r) {
            this.rwProp = r;
        }

        public void setWoProp(String w) {
            this.woProp = w;
        }

        @TestAnnotation(afoo="abar")
        public String getRoProp() {
            return this.roProp;
        }

        public boolean isBitProp() {
            return this.bitProp != null && this.bitProp != false;
        }

        public Boolean getBitProp() {
            return this.bitProp;
        }

        public void setBitProp(Boolean bitProp) {
            this.bitProp = bitProp;
        }

        public boolean isBooleanProp() {
            return this.booleanProp;
        }

        public void setBooleanProp(boolean booleanProp) {
            this.booleanProp = booleanProp;
        }

        public Timestamp getTimestampProp() {
            return this.timestampProp;
        }

        public void setTimestampProp(Timestamp timestampProp) {
            this.timestampProp = timestampProp;
        }

        public java.util.Date getDateProp() {
            return this.dateProp;
        }

        public void setDateProp(java.util.Date dateProp) {
            this.dateProp = dateProp;
        }

        public int getIntProp() {
            return this.intProp;
        }

        public BigDecimal getBigDecimalProp() {
            return this.bigDecimalProp;
        }

        public void setBigDecimalProp(BigDecimal bigDecimalProp) {
            this.bigDecimalProp = bigDecimalProp;
        }

        public void setIntProp(int intProp) {
            this.intProp = intProp;
        }

        public Integer getIntegerProp() {
            return this.integerProp;
        }

        public void setIntegerProp(Integer integerProp) {
            this.integerProp = integerProp;
        }

        public TestBean getNext() {
            return this.next;
        }

        public void setNext(TestBean next) {
            this.next = next;
        }

        public List<String> getStuffs() {
            return this.stuffs;
        }

        public void setStuffs(List<String> stuffs) {
            this.stuffs = stuffs;
        }

        public Object[] getArrayProp() {
            return this.arrayProp;
        }

        public void setArrayProp(Object[] arrayProp) {
            this.arrayProp = arrayProp;
        }

        public Map<String, Object> getMapProp() {
            return this.mapProp;
        }

        public void setMapProp(Map<String, Object> mapProp) {
            this.mapProp = mapProp;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TestAnnotation {
        public String afoo();
    }
}

