/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.view;

import java.util.ArrayList;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.control.TextControl;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.view.ViewIndex;

public class ViewIndexTest {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testClearIndexesAfterRender() throws Exception {
        Component[] components;
        ViewIndex viewIndex = new ViewIndex();
        InputField field = new InputField();
        BindingInfo bindingInfo = new BindingInfo();
        bindingInfo.setBindingPath("property1");
        field.setBindingInfo(bindingInfo);
        String fieldId = "field1";
        field.setId(fieldId);
        if (field.getRefreshWhenChangedPropertyNames() == null) {
            field.setRefreshWhenChangedPropertyNames(new ArrayList());
        }
        field.getRefreshWhenChangedPropertyNames().add("#lp.allDay eq true");
        TextControl textControl = new TextControl();
        String controlId = "text1";
        textControl.setId(controlId);
        field.setControl((Control)textControl);
        for (Component component : components = new Component[]{field}) {
            viewIndex.indexComponent(component);
            viewIndex.addInitialComponentStateIfNeeded(component);
        }
        for (Component component : components) {
            Assert.assertNotNull((Object)viewIndex.getComponentById(component.getId()));
        }
        viewIndex.clearIndexesAfterRender();
        for (Component component : components) {
            Assert.assertNotNull((Object)viewIndex.getComponentById(component.getId()));
            Assert.assertTrue((boolean)viewIndex.getInitialComponentStates().containsKey(component.getId()));
        }
    }
}

