/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.datadictionary.DataDictionaryException;

public class DataDictionaryBuilderTest {
    protected final Logger LOG = Logger.getLogger(this.getClass());
    static final String PACKAGE_CORE_BO = "org/kuali/rice/krad/bo/datadictionary/";
    static final String PACKAGE_CORE_DOCUMENT = "org/kuali/rice/krad/document/datadictionary/";
    static final String PACKAGE_KFS = "org/kuali/kfs/datadictionary/";
    static final String PACKAGE_CHART = "org/kuali/module/chart/datadictionary/";
    static final String PACKAGE_CG = "org/kuali/module/cg/datadictionary/";
    static final String PACKAGE_KRA_BUDGET = "org/kuali/module/kra/budget/datadictionary/";
    static final String PACKAGE_KRA_ROUTINGFORM = "org/kuali/module/kra/routingform/datadictionary/";
    static final String TESTPACKAGE_INVALID = "org/kuali/rice/krad/datadictionary/test/invalid/";
    DataDictionary dd = null;

    @Before
    public void setUp() throws Exception {
        this.dd = new DataDictionary();
    }

    @After
    public void tearDown() throws Exception {
        this.dd = null;
    }

    @Test
    public final void testDataDictionaryBuilder_source_invalid() throws Exception {
        boolean failedAsExpected = false;
        try {
            this.dd.addConfigFileLocation("KR-SAP", null);
        }
        catch (DataDictionaryException e) {
            failedAsExpected = true;
        }
        Assert.assertTrue((boolean)failedAsExpected);
    }

    @Test
    public final void testDataDictionaryBuilder_source_unknownFile() throws Exception {
        String INPUT_FILE = "org/kuali/rice/krad/datadictionary/test/invalid/foo.xml";
        boolean failedAsExpected = false;
        try {
            this.dd.addConfigFileLocation("KR-SAP", INPUT_FILE);
        }
        catch (DataDictionaryException e) {
            failedAsExpected = true;
        }
        Assert.assertTrue((boolean)failedAsExpected);
    }

    @Test
    public final void testDataDictionaryBuilder_source_unknownPackage() throws Exception {
        String UNKNOWN_PACKAGE = "org/kuali/rice/krad/datadictionary/test/invalid/foo/";
        boolean failedAsExpected = false;
        try {
            this.dd.addConfigFileLocation("KR-SAP", UNKNOWN_PACKAGE);
        }
        catch (DataDictionaryException e) {
            failedAsExpected = true;
        }
        Assert.assertTrue((boolean)failedAsExpected);
    }

    @Test
    public final void testDataDictionaryBuilder_invalidXml() throws Exception {
        String INPUT_FILE = "org/kuali/rice/krad/datadictionary/test/invalid/InvalidXml.xml";
        boolean failedAsExpected = false;
        try {
            this.dd.addConfigFileLocation("KR-SAP", INPUT_FILE);
            this.dd.parseDataDictionaryConfigurationFiles(false);
        }
        catch (DataDictionaryException e) {
            failedAsExpected = true;
        }
        catch (Exception e) {
            this.LOG.error((Object)"Error loading DD files", (Throwable)e);
            Assert.fail((String)("Data Dictionary file load failed but with wrong exception type '" + e.getClass().getName() + "'"));
        }
        Assert.assertTrue((boolean)failedAsExpected);
    }

    @Test
    public final void testDataDictionaryBuilder_getInvalidDictionary() throws Exception {
        String INPUT_FILE = "org/kuali/rice/krad/datadictionary/test/invalid/InvalidXml.xml";
        boolean failedAsExpected = false;
        try {
            this.dd.addConfigFileLocation("KR-SAP", INPUT_FILE);
            this.dd.parseDataDictionaryConfigurationFiles(false);
        }
        catch (DataDictionaryException e) {
            failedAsExpected = true;
        }
        catch (Exception e) {
            this.LOG.error((Object)"Error loading DD files", (Throwable)e);
            Assert.fail((String)("Data Dictionary file load failed but with wrong exception type '" + e.getClass().getName() + "'"));
        }
        Assert.assertTrue((boolean)failedAsExpected);
    }
}

