/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.validation.Account;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.DictionaryObjectAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;
import org.kuali.rice.krad.datadictionary.validation.constraint.FixedPointPatternConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.datadictionary.validation.processor.ValidCharactersConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;

public class FixedPointPatternConstraintTest {
    private AttributeDefinition totalBalanceDefinition;
    private AttributeDefinition debitBalanceDefinition;
    private AttributeDefinition creditBalanceDefinition;
    private BusinessObjectEntry addressEntry;
    private DictionaryValidationResult dictionaryValidationResult;
    private ValidCharactersConstraintProcessor processor;
    private Account iciciAccount = new Account("11111111", "ICICI", "5000.00", "15000", "-10000");
    private Account citibankAccount = new Account("22222222", "Citi Bank", "15000.70", "14999.70", "1.");
    private Account wellsFargoAccount = new Account("33333333", "Wells Fargo", "", ".25", "-.25");
    private Account morganAccount = new Account("44444444", "J P Morgan", "-1000.00", "1000.00", "-2000.00");
    private FixedPointPatternConstraint totalBalanceFixedPointPatternConstraint;
    private FixedPointPatternConstraint debitBalanceFixedPointPatternConstraint;
    private FixedPointPatternConstraint creditBalanceFixedPointPatternConstraint;
    private FixedPointPatternConstraint creditBalanceFixedPointPatternConstraint1;
    private FixedPointPatternConstraint creditBalanceFixedPointPatternConstraint2;

    @Before
    public void setUp() throws Exception {
        this.processor = new ValidCharactersConstraintProcessor();
        this.dictionaryValidationResult = new DictionaryValidationResult();
        this.dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        this.addressEntry = new BusinessObjectEntry();
        ArrayList<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();
        this.totalBalanceFixedPointPatternConstraint = new FixedPointPatternConstraint();
        this.totalBalanceFixedPointPatternConstraint.setMessageKey("validate.dummykey");
        this.totalBalanceFixedPointPatternConstraint.setValidationMessageParams(new ArrayList());
        this.totalBalanceFixedPointPatternConstraint.setPrecision(6);
        this.totalBalanceFixedPointPatternConstraint.setScale(2);
        this.totalBalanceDefinition = new AttributeDefinition();
        this.totalBalanceDefinition.setName("totalBalance");
        this.totalBalanceDefinition.setValidCharactersConstraint((ValidCharactersConstraint)this.totalBalanceFixedPointPatternConstraint);
        attributes.add(this.totalBalanceDefinition);
        this.debitBalanceFixedPointPatternConstraint = new FixedPointPatternConstraint();
        this.debitBalanceFixedPointPatternConstraint.setMessageKey("validate.dummykey");
        this.debitBalanceFixedPointPatternConstraint.setValidationMessageParams(new ArrayList());
        this.debitBalanceFixedPointPatternConstraint.setPrecision(6);
        this.debitBalanceFixedPointPatternConstraint.setScale(2);
        this.debitBalanceFixedPointPatternConstraint.setAllowNegative(true);
        this.debitBalanceDefinition = new AttributeDefinition();
        this.debitBalanceDefinition.setName("debitBalance");
        this.debitBalanceDefinition.setValidCharactersConstraint((ValidCharactersConstraint)this.debitBalanceFixedPointPatternConstraint);
        attributes.add(this.debitBalanceDefinition);
        this.creditBalanceFixedPointPatternConstraint = new FixedPointPatternConstraint();
        this.creditBalanceFixedPointPatternConstraint.setMessageKey("validate.dummykey");
        this.creditBalanceFixedPointPatternConstraint.setValidationMessageParams(new ArrayList());
        this.creditBalanceFixedPointPatternConstraint.setPrecision(0);
        this.creditBalanceFixedPointPatternConstraint.setScale(0);
        this.creditBalanceDefinition = new AttributeDefinition();
        this.creditBalanceDefinition.setName("creditBalance");
        this.creditBalanceDefinition.setValidCharactersConstraint((ValidCharactersConstraint)this.creditBalanceFixedPointPatternConstraint);
        attributes.add(this.creditBalanceDefinition);
        this.creditBalanceFixedPointPatternConstraint1 = new FixedPointPatternConstraint();
        this.creditBalanceFixedPointPatternConstraint1.setMessageKey("validate.dummykey");
        this.creditBalanceFixedPointPatternConstraint1.setValidationMessageParams(new ArrayList());
        this.creditBalanceFixedPointPatternConstraint1.setPrecision(2);
        this.creditBalanceFixedPointPatternConstraint1.setScale(3);
        this.creditBalanceFixedPointPatternConstraint2 = new FixedPointPatternConstraint();
        this.creditBalanceFixedPointPatternConstraint2.setMessageKey("validate.dummykey");
        this.creditBalanceFixedPointPatternConstraint2.setValidationMessageParams(new ArrayList());
        this.creditBalanceFixedPointPatternConstraint2.setPrecision(-2);
        this.creditBalanceFixedPointPatternConstraint2.setScale(-3);
        this.addressEntry.setAttributes(attributes);
    }

    @Test
    public void testValueEmpty() {
        ConstraintValidationResult result = this.process(this.wellsFargoAccount, "totalBalance", (ValidCharactersConstraint)this.totalBalanceFixedPointPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.INAPPLICABLE, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueValidPositiveNumber() {
        ConstraintValidationResult result = this.process(this.iciciAccount, "totalBalance", (ValidCharactersConstraint)this.totalBalanceFixedPointPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidPositiveNumber() {
        ConstraintValidationResult result = this.process(this.citibankAccount, "totalBalance", (ValidCharactersConstraint)this.totalBalanceFixedPointPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidNegativeNumber() {
        ConstraintValidationResult result = this.process(this.morganAccount, "totalBalance", (ValidCharactersConstraint)this.totalBalanceFixedPointPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueValidNegativeNumber() {
        ConstraintValidationResult result = this.process(this.morganAccount, "debitBalance", (ValidCharactersConstraint)this.debitBalanceFixedPointPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidNegativeNumber1() {
        ConstraintValidationResult result = this.process(this.iciciAccount, "debitBalance", (ValidCharactersConstraint)this.debitBalanceFixedPointPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidPositiveNumber1() {
        ConstraintValidationResult result = this.process(this.citibankAccount, "debitBalance", (ValidCharactersConstraint)this.debitBalanceFixedPointPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueValidNegativeNumber1() {
        ConstraintValidationResult result = this.process(this.wellsFargoAccount, "debitBalance", (ValidCharactersConstraint)this.debitBalanceFixedPointPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test(expected=RuntimeException.class)
    public void testZeroPrecisionAndScale() {
        ConstraintValidationResult result = this.process(this.wellsFargoAccount, "creditBalance", (ValidCharactersConstraint)this.creditBalanceFixedPointPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test(expected=RuntimeException.class)
    public void testPrecisionLessThanScale() {
        ConstraintValidationResult result = this.process(this.wellsFargoAccount, "creditBalance", (ValidCharactersConstraint)this.creditBalanceFixedPointPatternConstraint1);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test(expected=RuntimeException.class)
    public void testNegativePrecisionAndScale() {
        ConstraintValidationResult result = this.process(this.wellsFargoAccount, "creditBalance", (ValidCharactersConstraint)this.creditBalanceFixedPointPatternConstraint2);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    private ConstraintValidationResult process(Object object, String attributeName, ValidCharactersConstraint constraint) {
        DictionaryObjectAttributeValueReader attributeValueReader = new DictionaryObjectAttributeValueReader(object, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry);
        attributeValueReader.setAttributeName(attributeName);
        Object value = attributeValueReader.getValue();
        return this.processor.process(this.dictionaryValidationResult, value, constraint, (AttributeValueReader)attributeValueReader).getFirstConstraintValidationResult();
    }
}

