/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.CollectionDefinition;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.validation.Address;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.Company;
import org.kuali.rice.krad.datadictionary.validation.DictionaryObjectAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.Employee;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;
import org.kuali.rice.krad.datadictionary.validation.constraint.CollectionSizeConstraint;
import org.kuali.rice.krad.datadictionary.validation.processor.CollectionSizeConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;

public class CollectionSizeConstraintProcessorTest {
    private CollectionSizeConstraintProcessor processor;
    private CollectionDefinition constrained0to2;
    private CollectionDefinition constrained0to3;
    private CollectionDefinition constrained2to4;
    private CollectionDefinition constrained3to6;
    private CollectionDefinition constrained5to12;
    private CollectionDefinition unconstrained;
    private Company companyWithThreeAddressesAndThreeEmployees;

    @Before
    public void setUp() throws Exception {
        this.processor = new CollectionSizeConstraintProcessor();
        this.companyWithThreeAddressesAndThreeEmployees = new Company("3M");
        ArrayList<Address> addresses = new ArrayList<Address>();
        addresses.add(new Address("123 Broadway", "Suite 1200", "New York", "NY", "10005", "USA", null));
        addresses.add(new Address("124 Broadway", "Suite 1300", "New York", "NY", "10005", "USA", null));
        addresses.add(new Address("125 Broadway", "Suite 1400", "New York", "NY", "10005", "USA", null));
        this.companyWithThreeAddressesAndThreeEmployees.setLocations(addresses);
        ArrayList<Employee> employees = new ArrayList<Employee>();
        employees.add(new Employee());
        employees.add(new Employee());
        employees.add(new Employee());
        this.companyWithThreeAddressesAndThreeEmployees.setEmployees(employees);
        this.constrained0to2 = new CollectionDefinition(){

            public String getLabel() {
                return "Employees(s)";
            }

            public String getName() {
                return "employees";
            }

            public Integer getMaximumNumberOfElements() {
                return 2;
            }

            public Integer getMinimumNumberOfElements() {
                return 0;
            }
        };
        this.constrained0to3 = new CollectionDefinition(){

            public String getLabel() {
                return "Employee(s)";
            }

            public String getName() {
                return "employees";
            }

            public Integer getMaximumNumberOfElements() {
                return 3;
            }

            public Integer getMinimumNumberOfElements() {
                return 0;
            }
        };
        this.constrained2to4 = new CollectionDefinition(){

            public String getLabel() {
                return "Employees";
            }

            public String getName() {
                return "employees";
            }

            public Integer getMaximumNumberOfElements() {
                return 4;
            }

            public Integer getMinimumNumberOfElements() {
                return 2;
            }
        };
        this.constrained3to6 = new CollectionDefinition(){

            public String getLabel() {
                return "Employees";
            }

            public String getName() {
                return "employees";
            }

            public Integer getMaximumNumberOfElements() {
                return 6;
            }

            public Integer getMinimumNumberOfElements() {
                return 3;
            }
        };
        this.constrained5to12 = new CollectionDefinition(){

            public String getLabel() {
                return "Employee(s)";
            }

            public String getName() {
                return "employees";
            }

            public Integer getMaximumNumberOfElements() {
                return 12;
            }

            public Integer getMinimumNumberOfElements() {
                return 5;
            }
        };
        this.unconstrained = new CollectionDefinition(){

            public String getLabel() {
                return "Empployee(s)";
            }

            public String getName() {
                return "employees";
            }

            public Integer getMaximumNumberOfElements() {
                return null;
            }

            public Integer getMinimumNumberOfElements() {
                return null;
            }
        };
    }

    @Test
    public void testSimpleCollectionSizeWithinRangeSuccess() {
        DictionaryValidationResult dictionaryValidationResult = new DictionaryValidationResult();
        dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        ConstraintValidationResult result = this.process(dictionaryValidationResult, this.companyWithThreeAddressesAndThreeEmployees, this.constrained2to4, "employees");
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new CollectionSizeConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testSimpleCollectionSizeAtTopOfRangeSuccess() {
        DictionaryValidationResult dictionaryValidationResult = new DictionaryValidationResult();
        dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        ConstraintValidationResult result = this.process(dictionaryValidationResult, this.companyWithThreeAddressesAndThreeEmployees, this.constrained0to3, "employees");
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new CollectionSizeConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testSimpleCollectionSizeAtBottomOfRangeSuccess() {
        DictionaryValidationResult dictionaryValidationResult = new DictionaryValidationResult();
        dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        ConstraintValidationResult result = this.process(dictionaryValidationResult, this.companyWithThreeAddressesAndThreeEmployees, this.constrained3to6, "employees");
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new CollectionSizeConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testSimpleCollectionSizeBelowRangeFailure() {
        DictionaryValidationResult dictionaryValidationResult = new DictionaryValidationResult();
        dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        ConstraintValidationResult result = this.process(dictionaryValidationResult, this.companyWithThreeAddressesAndThreeEmployees, this.constrained5to12, "employees");
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new CollectionSizeConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testSimpleCollectionSizeAboveRangeFailure() {
        DictionaryValidationResult dictionaryValidationResult = new DictionaryValidationResult();
        dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        ConstraintValidationResult result = this.process(dictionaryValidationResult, this.companyWithThreeAddressesAndThreeEmployees, this.constrained0to2, "employees");
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new CollectionSizeConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testSimpleCollectionSizeUnconstrainedSuccess() {
        DictionaryValidationResult dictionaryValidationResult = new DictionaryValidationResult();
        dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        ConstraintValidationResult result = this.process(dictionaryValidationResult, this.companyWithThreeAddressesAndThreeEmployees, this.unconstrained, "employees");
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.NOCONSTRAINT, (Object)result.getStatus());
        Assert.assertEquals((Object)new CollectionSizeConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    private ConstraintValidationResult process(DictionaryValidationResult dictionaryValidationResult, Object object, CollectionDefinition definition, String attributeName) {
        BusinessObjectEntry entry = new BusinessObjectEntry();
        entry.setCollections(Collections.singletonList(definition));
        DictionaryObjectAttributeValueReader attributeValueReader = new DictionaryObjectAttributeValueReader(object, "org.kuali.rice.kns.datadictionary.validation.Company", (DataDictionaryEntry)entry);
        attributeValueReader.setAttributeName(attributeName);
        Collection value = (Collection)attributeValueReader.getValue();
        return this.processor.process(dictionaryValidationResult, value, (CollectionSizeConstraint)definition, (AttributeValueReader)attributeValueReader).getFirstConstraintValidationResult();
    }
}

