/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.container;

import java.util.ArrayList;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.control.SelectControl;
import org.kuali.rice.krad.uif.control.TextAreaControl;
import org.kuali.rice.krad.uif.field.InputField;

public class CollectionGroupTest {
    private CollectionGroup group;
    private Control innerControl;

    @Before
    public void setup() {
        this.group = new CollectionGroup();
        ArrayList<Object> items = new ArrayList<Object>();
        InputField field = new InputField();
        this.innerControl = new SelectControl();
        field.setControl(this.innerControl);
        items.add(field);
        items.add(new TextAreaControl());
        this.group.setItems(items);
    }

    @Test
    public void testPushCollectionGroupToReference() {
        this.group.pushCollectionGroupToReference();
        for (Component component : this.group.getItems()) {
            this.testForCollectionGroupInContext(component);
        }
        this.testForCollectionGroupInContext((Component)this.innerControl);
    }

    private void testForCollectionGroupInContext(Component component) {
        Assert.assertTrue((String)"The component does not have the collection group key in the context", (boolean)component.getContext().containsKey("collectionGroup"));
        Assert.assertTrue((String)"The collection group found is not the parent group", (component.getContext().get("collectionGroup") == this.group ? 1 : 0) != 0);
    }
}

