/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.framework.config.property.SimpleConfig;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewAuthorizer;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.uif.widget.Widget;
import org.kuali.rice.krad.util.GlobalVariables;

public class UifUnitTestUtils {
    public static Person getMockPerson(String id) {
        return new MockPerson(id);
    }

    public static void establishMockConfig(String applicationId) {
        SimpleConfig config = new SimpleConfig();
        config.putProperty("application.id", applicationId);
        ConfigContext.init((Config)config);
        GlobalResourceLoader.addResourceLoader((ResourceLoader)new ResourceLoader(){

            public <T> T getObject(ObjectDefinition definition) {
                return null;
            }

            public <T> T getService(QName qname) {
                if ("personService".equals(qname.getLocalPart())) {
                    return (T)new MockPersonService();
                }
                return null;
            }

            public void start() throws Exception {
            }

            public void stop() throws Exception {
            }

            public boolean isStarted() {
                return true;
            }

            public void addResourceLoader(ResourceLoader resourceLoader) {
            }

            public void addResourceLoaderFirst(ResourceLoader resourceLoader) {
            }

            public ResourceLoader getResourceLoader(QName name) {
                return null;
            }

            public List<QName> getResourceLoaderNames() {
                return null;
            }

            public List<ResourceLoader> getResourceLoaders() {
                return null;
            }

            public void removeResourceLoader(QName name) {
            }

            public void setName(QName name) {
            }

            public QName getName() {
                return new QName("TEST");
            }

            public String getContents(String indent, boolean servicePerLine) {
                return null;
            }
        });
    }

    public static void establishMockUserSession(String principalName) {
        UserSession session = new UserSession(principalName);
        GlobalVariables.setUserSession((UserSession)session);
    }

    public static ViewAuthorizer getAllowMostViewAuthorizer() {
        return new MockViewAuthorizer();
    }

    private static class MockViewAuthorizer
    implements ViewAuthorizer {
        private MockViewAuthorizer() {
        }

        public Set<String> getActionFlags(View view, ViewModel model, Person user, Set<String> actions) {
            return new HashSet<String>();
        }

        public Set<String> getEditModes(View view, ViewModel model, Person user, Set<String> editModes) {
            return new HashSet<String>();
        }

        public boolean canOpenView(View view, ViewModel model, Person user) {
            return true;
        }

        public boolean canEditView(View view, ViewModel model, Person user) {
            return true;
        }

        public boolean canUnmaskField(View view, ViewModel model, DataField field, String propertyName, Person user) {
            return true;
        }

        public boolean canPartialUnmaskField(View view, ViewModel model, DataField field, String propertyName, Person user) {
            return true;
        }

        public boolean canEditField(View view, ViewModel model, Field field, String propertyName, Person user) {
            return true;
        }

        public boolean canViewField(View view, ViewModel model, Field field, String propertyName, Person user) {
            return true;
        }

        public boolean canEditGroup(View view, ViewModel model, Group group, String groupId, Person user) {
            return true;
        }

        public boolean canViewGroup(View view, ViewModel model, Group group, String groupId, Person user) {
            return true;
        }

        public boolean canEditWidget(View view, ViewModel model, Widget widget, String widgetId, Person user) {
            return true;
        }

        public boolean canViewWidget(View view, ViewModel model, Widget widget, String widgetId, Person user) {
            return true;
        }

        public boolean canPerformAction(View view, ViewModel model, Action action, String actionEvent, String actionId, Person user) {
            return true;
        }

        public boolean canEditLine(View view, ViewModel model, CollectionGroup collectionGroup, String collectionPropertyName, Object line, Person user) {
            return true;
        }

        public boolean canViewLine(View view, ViewModel model, CollectionGroup collectionGroup, String collectionPropertyName, Object line, Person user) {
            return true;
        }

        public boolean canEditLineField(View view, ViewModel model, CollectionGroup collectionGroup, String collectionPropertyName, Object line, Field field, String propertyName, Person user) {
            return true;
        }

        public boolean canViewLineField(View view, ViewModel model, CollectionGroup collectionGroup, String collectionPropertyName, Object line, Field field, String propertyName, Person user) {
            return true;
        }

        public boolean canPerformLineAction(View view, ViewModel model, CollectionGroup collectionGroup, String collectionPropertyName, Object line, Action action, String actionEvent, String actionId, Person user) {
            return true;
        }
    }

    private static class MockPersonService
    implements PersonService {
        private MockPersonService() {
        }

        public Person getPerson(String principalId) {
            return UifUnitTestUtils.getMockPerson(principalId);
        }

        public List<Person> getPersonByExternalIdentifier(String externalIdentifierTypeCode, String externalId) {
            return null;
        }

        public Person getPersonByPrincipalName(String principalName) {
            return UifUnitTestUtils.getMockPerson(principalName);
        }

        public Person getPersonByEmployeeId(String employeeId) {
            return null;
        }

        public List<Person> findPeople(Map<String, String> criteria) {
            return null;
        }

        public List<Person> findPeople(Map<String, String> criteria, boolean unbounded) {
            return null;
        }

        public Class<? extends Person> getPersonImplementationClass() {
            return null;
        }

        public Map<String, String> resolvePrincipalNamesToPrincipalIds(BusinessObject businessObject, Map<String, String> fieldValues) {
            return null;
        }

        public Person updatePersonIfNecessary(String sourcePrincipalId, Person currentPerson) {
            return null;
        }
    }

    private static class MockPerson
    implements Person {
        private static final long serialVersionUID = 5330488987382249417L;
        private final String id;

        private MockPerson(String id) {
            this.id = id;
        }

        public void refresh() {
        }

        public String getPrincipalId() {
            return this.id;
        }

        public String getPrincipalName() {
            return this.id;
        }

        public String getEntityId() {
            return this.id;
        }

        public String getEntityTypeCode() {
            return null;
        }

        public String getFirstName() {
            return "Test";
        }

        public String getFirstNameUnmasked() {
            return "Test";
        }

        public String getMiddleName() {
            return "User";
        }

        public String getMiddleNameUnmasked() {
            return "User";
        }

        public String getLastName() {
            return this.id;
        }

        public String getLastNameUnmasked() {
            return this.id;
        }

        public String getName() {
            return "Test User " + this.id;
        }

        public String getNameUnmasked() {
            return "Test User " + this.id;
        }

        public String getEmailAddress() {
            return null;
        }

        public String getEmailAddressUnmasked() {
            return null;
        }

        public String getAddressLine1() {
            return null;
        }

        public String getAddressLine1Unmasked() {
            return null;
        }

        public String getAddressLine2() {
            return null;
        }

        public String getAddressLine2Unmasked() {
            return null;
        }

        public String getAddressLine3() {
            return null;
        }

        public String getAddressLine3Unmasked() {
            return null;
        }

        public String getAddressCity() {
            return null;
        }

        public String getAddressCityUnmasked() {
            return null;
        }

        public String getAddressStateProvinceCode() {
            return null;
        }

        public String getAddressStateProvinceCodeUnmasked() {
            return null;
        }

        public String getAddressPostalCode() {
            return null;
        }

        public String getAddressPostalCodeUnmasked() {
            return null;
        }

        public String getAddressCountryCode() {
            return null;
        }

        public String getAddressCountryCodeUnmasked() {
            return null;
        }

        public String getPhoneNumber() {
            return null;
        }

        public String getPhoneNumberUnmasked() {
            return null;
        }

        public String getCampusCode() {
            return null;
        }

        public Map<String, String> getExternalIdentifiers() {
            return null;
        }

        public boolean hasAffiliationOfType(String affiliationTypeCode) {
            return false;
        }

        public List<String> getCampusCodesForAffiliationOfType(String affiliationTypeCode) {
            return null;
        }

        public String getEmployeeStatusCode() {
            return null;
        }

        public String getEmployeeTypeCode() {
            return null;
        }

        public KualiDecimal getBaseSalaryAmount() {
            return null;
        }

        public String getExternalId(String externalIdentifierTypeCode) {
            return null;
        }

        public String getPrimaryDepartmentCode() {
            return null;
        }

        public String getEmployeeId() {
            return null;
        }

        public boolean isActive() {
            return false;
        }
    }
}

