/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.widget;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.datadictionary.validation.Employee;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.layout.TableLayoutManager;
import org.kuali.rice.krad.uif.service.ViewHelperService;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.RichTable;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.mockito.Mockito;

public class RichTableTest {
    public static final String S_TYPE = "{\"bSortable\" : false, \"sType\" : \"numeric\", \"aTargets\": [0]}";
    public static final String S_SORT_DATA_TARGETS_1 = "{\"sType\" : \"string\", \"sSortDataType\" : \"dom-text\", \"aTargets\": [1]}";
    public static final String S_SORT_DATA_TARGETS_2 = "{\"sType\" : \"string\", \"sSortDataType\" : \"dom-text\", \"aTargets\": [1]}".replace("1", "2");
    public static final String S_SORT_DATA_TARGETS_3 = "{\"sType\" : \"string\", \"sSortDataType\" : \"dom-text\", \"aTargets\": [1]}".replace("1", "3");
    public static final String EXPECTED = "{\"bSortable\" : false, \"sType\" : \"numeric\", \"aTargets\": [0]}, {\"sType\" : \"string\", \"sSortDataType\" : \"dom-text\", \"aTargets\": [1]} , " + S_SORT_DATA_TARGETS_2 + " , " + S_SORT_DATA_TARGETS_3;
    public static final String B_VISIBLE_FALSE_TARGETS_1 = "{bVisible: false, \"aTargets\": [1]}";
    public static final String B_SORTABLE_FALSE_TARGETS_3 = "{'bSortable': false, \"aTargets\": [3]}";
    private RichTable richTable;
    private CollectionGroup group;
    private View mockView;

    @Before
    public void setup() {
        this.richTable = new RichTable();
        this.richTable = (RichTable)Mockito.spy((Object)this.richTable);
        ConfigurationService configurationService = (ConfigurationService)Mockito.mock(ConfigurationService.class);
        ((RichTable)Mockito.doReturn((Object)configurationService).when((Object)this.richTable)).getConfigurationService();
        this.group = new CollectionGroup();
        this.group.setCollectionObjectClass(Employee.class);
        TableLayoutManager layoutManager = new TableLayoutManager();
        layoutManager.setRenderSequenceField(true);
        ArrayList<DataField> items = new ArrayList<DataField>(1);
        DataField name = new DataField();
        name.setPropertyName("employeeId");
        items.add(name);
        DataField number = new DataField();
        number.setPropertyName("positionTitle");
        items.add(number);
        DataField contactEmail = new DataField();
        contactEmail.setPropertyName("contactEmail");
        items.add(contactEmail);
        layoutManager = (TableLayoutManager)Mockito.spy((Object)layoutManager);
        ((TableLayoutManager)Mockito.doReturn(items).when((Object)layoutManager)).getFirstRowFields();
        this.group.setLayoutManager((LayoutManager)layoutManager);
        this.group.setIncludeLineSelectionField(false);
        this.group.setRenderLineActions(false);
        this.group.setItems(items);
        this.mockView = (View)Mockito.mock(View.class);
        ViewHelperService mockViewHelperService = (ViewHelperService)Mockito.mock(ViewHelperService.class);
        Mockito.when((Object)this.mockView.getViewHelperService()).thenReturn((Object)mockViewHelperService);
    }

    @Test
    public void testComponentOptionsDefault() throws Exception {
        this.assertRichTableComponentOptions(null, "[" + EXPECTED + " ]", "aoColumnDefs");
    }

    @Test
    public void testComponentOptionsAoColumnsJSOptions() throws Exception {
        String innerColValues = "{bVisible: false}, null, null";
        this.assertRichTableComponentOptions("[" + innerColValues + "]", "[" + EXPECTED + " ," + innerColValues + "]", "aoColumnDefs");
    }

    @Test
    public void testComponentOptionsHideColumnOnRichTable() {
        HashSet<String> hiddenColumns = new HashSet<String>();
        hiddenColumns.add("employeeId");
        HashSet<String> sortableColumns = new HashSet<String>();
        sortableColumns.add("positionTitle");
        this.richTable.setSortableColumns(sortableColumns);
        this.richTable.setHiddenColumns(hiddenColumns);
        String expected = "[{\"bSortable\" : false, \"sType\" : \"numeric\", \"aTargets\": [0]}, {bVisible: false, \"aTargets\": [1]}, " + S_SORT_DATA_TARGETS_2 + ", " + B_SORTABLE_FALSE_TARGETS_3 + "]";
        this.assertRichTableComponentOptions(null, expected, "aoColumnDefs");
    }

    @Test
    public void testComponentOptionsHideColumnOnLayoutManager() {
        HashSet<String> richTableHiddenColumns = new HashSet<String>();
        richTableHiddenColumns.add("employeeId");
        HashSet<String> sortableColumns = new HashSet<String>();
        sortableColumns.add("positionTitle");
        this.richTable.setSortableColumns(sortableColumns);
        this.richTable.setHiddenColumns(richTableHiddenColumns);
        HashSet<String> lmHiddenColumns = new HashSet<String>();
        lmHiddenColumns.add("contactEmail");
        HashSet<String> lmSortableColumns = new HashSet<String>();
        lmSortableColumns.add("employeeId");
        ((TableLayoutManager)this.group.getLayoutManager()).setSortableColumns(lmSortableColumns);
        ((TableLayoutManager)this.group.getLayoutManager()).setHiddenColumns(lmHiddenColumns);
        String expected = "[" + EXPECTED.replace("{\"sType\" : \"string\", \"sSortDataType\" : \"dom-text\", \"aTargets\": [1]} ,", "{bVisible: false, \"aTargets\": [1]},") + "]";
        expected = expected.replace(S_SORT_DATA_TARGETS_2 + " ,", S_SORT_DATA_TARGETS_2 + ",");
        expected = expected.replace(S_SORT_DATA_TARGETS_3, B_SORTABLE_FALSE_TARGETS_3);
        this.assertRichTableComponentOptions(null, expected, "aoColumnDefs");
    }

    private void assertRichTableComponentOptions(String optionsOnGroup, String optionsOnRichTable, String optionKey) {
        if (this.richTable.getTemplateOptions() == null) {
            this.richTable.setTemplateOptions(new HashMap());
        }
        this.richTable.getTemplateOptions().put(optionKey, optionsOnGroup);
        this.richTable.performFinalize(this.mockView, (Object)new UifFormBase(), (Component)this.group);
        Assert.assertEquals((Object)optionsOnRichTable, this.richTable.getTemplateOptions().get(optionKey));
    }
}

