/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.util.CsrfValidator;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class CsrfValidatorTest {
    private MockHttpServletRequest request = new MockHttpServletRequest();
    private MockHttpServletResponse response = new MockHttpServletResponse();

    @Test
    public void testValidateCsrf_NonUpdateHttpMethods() throws Exception {
        String sessionToken = CsrfValidator.getSessionToken((HttpServletRequest)this.request);
        Assert.assertNull((Object)sessionToken);
        this.request.setMethod("GET");
        Assert.assertTrue((boolean)CsrfValidator.validateCsrf((HttpServletRequest)this.request, (HttpServletResponse)this.response));
        sessionToken = CsrfValidator.getSessionToken((HttpServletRequest)this.request);
        Assert.assertNotNull((Object)sessionToken);
        this.request.setMethod("OPTIONS");
        Assert.assertTrue((boolean)CsrfValidator.validateCsrf((HttpServletRequest)this.request, (HttpServletResponse)this.response));
        String sessionToken2 = CsrfValidator.getSessionToken((HttpServletRequest)this.request);
        Assert.assertEquals((Object)sessionToken, (Object)sessionToken2);
        this.request.setMethod("HEAD");
        Assert.assertTrue((boolean)CsrfValidator.validateCsrf((HttpServletRequest)this.request, (HttpServletResponse)this.response));
        MockHttpServletRequest request2 = new MockHttpServletRequest();
        MockHttpServletResponse response2 = new MockHttpServletResponse();
        request2.setMethod("GET");
        Assert.assertTrue((boolean)CsrfValidator.validateCsrf((HttpServletRequest)request2, (HttpServletResponse)response2));
        Assert.assertNotEquals((Object)CsrfValidator.getSessionToken((HttpServletRequest)this.request), (Object)CsrfValidator.getSessionToken((HttpServletRequest)request2));
    }

    @Test
    public void testValidateCsrf_Valid() {
        this.request.setMethod("GET");
        Assert.assertTrue((boolean)CsrfValidator.validateCsrf((HttpServletRequest)this.request, (HttpServletResponse)this.response));
        String sessionToken = CsrfValidator.getSessionToken((HttpServletRequest)this.request);
        this.request.setMethod("POST");
        this.request.setParameter("csrfToken", sessionToken);
        Assert.assertTrue((boolean)CsrfValidator.validateCsrf((HttpServletRequest)this.request, (HttpServletResponse)this.response));
        Assert.assertEquals((Object)sessionToken, (Object)CsrfValidator.getSessionToken((HttpServletRequest)this.request));
    }

    @Test
    public void testValidateCsrf_Invalid_EmptySession() {
        this.request.setMethod("POST");
        Assert.assertFalse((boolean)CsrfValidator.validateCsrf((HttpServletRequest)this.request, (HttpServletResponse)this.response));
        Assert.assertEquals((long)403L, (long)this.response.getStatus());
        this.request = new MockHttpServletRequest();
        this.response = new MockHttpServletResponse();
        this.request.setMethod("POST");
        this.request.setParameter("csrfToken", UUID.randomUUID().toString());
        Assert.assertFalse((boolean)CsrfValidator.validateCsrf((HttpServletRequest)this.request, (HttpServletResponse)this.response));
        Assert.assertEquals((long)403L, (long)this.response.getStatus());
    }

    @Test
    public void testValidateCsrf_Invalid_TokenMismatch() {
        this.request.setMethod("GET");
        Assert.assertTrue((boolean)CsrfValidator.validateCsrf((HttpServletRequest)this.request, (HttpServletResponse)this.response));
        this.request.setMethod("POST");
        Assert.assertFalse((boolean)CsrfValidator.validateCsrf((HttpServletRequest)this.request, (HttpServletResponse)this.response));
        Assert.assertEquals((long)403L, (long)this.response.getStatus());
        this.response = new MockHttpServletResponse();
        this.request.setParameter("csrfToken", UUID.randomUUID().toString());
        Assert.assertFalse((boolean)CsrfValidator.validateCsrf((HttpServletRequest)this.request, (HttpServletResponse)this.response));
        Assert.assertEquals((long)403L, (long)this.response.getStatus());
    }
}

