/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.bo;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.PersistenceService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ModuleConfiguration
implements InitializingBean,
ApplicationContextAware {
    protected String namespaceCode;
    protected ApplicationContext applicationContext;
    protected List<String> packagePrefixes;
    protected List<String> databaseRepositoryFilePaths = new ArrayList<String>();
    protected List<String> dataDictionaryPackages = new ArrayList<String>();
    protected List<String> scriptConfigurationFilePaths = new ArrayList<String>();
    protected List<String> jobNames = new ArrayList<String>();
    protected List<String> triggerNames = new ArrayList<String>();
    protected List<String> resourceBundleNames = new ArrayList<String>();
    protected String dataSourceName;
    protected EntityManager entityManager;
    protected Map<Class, Class> externalizableBusinessObjectImplementations;
    protected boolean initializeDataDictionary;
    protected PersistenceService persistenceService;
    protected DataDictionaryService dataDictionaryService;

    public void afterPropertiesSet() throws Exception {
        if (this.isInitializeDataDictionary() && this.getDataDictionaryPackages() != null && !this.getDataDictionaryPackages().isEmpty()) {
            if (this.getDataDictionaryService() == null) {
                this.setDataDictionaryService(KRADServiceLocatorWeb.getDataDictionaryService());
            }
            if (this.getDataDictionaryService() == null) {
                this.setDataDictionaryService((DataDictionaryService)this.applicationContext.getBean("dataDictionaryService"));
            }
            if (this.dataDictionaryService != null) {
                this.dataDictionaryService.addDataDictionaryLocations(this.getNamespaceCode(), this.getDataDictionaryPackages());
            }
        }
        if (this.getDatabaseRepositoryFilePaths() != null) {
            for (String repositoryLocation : this.getDatabaseRepositoryFilePaths()) {
                if (this.getPersistenceService() == null) {
                    this.setPersistenceService(KRADServiceLocatorWeb.getPersistenceServiceOjb());
                }
                if (this.persistenceService == null) {
                    this.setPersistenceService((PersistenceService)this.applicationContext.getBean("persistenceServiceOjb"));
                }
                this.getPersistenceService().loadRepositoryDescriptor(repositoryLocation);
            }
        }
    }

    public List<String> getDatabaseRepositoryFilePaths() {
        return this.databaseRepositoryFilePaths;
    }

    public void setDatabaseRepositoryFilePaths(List<String> databaseRepositoryFilePaths) {
        this.trimList(databaseRepositoryFilePaths);
        this.databaseRepositoryFilePaths = databaseRepositoryFilePaths;
    }

    public List<String> getDataDictionaryPackages() {
        return this.dataDictionaryPackages;
    }

    public void setDataDictionaryPackages(List<String> dataDictionaryPackages) {
        this.trimList(dataDictionaryPackages);
        this.dataDictionaryPackages = dataDictionaryPackages;
    }

    public Map<Class, Class> getExternalizableBusinessObjectImplementations() {
        if (this.externalizableBusinessObjectImplementations == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.externalizableBusinessObjectImplementations);
    }

    public void setExternalizableBusinessObjectImplementations(Map<Class, Class> externalizableBusinessObjectImplementations) {
        if (externalizableBusinessObjectImplementations != null) {
            for (Class implClass : externalizableBusinessObjectImplementations.values()) {
                int implModifiers = implClass.getModifiers();
                if (!Modifier.isInterface(implModifiers) && !Modifier.isAbstract(implModifiers)) continue;
                throw new RuntimeException("Externalizable business object implementation class " + implClass.getName() + " must be a non-interface, non-abstract class");
            }
        }
        this.externalizableBusinessObjectImplementations = externalizableBusinessObjectImplementations;
    }

    public List<String> getPackagePrefixes() {
        return this.packagePrefixes;
    }

    public void setPackagePrefixes(List<String> packagePrefixes) {
        this.trimList(packagePrefixes);
        this.packagePrefixes = packagePrefixes;
    }

    public void setInitializeDataDictionary(boolean initializeDataDictionary) {
        this.initializeDataDictionary = initializeDataDictionary;
    }

    public List<String> getScriptConfigurationFilePaths() {
        return this.scriptConfigurationFilePaths;
    }

    public List<String> getJobNames() {
        return this.jobNames;
    }

    public void setJobNames(List<String> jobNames) {
        this.jobNames = jobNames;
    }

    public List<String> getTriggerNames() {
        return this.triggerNames;
    }

    public void setTriggerNames(List<String> triggerNames) {
        this.triggerNames = triggerNames;
    }

    public List<String> getResourceBundleNames() {
        return this.resourceBundleNames;
    }

    public void setResourceBundleNames(List<String> resourceBundleNames) {
        this.resourceBundleNames = resourceBundleNames;
    }

    public boolean isInitializeDataDictionary() {
        return this.initializeDataDictionary;
    }

    public void setScriptConfigurationFilePaths(List<String> scriptConfigurationFilePaths) {
        this.scriptConfigurationFilePaths = scriptConfigurationFilePaths;
    }

    public String getNamespaceCode() {
        return this.namespaceCode;
    }

    public void setNamespaceCode(String namespaceCode) {
        this.namespaceCode = namespaceCode;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    protected void trimList(List<String> stringList) {
        if (stringList != null) {
            for (int i = 0; i < stringList.size(); ++i) {
                String elmt = stringList.get(i);
                elmt = elmt.trim();
                stringList.set(i, elmt);
            }
        }
    }
}

