/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import java.beans.PropertyEditor;
import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.uif.DataType;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.krad.datadictionary.AttributeDefinitionBase;
import org.kuali.rice.krad.datadictionary.AttributeSecurity;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.datadictionary.control.ControlDefinition;
import org.kuali.rice.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.rice.krad.datadictionary.exception.ClassValidationException;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validation.ValidationPattern;
import org.kuali.rice.krad.datadictionary.validation.capability.CaseConstrainable;
import org.kuali.rice.krad.datadictionary.validation.capability.Formatable;
import org.kuali.rice.krad.datadictionary.validation.capability.HierarchicallyConstrainable;
import org.kuali.rice.krad.datadictionary.validation.capability.MustOccurConstrainable;
import org.kuali.rice.krad.datadictionary.validation.capability.PrerequisiteConstrainable;
import org.kuali.rice.krad.datadictionary.validation.capability.ValidCharactersConstrainable;
import org.kuali.rice.krad.datadictionary.validation.constraint.CaseConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.LookupConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.MustOccurConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.PrerequisiteConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.util.ObjectUtils;

@BeanTag(name="attributeDefinition-bean")
public class AttributeDefinition
extends AttributeDefinitionBase
implements CaseConstrainable,
PrerequisiteConstrainable,
Formatable,
HierarchicallyConstrainable,
MustOccurConstrainable,
ValidCharactersConstrainable {
    private static final long serialVersionUID = -2490613377818442742L;
    protected Boolean forceUppercase = Boolean.FALSE;
    protected DataType dataType;
    protected Boolean unique;
    @Deprecated
    protected ValidationPattern validationPattern;
    protected ControlDefinition control;
    protected Control controlField;
    protected String formatterClass;
    protected PropertyEditor propertyEditor;
    protected AttributeSecurity attributeSecurity;
    protected Boolean dynamic;
    protected String customValidatorClass;
    protected ValidCharactersConstraint validCharactersConstraint;
    protected CaseConstraint caseConstraint;
    protected List<PrerequisiteConstraint> dependencyConstraints;
    protected List<MustOccurConstraint> mustOccurConstraints;
    protected LookupConstraint lookupDefinition;
    protected String lookupContextPath;
    protected String childEntryName;
    private KeyValuesFinder optionsFinder;
    protected String alternateDisplayAttributeName;
    protected String additionalDisplayAttributeName;

    public void setForceUppercase(Boolean forceUppercase) {
        this.forceUppercase = forceUppercase;
    }

    @BeanTagAttribute(name="forceUppercase")
    public Boolean getForceUppercase() {
        return this.forceUppercase;
    }

    @BeanTagAttribute(name="maxLength")
    public Integer getMaxLength() {
        return this.getSimpleConstraint().getMaxLength();
    }

    public void setMaxLength(Integer maxLength) {
        this.getSimpleConstraint().setMaxLength(maxLength);
    }

    @BeanTagAttribute(name="exclusiveMin")
    public String getExclusiveMin() {
        return this.getSimpleConstraint().getExclusiveMin();
    }

    public void setExclusiveMin(String exclusiveMin) {
        this.getSimpleConstraint().setExclusiveMin(exclusiveMin);
    }

    @BeanTagAttribute(name="inclusiveMax")
    public String getInclusiveMax() {
        return this.getSimpleConstraint().getInclusiveMax();
    }

    public void setInclusiveMax(String inclusiveMax) {
        this.getSimpleConstraint().setInclusiveMax(inclusiveMax);
    }

    public void setValidationPattern(ValidationPattern validationPattern) {
        this.validationPattern = validationPattern;
    }

    public boolean hasValidationPattern() {
        return this.validationPattern != null;
    }

    public ValidationPattern getValidationPattern() {
        return this.validationPattern;
    }

    @BeanTagAttribute(name="oldControl", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public ControlDefinition getControl() {
        return this.control;
    }

    public void setControl(ControlDefinition control) {
        if (control == null) {
            throw new IllegalArgumentException("invalid (null) control");
        }
        this.control = control;
    }

    public boolean hasFormatterClass() {
        return this.formatterClass != null;
    }

    @Override
    @BeanTagAttribute(name="formatterClass")
    public String getFormatterClass() {
        return this.formatterClass;
    }

    public void setFormatterClass(String formatterClass) {
        if (formatterClass == null) {
            throw new IllegalArgumentException("invalid (null) formatterClass");
        }
        this.formatterClass = formatterClass;
    }

    @BeanTagAttribute(name="propertyEditor", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    public void setPropertyEditor(PropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
    }

    public void setPropertyEditorClass(Class<? extends PropertyEditor> propertyEditorClass) {
        this.propertyEditor = ObjectUtils.newInstance(propertyEditorClass);
    }

    @Override
    @Deprecated
    public void completeValidation(Class<?> rootObjectClass, Class<?> otherObjectClass) {
        block10: {
            try {
                if (!DataDictionary.isPropertyOf(rootObjectClass, this.getName())) {
                    throw new AttributeValidationException("property '" + this.getName() + "' is not a property of class '" + rootObjectClass.getName() + "' (" + "" + ")");
                }
                if (this.getControl() == null && this.getControlField() == null) {
                    throw new AttributeValidationException("property '" + this.getName() + "' in class '" + rootObjectClass.getName() + " does not have a control defined");
                }
                if (this.getControl() != null) {
                    this.getControl().completeValidation(rootObjectClass, otherObjectClass);
                }
                if (this.attributeSecurity != null) {
                    this.attributeSecurity.completeValidation(rootObjectClass, otherObjectClass);
                }
                if (this.validationPattern != null) {
                    this.validationPattern.completeValidation();
                }
                if (this.formatterClass == null) break block10;
                try {
                    Class formatterClassObject = ClassUtils.getClass((ClassLoader)ClassLoaderUtils.getDefaultClassLoader(), (String)this.getFormatterClass());
                    if (!Formatter.class.isAssignableFrom(formatterClassObject)) {
                        throw new ClassValidationException("formatterClass is not a valid instance of " + Formatter.class.getName() + " instead was: " + formatterClassObject.getName());
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new ClassValidationException("formatterClass could not be found: " + this.getFormatterClass(), e);
                }
            }
            catch (RuntimeException ex) {
                Logger.getLogger(this.getClass()).error((Object)("Unable to validate attribute " + rootObjectClass + "." + this.getName() + ": " + ex.getMessage()), (Throwable)ex);
                throw ex;
            }
        }
    }

    public void completeValidation(Class rootObjectClass, Class otherObjectClass, ValidationTrace tracer) {
        block10: {
            tracer.addBean(this.getClass().getSimpleName(), "Attribute: " + this.getName());
            try {
                String[] currentValues;
                if (!DataDictionary.isPropertyOf(rootObjectClass, this.getName())) {
                    currentValues = new String[]{"property = " + this.getName(), "class = " + rootObjectClass.getName()};
                    tracer.createError("Property is not found in class", currentValues);
                }
                if (this.getControl() == null && this.getControlField() == null) {
                    currentValues = new String[]{"property = " + this.getName(), "class = " + rootObjectClass.getName()};
                    tracer.createError("Property does not have a control defined in the class", currentValues);
                }
                if (this.getControl() != null) {
                    // empty if block
                }
                if (this.attributeSecurity != null) {
                    this.attributeSecurity.completeValidation(rootObjectClass, otherObjectClass, tracer.getCopy());
                }
                if (this.validationPattern != null) {
                    // empty if block
                }
                if (this.formatterClass == null) break block10;
                try {
                    Class formatterClassObject = ClassUtils.getClass((ClassLoader)ClassLoaderUtils.getDefaultClassLoader(), (String)this.getFormatterClass());
                    if (!Formatter.class.isAssignableFrom(formatterClassObject)) {
                        String[] currentValues2 = new String[]{"formatterClassObject = " + formatterClassObject.getName()};
                        tracer.createError("FormatterClass is not a valid instance", currentValues2);
                    }
                }
                catch (ClassNotFoundException e) {
                    String[] currentValues3 = new String[]{"class = " + this.getFormatterClass()};
                    tracer.createError("FormatterClass could not be found", currentValues3);
                }
            }
            catch (RuntimeException ex) {
                String[] currentValues = new String[]{"attribute = " + rootObjectClass + "." + this.getName(), "Exception = " + ex.getMessage()};
                tracer.createError("Unable to validate attribute", currentValues);
            }
        }
    }

    public String toString() {
        return "AttributeDefinition for attribute " + this.getName();
    }

    @BeanTagAttribute(name="attributeSecurity", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public AttributeSecurity getAttributeSecurity() {
        return this.attributeSecurity;
    }

    public void setAttributeSecurity(AttributeSecurity attributeSecurity) {
        this.attributeSecurity = attributeSecurity;
    }

    public boolean hasAttributeSecurity() {
        return this.attributeSecurity != null;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isEmpty((String)this.name)) {
            throw new RuntimeException("blank name for bean: " + this.id);
        }
    }

    public Boolean getUnique() {
        return this.unique;
    }

    public void setUnique(Boolean unique) {
        this.unique = unique;
    }

    @BeanTagAttribute(name="control", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public Control getControlField() {
        return this.controlField;
    }

    public void setControlField(Control controlField) {
        this.controlField = controlField;
    }

    @BeanTagAttribute(name="minLength")
    public Integer getMinLength() {
        return this.getSimpleConstraint().getMinLength();
    }

    public void setMinLength(Integer minLength) {
        this.getSimpleConstraint().setMinLength(minLength);
    }

    @BeanTagAttribute(name="dataType", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public DataType getDataType() {
        return this.simpleConstraint.getDataType();
    }

    public void setDataType(DataType dataType) {
        this.simpleConstraint.setDataType(dataType);
    }

    public void setDataType(String dataType) {
        this.simpleConstraint.setDataType(DataType.valueOf((String)dataType));
    }

    @BeanTagAttribute(name="customValidatorClass")
    public String getCustomValidatorClass() {
        return this.customValidatorClass;
    }

    public void setCustomValidatorClass(String customValidatorClass) {
        this.customValidatorClass = customValidatorClass;
    }

    @Override
    @BeanTagAttribute(name="validChractersConstraint", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public ValidCharactersConstraint getValidCharactersConstraint() {
        return this.validCharactersConstraint;
    }

    public void setValidCharactersConstraint(ValidCharactersConstraint validCharactersConstraint) {
        this.validCharactersConstraint = validCharactersConstraint;
    }

    @Override
    @BeanTagAttribute(name="caseConstraint", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public CaseConstraint getCaseConstraint() {
        return this.caseConstraint;
    }

    public void setCaseConstraint(CaseConstraint caseConstraint) {
        this.caseConstraint = caseConstraint;
    }

    @Override
    @BeanTagAttribute(name="prerequisteConstraint", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<PrerequisiteConstraint> getPrerequisiteConstraints() {
        return this.dependencyConstraints;
    }

    public void setPrerequisiteConstraints(List<PrerequisiteConstraint> dependencyConstraints) {
        this.dependencyConstraints = dependencyConstraints;
    }

    @Override
    @BeanTagAttribute(name="mustOccurConstraints", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<MustOccurConstraint> getMustOccurConstraints() {
        return this.mustOccurConstraints;
    }

    public void setMustOccurConstraints(List<MustOccurConstraint> mustOccurConstraints) {
        this.mustOccurConstraints = mustOccurConstraints;
    }

    public LookupConstraint getLookupDefinition() {
        return this.lookupDefinition;
    }

    public void setLookupDefinition(LookupConstraint lookupDefinition) {
        this.lookupDefinition = lookupDefinition;
    }

    public String getLookupContextPath() {
        return this.lookupContextPath;
    }

    public void setLookupContextPath(String lookupContextPath) {
        this.lookupContextPath = lookupContextPath;
    }

    @Override
    @BeanTagAttribute(name="childEntryName")
    public String getChildEntryName() {
        return this.childEntryName;
    }

    public void setChildEntryName(String childEntryName) {
        this.childEntryName = childEntryName;
    }

    @BeanTagAttribute(name="optionFinder", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public KeyValuesFinder getOptionsFinder() {
        return this.optionsFinder;
    }

    public void setOptionsFinder(KeyValuesFinder optionsFinder) {
        this.optionsFinder = optionsFinder;
    }

    public void setOptionsFinderClass(Class<? extends KeyValuesFinder> optionsFinderClass) {
        this.optionsFinder = ObjectUtils.newInstance(optionsFinderClass);
    }

    public void setAdditionalDisplayAttributeName(String additionalDisplayAttributeName) {
        this.additionalDisplayAttributeName = additionalDisplayAttributeName;
    }

    @BeanTagAttribute(name="additionalDisplayAttributeName")
    public String getAdditionalDisplayAttributeName() {
        return this.additionalDisplayAttributeName;
    }

    public void setAlternateDisplayAttributeName(String alternateDisplayAttributeName) {
        this.alternateDisplayAttributeName = alternateDisplayAttributeName;
    }

    @BeanTagAttribute(name="alternateDisplayAttributeName")
    public String getAlternateDisplayAttributeName() {
        return this.alternateDisplayAttributeName;
    }

    public List<PrerequisiteConstraint> getDependencyConstraints() {
        return this.dependencyConstraints;
    }

    public void setDependencyConstraints(List<PrerequisiteConstraint> dependencyConstraints) {
        this.dependencyConstraints = dependencyConstraints;
    }
}

