/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.CollectionDefinition;
import org.kuali.rice.krad.datadictionary.ComplexAttributeDefinition;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.DictionaryBeanBase;
import org.kuali.rice.krad.datadictionary.RelationshipDefinition;
import org.kuali.rice.krad.datadictionary.exception.DuplicateEntryException;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.state.StateMapping;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.exception.ValidationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;

public abstract class DataDictionaryEntryBase
extends DictionaryBeanBase
implements DataDictionaryEntry,
Serializable,
InitializingBean {
    protected List<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();
    protected List<ComplexAttributeDefinition> complexAttributes = new ArrayList<ComplexAttributeDefinition>();
    protected List<CollectionDefinition> collections = new ArrayList<CollectionDefinition>();
    protected List<RelationshipDefinition> relationships = new ArrayList<RelationshipDefinition>();
    protected Map<String, AttributeDefinition> attributeMap = new LinkedHashMap<String, AttributeDefinition>();
    protected Map<String, ComplexAttributeDefinition> complexAttributeMap = new LinkedHashMap<String, ComplexAttributeDefinition>();
    protected Map<String, CollectionDefinition> collectionMap = new LinkedHashMap<String, CollectionDefinition>();
    protected Map<String, RelationshipDefinition> relationshipMap = new LinkedHashMap<String, RelationshipDefinition>();
    protected StateMapping stateMapping;

    public abstract Class<?> getEntryClass();

    @Override
    public AttributeDefinition getAttributeDefinition(String attributeName) {
        if (StringUtils.isBlank((String)attributeName)) {
            throw new IllegalArgumentException("invalid (blank) attributeName");
        }
        return this.attributeMap.get(attributeName);
    }

    @BeanTagAttribute(name="attributes", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<AttributeDefinition> getAttributes() {
        return this.attributes;
    }

    public List<ComplexAttributeDefinition> getComplexAttributes() {
        return this.complexAttributes;
    }

    public void setComplexAttributes(List<ComplexAttributeDefinition> complexAttributes) {
        this.complexAttributeMap.clear();
        for (ComplexAttributeDefinition complexAttribute : complexAttributes) {
            if (complexAttribute == null) {
                throw new IllegalArgumentException("invalid (null) complexAttributeDefinition");
            }
            String complexAttributeName = complexAttribute.getName();
            if (StringUtils.isBlank((String)complexAttributeName)) {
                throw new ValidationException("invalid (blank) collectionName");
            }
            if (this.complexAttributeMap.containsKey(complexAttribute)) {
                throw new DuplicateEntryException("complex attribute '" + complexAttribute + "' already defined as an complex attribute for class '" + this.getEntryClass().getName() + "'");
            }
            if (this.collectionMap.containsKey(complexAttributeName)) {
                throw new DuplicateEntryException("complex attribute '" + complexAttributeName + "' already defined as a Collection for class '" + this.getEntryClass().getName() + "'");
            }
            if (this.attributeMap.containsKey(complexAttributeName)) {
                throw new DuplicateEntryException("complex attribute '" + complexAttributeName + "' already defined as an Attribute for class '" + this.getEntryClass().getName() + "'");
            }
            this.complexAttributeMap.put(complexAttributeName, complexAttribute);
        }
        this.complexAttributes = complexAttributes;
    }

    public CollectionDefinition getCollectionDefinition(String collectionName) {
        if (StringUtils.isBlank((String)collectionName)) {
            throw new IllegalArgumentException("invalid (blank) collectionName");
        }
        return this.collectionMap.get(collectionName);
    }

    @BeanTagAttribute(name="collections", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<CollectionDefinition> getCollections() {
        return this.collections;
    }

    public RelationshipDefinition getRelationshipDefinition(String relationshipName) {
        if (StringUtils.isBlank((String)relationshipName)) {
            throw new IllegalArgumentException("invalid (blank) relationshipName");
        }
        return this.relationshipMap.get(relationshipName);
    }

    @Override
    @BeanTagAttribute(name="relationships", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<RelationshipDefinition> getRelationships() {
        return this.relationships;
    }

    @Override
    public void completeValidation() {
        for (AttributeDefinition attributeDefinition : this.attributes) {
            attributeDefinition.completeValidation(this.getEntryClass(), null);
        }
        for (CollectionDefinition collectionDefinition : this.collections) {
            collectionDefinition.completeValidation((Class)this.getEntryClass(), (Class)null);
        }
        for (RelationshipDefinition relationshipDefinition : this.relationships) {
            relationshipDefinition.completeValidation((Class)this.getEntryClass(), (Class)null);
        }
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        for (AttributeDefinition attributeDefinition : this.getAttributes()) {
            attributeDefinition.completeValidation(this.getEntryClass(), null, tracer.getCopy());
        }
        for (CollectionDefinition collectionDefinition : this.getCollections()) {
            collectionDefinition.completeValidation(this.getEntryClass(), null, tracer.getCopy());
        }
        for (RelationshipDefinition relationshipDefinition : this.getRelationships()) {
            relationshipDefinition.completeValidation(this.getEntryClass(), null, tracer.getCopy());
        }
    }

    public void setAttributes(List<AttributeDefinition> attributes) {
        this.attributeMap.clear();
        for (AttributeDefinition attribute : attributes) {
            if (attribute == null) {
                throw new IllegalArgumentException("invalid (null) attributeDefinition");
            }
            String attributeName = attribute.getName();
            if (StringUtils.isBlank((String)attributeName)) {
                throw new ValidationException("invalid (blank) attributeName");
            }
            if (this.attributeMap.containsKey(attributeName)) {
                throw new DuplicateEntryException("attribute '" + attributeName + "' already defined as an Attribute for class '" + this.getEntryClass().getName() + "'");
            }
            if (this.collectionMap.containsKey(attributeName)) {
                throw new DuplicateEntryException("attribute '" + attributeName + "' already defined as a Collection for class '" + this.getEntryClass().getName() + "'");
            }
            if (this.complexAttributeMap.containsKey(attributeName)) {
                throw new DuplicateEntryException("attribute '" + attributeName + "' already defined as an Complex Attribute for class '" + this.getEntryClass().getName() + "'");
            }
            this.attributeMap.put(attributeName, attribute);
        }
        this.attributes = attributes;
    }

    public void setCollections(List<CollectionDefinition> collections) {
        this.collectionMap.clear();
        for (CollectionDefinition collection : collections) {
            if (collection == null) {
                throw new IllegalArgumentException("invalid (null) collectionDefinition");
            }
            String collectionName = collection.getName();
            if (StringUtils.isBlank((String)collectionName)) {
                throw new ValidationException("invalid (blank) collectionName");
            }
            if (this.collectionMap.containsKey(collectionName)) {
                throw new DuplicateEntryException("collection '" + collectionName + "' already defined for class '" + this.getEntryClass().getName() + "'");
            }
            if (this.attributeMap.containsKey(collectionName)) {
                throw new DuplicateEntryException("collection '" + collectionName + "' already defined as an Attribute for class '" + this.getEntryClass().getName() + "'");
            }
            if (this.complexAttributeMap.containsKey(collectionName)) {
                throw new DuplicateEntryException("collection '" + collectionName + "' already defined as Complex Attribute for class '" + this.getEntryClass().getName() + "'");
            }
            this.collectionMap.put(collectionName, collection);
        }
        this.collections = collections;
    }

    public void setRelationships(List<RelationshipDefinition> relationships) {
        this.relationships = relationships;
    }

    public Set<String> getCollectionNames() {
        return this.collectionMap.keySet();
    }

    public Set<String> getAttributeNames() {
        return this.attributeMap.keySet();
    }

    public Set<String> getRelationshipNames() {
        return this.relationshipMap.keySet();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.relationships != null) {
            this.relationshipMap.clear();
            for (RelationshipDefinition relationship : this.relationships) {
                if (relationship == null) {
                    throw new IllegalArgumentException("invalid (null) relationshipDefinition");
                }
                String relationshipName = relationship.getObjectAttributeName();
                if (StringUtils.isBlank((String)relationshipName)) {
                    throw new ValidationException("invalid (blank) relationshipName");
                }
                relationship.setSourceClass(this.getEntryClass());
                this.relationshipMap.put(relationshipName, relationship);
            }
        }
        if (this.complexAttributes != null) {
            for (ComplexAttributeDefinition complexAttribute : this.complexAttributes) {
                this.addNestedAttributes(complexAttribute, complexAttribute.getName());
            }
        }
    }

    private void addNestedAttributes(ComplexAttributeDefinition complexAttribute, String attrPath) {
        DataDictionaryEntryBase dataDictionaryEntry = (DataDictionaryEntryBase)complexAttribute.getDataObjectEntry();
        for (AttributeDefinition attribute : dataDictionaryEntry.getAttributes()) {
            String nestedAttributeName = attrPath + "." + attribute.getName();
            AttributeDefinition nestedAttribute = this.copyAttributeDefinition(attribute);
            nestedAttribute.setName(nestedAttributeName);
            if (this.attributeMap.containsKey(nestedAttributeName)) continue;
            this.attributes.add(nestedAttribute);
            this.attributeMap.put(nestedAttributeName, nestedAttribute);
        }
        List<ComplexAttributeDefinition> nestedComplexAttributes = dataDictionaryEntry.getComplexAttributes();
        if (nestedComplexAttributes != null) {
            for (ComplexAttributeDefinition nestedComplexAttribute : nestedComplexAttributes) {
                this.addNestedAttributes(nestedComplexAttribute, attrPath + "." + nestedComplexAttribute.getName());
            }
        }
    }

    private AttributeDefinition copyAttributeDefinition(AttributeDefinition attrDefToCopy) {
        AttributeDefinition attrDefCopy = new AttributeDefinition();
        try {
            BeanUtils.copyProperties((Object)attrDefToCopy, (Object)attrDefCopy, (String[])new String[]{"formatterClass"});
            attrDefCopy.setRequired(attrDefToCopy.isRequired());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attrDefCopy;
    }

    @Override
    @BeanTagAttribute(name="stateMapping", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public StateMapping getStateMapping() {
        return this.stateMapping;
    }

    @Override
    public void setStateMapping(StateMapping stateMapping) {
        this.stateMapping = stateMapping;
    }
}

