/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.parse;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttributeInfo;
import org.kuali.rice.krad.datadictionary.parse.BeanTagInfo;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentBase;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CustomTagAnnotations {
    private static final Log LOG = LogFactory.getLog(CustomTagAnnotations.class);
    private static final String BEAN_SUFFIX = "-bean";
    private static Map<String, Map<String, BeanTagAttributeInfo>> attributeProperties;
    private static Map<String, BeanTagInfo> beanTags;
    private static List<Class<?>> customTagClasses;

    private static void loadCustomTagClasses() {
        try {
            customTagClasses = CustomTagAnnotations.findTagClasses("org.kuali.rice.krad");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Class<?>> findTagClasses(String basePackage) throws IOException, ClassNotFoundException {
        Resource[] resources;
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
        ArrayList classes = new ArrayList();
        String resolvedBasePackage = ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)basePackage));
        String packageSearchPath = "classpath*:" + resolvedBasePackage + "/" + "**/*.class";
        for (Resource resource : resources = resourcePatternResolver.getResources(packageSearchPath)) {
            MetadataReader metadataReader;
            if (!resource.isReadable() || (metadataReader = metadataReaderFactory.getMetadataReader(resource)) == null || !CustomTagAnnotations.isBeanTag(metadataReader)) continue;
            classes.add(Class.forName(metadataReader.getClassMetadata().getClassName()));
        }
        return classes;
    }

    private static boolean isBeanTag(MetadataReader metadataReader) {
        try {
            try {
                Class<?> c = Class.forName(metadataReader.getClassMetadata().getClassName());
                if (c.getAnnotation(BeanTag.class) != null || c.getAnnotation(BeanTags.class) != null) {
                    return true;
                }
            }
            catch (Throwable e) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void generateSchemaFile(ResourceBundle doc) {
        HashMap nameTagMap = new HashMap();
        Map<String, BeanTagInfo> beanMap = CustomTagAnnotations.getBeanTags();
        BeanTagInfo[] infos = new BeanTagInfo[beanMap.values().size()];
        infos = beanMap.values().toArray(infos);
        String[] tags = new String[beanMap.entrySet().size()];
        try {
            tags = beanMap.keySet().toArray(tags);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < infos.length; ++i) {
            String name = infos[i].getBeanClass().getName();
            String tag = tags[i];
            HashMap<String, BeanTagInfo> existingTags = (HashMap<String, BeanTagInfo>)nameTagMap.get(name);
            if (existingTags == null) {
                existingTags = new HashMap<String, BeanTagInfo>();
            }
            if (infos[i].isDefaultTag() || existingTags.isEmpty()) {
                infos[i].setDefaultTag(true);
                existingTags.put("default", infos[i]);
            }
            if (infos[i].getParent() != null) {
                existingTags.put(infos[i].getParent(), infos[i]);
            }
            nameTagMap.put(name, existingTags);
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            ArrayList<Element> types = new ArrayList<Element>();
            ArrayList<Element> elements = new ArrayList<Element>();
            Set<String> classKeys = nameTagMap.keySet();
            HashMap<String, Element> elementObjects = new HashMap<String, Element>();
            CustomTagAnnotations.initializeElementObjects(document, classKeys, elementObjects);
            Map<String, BeanTagAttributeInfo> componentAttributes = CustomTagAnnotations.getAttributes(ComponentBase.class);
            ArrayList<Element> componentAttributeElements = new ArrayList<Element>();
            for (String className : classKeys) {
                Map tagMap = (Map)nameTagMap.get(className);
                Class<?> clazz = Class.forName(className);
                BeanTagInfo typeInfo = (BeanTagInfo)tagMap.get("default");
                String currentType = typeInfo.getTag();
                boolean isComponentBase = currentType.equals("componentBase-bean");
                boolean isComponent = Component.class.isAssignableFrom(clazz);
                Element complexType = document.createElement("xsd:complexType");
                complexType.setAttribute("name", currentType + "-type");
                Element complexContent = null;
                Element extension = null;
                if (isComponent) {
                    complexContent = document.createElement("xsd:complexContent");
                    extension = document.createElement("xsd:extension");
                    extension.setAttribute("base", "componentAttributes-type");
                    complexContent.appendChild(extension);
                    complexType.appendChild(complexContent);
                }
                Element sequence = document.createElement("xsd:choice");
                sequence.setAttribute("minOccurs", "0");
                sequence.setAttribute("maxOccurs", "unbounded");
                ArrayList<Element> attributeProperties = new ArrayList<Element>();
                Map<String, BeanTagAttributeInfo> attributes = CustomTagAnnotations.getAttributes(typeInfo.getBeanClass());
                if (attributes != null && !attributes.isEmpty()) {
                    for (BeanTagAttributeInfo aInfo : attributes.values()) {
                        boolean useAttribute = true;
                        boolean appendListAttributes = false;
                        String attrType = "xsd:anyType";
                        if (aInfo.getType().equals((Object)BeanTagAttribute.AttributeType.SINGLEVALUE)) {
                            attrType = "xsd:string";
                        } else if (aInfo.getType().equals((Object)BeanTagAttribute.AttributeType.SINGLEBEAN)) {
                            String attributeClass = aInfo.getValueType().getName();
                            if (elementObjects.containsKey(attributeClass)) {
                                attrType = attributeClass;
                            }
                        } else if (aInfo.getType().equals((Object)BeanTagAttribute.AttributeType.LISTVALUE) || aInfo.getType().equals((Object)BeanTagAttribute.AttributeType.SETVALUE)) {
                            appendListAttributes = true;
                            attrType = "basicList-type";
                        } else if (aInfo.getType().equals((Object)BeanTagAttribute.AttributeType.MAPVALUE) || aInfo.getType().equals((Object)BeanTagAttribute.AttributeType.MAPBEAN) || aInfo.getType().equals((Object)BeanTagAttribute.AttributeType.MAP2BEAN)) {
                            appendListAttributes = true;
                            attrType = "spring:mapType";
                        } else if (aInfo.getType().equals((Object)BeanTagAttribute.AttributeType.LISTBEAN) || aInfo.getType().equals((Object)BeanTagAttribute.AttributeType.SETBEAN)) {
                            useAttribute = false;
                            appendListAttributes = true;
                            attrType = "spring:listOrSetType";
                        }
                        Element element = document.createElement("xsd:element");
                        element.setAttribute("name", aInfo.getName());
                        element.setAttribute("minOccurs", "0");
                        element.setAttribute("maxOccurs", "1");
                        element.appendChild(CustomTagAnnotations.getDocAnnotation(document, doc, className, aInfo.getName(), aInfo.getValueType().getName()));
                        if (appendListAttributes) {
                            Element extensionType = CustomTagAnnotations.getListExtension(document, aInfo, attrType);
                            if (extensionType != null) {
                                element.appendChild(extensionType);
                            } else {
                                element.setAttribute("type", attrType);
                            }
                        } else {
                            element.setAttribute("type", attrType);
                        }
                        sequence.appendChild(element);
                        if (isComponent && componentAttributes.containsValue(aInfo) && !isComponentBase || !useAttribute) continue;
                        Element attribute = document.createElement("xsd:attribute");
                        attribute.setAttribute("name", aInfo.getName());
                        attribute.appendChild(CustomTagAnnotations.getDocAnnotation(document, doc, className, aInfo.getName(), aInfo.getValueType().getName()));
                        attributeProperties.add(attribute);
                    }
                }
                Element nestedPropertiesElement = document.createElement("xsd:element");
                nestedPropertiesElement.setAttribute("ref", "spring:property");
                nestedPropertiesElement.setAttribute("minOccurs", "0");
                nestedPropertiesElement.setAttribute("maxOccurs", "unbounded");
                sequence.appendChild(nestedPropertiesElement);
                if (isComponent) {
                    extension.appendChild(sequence);
                } else {
                    complexType.appendChild(sequence);
                }
                if (!isComponent || isComponentBase) {
                    Element parentAttribute = document.createElement("xsd:attribute");
                    parentAttribute.setAttribute("name", "parent");
                    parentAttribute.setAttribute("type", "xsd:string");
                    attributeProperties.add(parentAttribute);
                }
                Element anyAttribute = document.createElement("xsd:anyAttribute");
                anyAttribute.setAttribute("processContents", "skip");
                attributeProperties.add(anyAttribute);
                if (isComponentBase) {
                    componentAttributeElements = attributeProperties;
                } else {
                    for (Element attribute : attributeProperties) {
                        if (isComponent) {
                            extension.appendChild(attribute);
                            continue;
                        }
                        complexType.appendChild(attribute);
                    }
                }
                types.add(complexType);
                CustomTagAnnotations.appendElementObjects(document, elementObjects, clazz, tagMap);
                Element typeElement = document.createElement("xsd:element");
                typeElement.setAttribute("name", typeInfo.getTag());
                typeElement.setAttribute("type", currentType + "-type");
                typeElement.appendChild(CustomTagAnnotations.getDocAnnotation(document, doc, className, null, null));
                elements.add(typeElement);
                Set tagKeys = tagMap.keySet();
                for (String key : tagKeys) {
                    String tag = ((BeanTagInfo)tagMap.get(key)).getTag();
                    if (tag.equals(currentType)) continue;
                    Element element = document.createElement("xsd:element");
                    element.setAttribute("name", tag);
                    element.setAttribute("type", currentType + "-type");
                    element.appendChild(CustomTagAnnotations.getDocAnnotation(document, doc, className, null, null));
                    elements.add(element);
                }
            }
            CustomTagAnnotations.fillAndWriteSchema(builder, elements, types, elementObjects, componentAttributeElements);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void fillAndWriteSchema(DocumentBuilder builder, List<Element> elements, List<Element> types, Map<String, Element> elementObjects, List<Element> componentAttributeElements) throws TransformerException, IOException {
        Document topLevelDocument = builder.newDocument();
        Element schema = CustomTagAnnotations.getSchemaInstance(topLevelDocument);
        Element include = topLevelDocument.createElement("xsd:include");
        include.setAttribute("schemaLocation", "krad-elements.xsd");
        schema.appendChild(include);
        topLevelDocument.appendChild(schema);
        Document elementsDocument = builder.newDocument();
        schema = CustomTagAnnotations.getSchemaInstance(elementsDocument);
        ArrayList<Document> documentsToWrite = new ArrayList<Document>();
        for (Element element : elements) {
            schema.appendChild(elementsDocument.importNode(element, true));
        }
        elementsDocument.appendChild(schema);
        Document baseTypesDocument = builder.newDocument();
        schema = CustomTagAnnotations.getSchemaInstance(baseTypesDocument);
        include = baseTypesDocument.createElement("xsd:include");
        include.setAttribute("schemaLocation", "krad-elements.xsd");
        schema.appendChild(include);
        Element basicListType = baseTypesDocument.createElement("xsd:complexType");
        basicListType.setAttribute("name", "basicList-type");
        Element basicListSequence = baseTypesDocument.createElement("xsd:sequence");
        Element basicListElement = baseTypesDocument.createElement("xsd:element");
        basicListElement.setAttribute("minOccurs", "0");
        basicListElement.setAttribute("maxOccurs", "unbounded");
        basicListElement.setAttribute("ref", "spring:value");
        Element basicListMergeAttribute = baseTypesDocument.createElement("xsd:attribute");
        basicListMergeAttribute.setAttribute("name", "merge");
        basicListMergeAttribute.setAttribute("type", "xsd:boolean");
        basicListSequence.appendChild(basicListElement);
        basicListType.appendChild(basicListSequence);
        basicListType.appendChild(basicListMergeAttribute);
        schema.appendChild(basicListType);
        Element componentAttributesType = baseTypesDocument.createElement("xsd:complexType");
        componentAttributesType.setAttribute("name", "componentAttributes-type");
        for (Element attribute : componentAttributeElements) {
            componentAttributesType.appendChild(baseTypesDocument.importNode(attribute, true));
        }
        schema.appendChild(componentAttributesType);
        for (String objectName : elementObjects.keySet()) {
            schema.appendChild(baseTypesDocument.importNode(elementObjects.get(objectName), true));
        }
        baseTypesDocument.appendChild(schema);
        Document typesDocument = builder.newDocument();
        schema = CustomTagAnnotations.getSchemaInstance(typesDocument);
        int startIndex = 0;
        int endIndex = 60;
        if (endIndex > types.size()) {
            endIndex = types.size();
        }
        boolean complete = false;
        while (!complete) {
            List<Element> typesSubList = types.subList(startIndex, endIndex);
            include = typesDocument.createElement("xsd:include");
            include.setAttribute("schemaLocation", "krad-baseTypes.xsd");
            schema.appendChild(include);
            for (Element type : typesSubList) {
                schema.appendChild(typesDocument.importNode(type, true));
            }
            typesDocument.appendChild(schema);
            documentsToWrite.add(typesDocument);
            startIndex = endIndex;
            if ((endIndex += 60) > types.size()) {
                endIndex = types.size();
            }
            if (startIndex == types.size()) {
                complete = true;
            }
            typesDocument = builder.newDocument();
            schema = CustomTagAnnotations.getSchemaInstance(typesDocument);
        }
        Node elementsSchema = elementsDocument.getFirstChild();
        for (int i = 0; i < documentsToWrite.size(); ++i) {
            include = elementsDocument.createElement("xsd:include");
            include.setAttribute("schemaLocation", "krad-types" + (i + 1) + ".xsd");
            elementsSchema.insertBefore(include, elementsSchema.getFirstChild());
        }
        CustomTagAnnotations.writeDocument(topLevelDocument, "krad-schema.xsd");
        CustomTagAnnotations.writeDocument(elementsDocument, "krad-elements.xsd");
        CustomTagAnnotations.writeDocument(baseTypesDocument, "krad-baseTypes.xsd");
        int part = 1;
        for (Document document : documentsToWrite) {
            CustomTagAnnotations.writeDocument(document, "krad-types" + part + ".xsd");
            ++part;
        }
    }

    private static void writeDocument(Document document, String documentName) throws TransformerException, IOException {
        File file = new File("./" + documentName);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.transform(new DOMSource(document), new StreamResult(new FileWriter(file)));
    }

    private static Element getSchemaInstance(Document document) {
        Element schema = document.createElement("xsd:schema");
        schema.setAttribute("xmlns", "http://www.kuali.org/krad/schema");
        schema.setAttribute("targetNamespace", "http://www.kuali.org/krad/schema");
        schema.setAttribute("elementFormDefault", "qualified");
        schema.setAttribute("attributeFormDefault", "unqualified");
        schema.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        schema.setAttribute("xmlns:spring", "http://www.springframework.org/schema/beans");
        schema.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        schema.setAttribute("xsi:schemaLocation", "http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-3.0.xsd http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util-3.0.xsd");
        Element springImport = document.createElement("xsd:import");
        springImport.setAttribute("namespace", "http://www.springframework.org/schema/beans");
        schema.appendChild(springImport);
        return schema;
    }

    private static void initializeElementObjects(Document document, Set<String> classKeys, Map<String, Element> elementObjects) throws ClassNotFoundException {
        for (String className : classKeys) {
            Class<?> clazz = Class.forName(className);
            while (!clazz.equals(Object.class)) {
                for (Class<?> currentInterface : clazz.getInterfaces()) {
                    if (!currentInterface.getName().startsWith("org.kuali")) continue;
                    Element elementObject = document.createElement("xsd:complexType");
                    elementObject.setAttribute("name", currentInterface.getName());
                    Element choice = document.createElement("xsd:choice");
                    choice.setAttribute("minOccurs", "0");
                    choice.setAttribute("maxOccurs", "unbounded");
                    Element springBean = document.createElement("xsd:element");
                    springBean.setAttribute("ref", "spring:bean");
                    Element springRef = document.createElement("xsd:element");
                    springRef.setAttribute("ref", "spring:ref");
                    choice.appendChild(springRef);
                    choice.appendChild(springBean);
                    elementObject.appendChild(choice);
                    elementObjects.put(currentInterface.getName(), elementObject);
                }
                Element elementObject = document.createElement("xsd:complexType");
                elementObject.setAttribute("name", clazz.getName());
                Element choice = document.createElement("xsd:choice");
                choice.setAttribute("minOccurs", "0");
                choice.setAttribute("maxOccurs", "unbounded");
                Element springBean = document.createElement("xsd:element");
                springBean.setAttribute("ref", "spring:bean");
                Element springRef = document.createElement("xsd:element");
                springRef.setAttribute("ref", "spring:ref");
                choice.appendChild(springRef);
                choice.appendChild(springBean);
                elementObject.appendChild(choice);
                elementObjects.put(clazz.getName(), elementObject);
                clazz = clazz.getSuperclass();
            }
        }
    }

    private static void appendElementObjects(Document document, Map<String, Element> elementObjects, Class clazz, Map<String, BeanTagInfo> tagMap) {
        Element elementObject = elementObjects.get(clazz.getName());
        Set<String> tagKeys = tagMap.keySet();
        while (!clazz.equals(Object.class)) {
            ArrayList<String> added = new ArrayList<String>();
            for (Class<?> currentInterface : clazz.getInterfaces()) {
                if (!currentInterface.getName().startsWith("org.kuali")) continue;
                elementObject = elementObjects.get(currentInterface.getName());
                for (String key : tagKeys) {
                    String tag = tagMap.get(key).getTag();
                    if (added.contains(tag)) continue;
                    added.add(tag);
                    Element iRef = document.createElement("xsd:element");
                    iRef.setAttribute("ref", tag);
                    elementObject.getChildNodes().item(0).appendChild(iRef);
                }
            }
            elementObject = elementObjects.get(clazz.getName());
            added = new ArrayList();
            for (String key : tagKeys) {
                String tag = tagMap.get(key).getTag();
                if (added.contains(tag)) continue;
                added.add(tag);
                Element ref = document.createElement("xsd:element");
                ref.setAttribute("ref", tag);
                elementObject.getChildNodes().item(0).appendChild(ref);
            }
            clazz = clazz.getSuperclass();
        }
    }

    private static Element getDocAnnotation(Document document, ResourceBundle doc, String className, String property, String propertyType) {
        try {
            Class<?> clazz = Class.forName(className);
            Element annotation = document.createElement("xsd:annotation");
            Element documentation = document.createElement("xsd:documentation");
            documentation.setAttribute("source", clazz.getName());
            documentation.setAttribute("xml:lang", "en");
            String content = "documentation not available";
            if (property == null || propertyType == null) {
                if (doc.containsKey(clazz.getName())) {
                    content = "Backing Class: " + className + "\n\n" + doc.getString(clazz.getName());
                }
            } else {
                String key;
                int begin = 0;
                int end = propertyType.length();
                if (propertyType.lastIndexOf(46) != -1) {
                    begin = propertyType.lastIndexOf(46) + 1;
                }
                if (propertyType.indexOf(60) != -1) {
                    end = propertyType.indexOf(60);
                }
                if (doc.containsKey(key = clazz.getName() + "|" + property + "|" + propertyType.substring(begin, end))) {
                    content = doc.getString(key);
                } else {
                    boolean foundContent = false;
                    while (!clazz.equals(Object.class) && !foundContent) {
                        for (Class<?> currentInterface : clazz.getInterfaces()) {
                            if (!currentInterface.getName().startsWith("org.kuali")) continue;
                            key = currentInterface.getName() + "|" + property + "|" + propertyType.substring(begin, end);
                            foundContent = doc.containsKey(key) && StringUtils.isNotBlank((String)doc.getString(key));
                        }
                        if (foundContent) break;
                        key = clazz.getName() + "|" + property + "|" + propertyType.substring(begin, end);
                        foundContent = doc.containsKey(key) && StringUtils.isNotBlank((String)doc.getString(key));
                        clazz = clazz.getSuperclass();
                    }
                    if (foundContent) {
                        content = doc.getString(key);
                    }
                }
            }
            content = content.replaceAll("\\<li\\>", "\n-");
            content = content.replaceAll("\\<\\\\ol\\>", "\n");
            content = content.replaceAll("\\<\\\\ul\\>", "\n");
            content = content.replaceAll("\\<.*?\\>", "");
            content = content.replaceAll("\\{\\@code\\s(.*?)\\}", "$1");
            content = content.replaceAll("\\{\\@link\\s(.*?)\\}", "$1");
            content = content.replaceAll("\\{\\@see\\s(.*?)\\}", "$1");
            CDATASection cdata = document.createCDATASection(content);
            documentation.appendChild(cdata);
            annotation.appendChild(documentation);
            return annotation;
        }
        catch (Exception e) {
            throw new RuntimeException("class not found ", e);
        }
    }

    private static Element getListExtension(Document document, BeanTagAttributeInfo aInfo, String attrType) {
        String genericParam;
        Element complexType = document.createElement("xsd:complexType");
        Element simpleContent = document.createElement("xsd:complexContent");
        Element extension = document.createElement("xsd:extension");
        if (aInfo.getGenericType() instanceof ParameterizedType && ((ParameterizedType)aInfo.getGenericType()).getActualTypeArguments().length == 1 && (genericParam = ((ParameterizedType)aInfo.getGenericType()).getActualTypeArguments()[0].toString()).contains("org.kuali") && !genericParam.contains("<")) {
            extension.setAttribute("base", genericParam.substring(genericParam.indexOf("org.kuali")));
        }
        if (!extension.hasAttribute("base") && (attrType.equals("spring:mapType") || attrType.equals("spring:listOrSetType"))) {
            extension.setAttribute("base", attrType);
        }
        Element mergeAttribute = document.createElement("xsd:attribute");
        mergeAttribute.setAttribute("name", "merge");
        mergeAttribute.setAttribute("type", "xsd:boolean");
        extension.appendChild(mergeAttribute);
        simpleContent.appendChild(extension);
        complexType.appendChild(simpleContent);
        if (extension.hasAttribute("base")) {
            return complexType;
        }
        return null;
    }

    private static void loadCustomTagClasses(String file) {
        ArrayList<String> classes = CustomTagAnnotations.getClassList(file);
        customTagClasses = new ArrayList();
        for (int i = 0; i < classes.size(); ++i) {
            try {
                customTagClasses.add(Class.forName(classes.get(i).trim()));
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)("Class not Found : " + classes.get(i)), (Throwable)e);
            }
        }
    }

    private static void loadAttributeProperties(String tagName, Class<?> tagClass) {
        HashMap<String, BeanTagAttributeInfo> entries = new HashMap<String, BeanTagAttributeInfo>();
        entries.putAll(CustomTagAnnotations.getAttributes(tagClass));
        attributeProperties.put(tagName, entries);
    }

    private static Map<String, BeanTagAttributeInfo> getAttributes(Class<?> tagClass) {
        HashMap<String, BeanTagAttributeInfo> entries = new HashMap<String, BeanTagAttributeInfo>();
        try {
            Method[] methods = tagClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                BeanTagAttribute attribute = methods[i].getAnnotation(BeanTagAttribute.class);
                if (attribute == null) continue;
                BeanTagAttributeInfo info = new BeanTagAttributeInfo();
                info.setName(CustomTagAnnotations.getFieldName(methods[i].getName()));
                info.setType(attribute.type());
                info.setValueType(methods[i].getReturnType());
                info.setGenericType(methods[i].getGenericReturnType());
                CustomTagAnnotations.validateBeanAttributes(tagClass.getName(), attribute.name(), entries);
                entries.put(attribute.name(), info);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return entries;
    }

    private static void loadBeanTags() {
        if (customTagClasses == null) {
            CustomTagAnnotations.loadCustomTagClasses();
        }
        beanTags = new HashMap<String, BeanTagInfo>();
        attributeProperties = new HashMap<String, Map<String, BeanTagAttributeInfo>>();
        for (int i = 0; i < customTagClasses.size(); ++i) {
            BeanTag[] annotations = new BeanTag[1];
            BeanTag tag = customTagClasses.get(i).getAnnotation(BeanTag.class);
            if (tag != null) {
                annotations[0] = tag;
            } else {
                BeanTags tags = customTagClasses.get(i).getAnnotation(BeanTags.class);
                if (tags == null) continue;
                annotations = tags.value();
            }
            for (int j = 0; j < annotations.length; ++j) {
                BeanTag annotation = annotations[j];
                BeanTagInfo info = new BeanTagInfo();
                info.setTag(annotation.name());
                if (j == 0) {
                    info.setDefaultTag(true);
                }
                info.setBeanClass(customTagClasses.get(i));
                info.setParent(annotation.parent());
                CustomTagAnnotations.validateBeanTags(annotation.name());
                beanTags.put(annotation.name(), info);
                CustomTagAnnotations.loadAttributeProperties(annotation.name(), customTagClasses.get(i));
            }
        }
    }

    private static String getFieldName(String methodName) {
        if (methodName.substring(0, 2).toLowerCase().compareTo("is") == 0) {
            String letter = methodName.substring(2, 3);
            return letter.toLowerCase() + methodName.substring(3, methodName.length());
        }
        String letter = methodName.substring(3, 4);
        return letter.toLowerCase() + methodName.substring(4, methodName.length());
    }

    private static boolean validateBeanTags(String tagName) {
        boolean valid = true;
        String[] tags = new String[beanTags.keySet().size()];
        tags = beanTags.keySet().toArray(tags);
        for (int j = 0; j < tags.length; ++j) {
            if (tagName.compareTo(tags[j]) != 0) continue;
            LOG.error((Object)("Duplicate tag name " + tagName));
            valid = false;
        }
        return valid;
    }

    private static boolean validateBeanAttributes(String className, String tagName, Map<String, BeanTagAttributeInfo> attributes) {
        boolean valid = true;
        if (tagName.compareTo("parent") == 0 || tagName.compareTo("ref") == 0 || tagName.compareTo("abstract") == 0) {
            return false;
        }
        String[] tags = new String[attributes.keySet().size()];
        tags = attributes.keySet().toArray(tags);
        for (int j = 0; j < tags.length; ++j) {
            if (tagName.compareTo(tags[j]) != 0) continue;
            LOG.error((Object)("Duplicate attribute tag name " + tagName + " in bean " + className));
            valid = false;
        }
        return valid;
    }

    public static Map<String, BeanTagInfo> getBeanTags() {
        if (beanTags == null) {
            CustomTagAnnotations.loadBeanTags();
        }
        if (beanTags.isEmpty()) {
            CustomTagAnnotations.loadBeanTags();
        }
        return beanTags;
    }

    public static Map<String, BeanTagInfo> getBeanTags(String file) {
        if (customTagClasses == null) {
            CustomTagAnnotations.loadCustomTagClasses(file);
        }
        if (beanTags == null) {
            CustomTagAnnotations.loadBeanTags();
        }
        if (beanTags.isEmpty()) {
            CustomTagAnnotations.loadBeanTags();
        }
        return beanTags;
    }

    public static Map<String, Map<String, BeanTagAttributeInfo>> getAttributeProperties() {
        if (attributeProperties == null) {
            CustomTagAnnotations.loadBeanTags();
        }
        if (attributeProperties.isEmpty()) {
            CustomTagAnnotations.loadBeanTags();
        }
        return attributeProperties;
    }

    private static ArrayList<String> getClassList(String path) {
        ArrayList<String> completeList = new ArrayList<String>();
        try {
            int i;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            ClassPathXmlApplicationContext app = new ClassPathXmlApplicationContext();
            InputStream stream = app.getResource(path).getInputStream();
            Document document = builder.parse(stream);
            NodeList classes = document.getElementsByTagName("class");
            String classList = "";
            for (int i2 = 0; i2 < classes.getLength(); ++i2) {
                classList = classList + classes.item(i2).getTextContent() + ",";
            }
            if (classList.length() > 0) {
                if (classList.charAt(classList.length() - 1) == ',') {
                    classList = classList.substring(0, classList.length() - 1);
                }
                String[] list = classList.split(",");
                for (i = 0; i < list.length; ++i) {
                    completeList.add(list[i]);
                }
            }
            NodeList includes = document.getElementsByTagName("include");
            for (i = 0; i < includes.getLength(); ++i) {
                completeList.addAll(CustomTagAnnotations.getClassList(includes.item(i).getTextContent()));
            }
        }
        catch (Exception e) {
            try {
                int i;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                File file = new File(path);
                Document document = builder.parse(file);
                NodeList classes = document.getElementsByTagName("class");
                String classList = "";
                for (int i3 = 0; i3 < classes.getLength(); ++i3) {
                    classList = classList + classes.item(i3).getTextContent() + ",";
                }
                if (classList.length() > 0) {
                    if (classList.charAt(classList.length() - 1) == ',') {
                        classList = classList.substring(0, classList.length() - 1);
                    }
                    String[] list = classList.split(",");
                    for (i = 0; i < list.length; ++i) {
                        completeList.add(list[i]);
                    }
                }
                NodeList includes = document.getElementsByTagName("include");
                for (i = 0; i < includes.getLength(); ++i) {
                    completeList.addAll(CustomTagAnnotations.getClassList(includes.item(i).getTextContent()));
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return completeList;
    }
}

