/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.state;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.datadictionary.state.StateMapping;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;

@BeanTags(value={@BeanTag(name="stateMapping-bean", parent="StateMapping"), @BeanTag(name="workflowStateMapping-bean", parent="workflowStateMapping")})
public class StateMappingBase
implements StateMapping {
    private Map<String, String> stateNameMessageKeyMap;
    private List<String> states;
    private String statePropertyName;
    private Map<String, String> customClientSideValidationStates;

    @Override
    public String getStateNameMessage(String state) {
        String message = null;
        if (StringUtils.isNotBlank((String)state) && this.getStates().contains(state)) {
            if (this.getStateNameMessageKeyMap() != null) {
                ConfigurationService configService = CoreApiServiceLocator.getKualiConfigurationService();
                String key = this.getStateNameMessageKeyMap().get(state);
                message = configService.getPropertyValueAsString(key);
            }
            if (message == null) {
                message = state;
            }
        }
        return message;
    }

    @Override
    public String getCurrentState(Object object) {
        return (String)ObjectPropertyUtils.getPropertyValue(object, this.getStatePropertyName());
    }

    @Override
    public String getNextState(Object object) {
        int currentStateIndex = this.getStates().indexOf(this.getCurrentState(object));
        if (currentStateIndex != -1) {
            int index = currentStateIndex + 1;
            if (index == this.getStates().size()) {
                return this.getCurrentState(object);
            }
            return this.getStates().get(index);
        }
        return this.getCurrentState(object);
    }

    @Override
    @BeanTagAttribute(name="stateNameMessageKeyMap", type=BeanTagAttribute.AttributeType.MAPVALUE)
    public Map<String, String> getStateNameMessageKeyMap() {
        return this.stateNameMessageKeyMap;
    }

    @Override
    public void setStateNameMessageKeyMap(Map<String, String> stateNameMessageKeyMap) {
        this.stateNameMessageKeyMap = stateNameMessageKeyMap;
    }

    @Override
    @BeanTagAttribute(name="states", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getStates() {
        if (this.states == null) {
            this.states = new ArrayList<String>();
        }
        return this.states;
    }

    @Override
    public void setStates(List<String> states) {
        this.states = states;
    }

    @Override
    @BeanTagAttribute(name="statePropertyName")
    public String getStatePropertyName() {
        return this.statePropertyName;
    }

    @Override
    public void setStatePropertyName(String statePropertyName) {
        this.statePropertyName = statePropertyName;
    }

    @Override
    @BeanTagAttribute(name="customClientSideValidationStates", type=BeanTagAttribute.AttributeType.MAPVALUE)
    public Map<String, String> getCustomClientSideValidationStates() {
        return this.customClientSideValidationStates;
    }

    @Override
    public void setCustomClientSideValidationStates(Map<String, String> customClientSideValidationStates) {
        this.customClientSideValidationStates = customClientSideValidationStates;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        String[] currentValues;
        tracer.addBean("StateMappingBase", this.getStatePropertyName());
        if (this.getStatePropertyName() == null) {
            currentValues = new String[]{"statePropertyName = null"};
            tracer.createWarning("The State Property Name must be set", currentValues);
        }
        if (this.getStates() == null) {
            currentValues = new String[]{"states = null"};
            tracer.createWarning("States should be set", currentValues);
        }
    }
}

