/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.uif;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.krad.datadictionary.DataDictionaryException;
import org.kuali.rice.krad.datadictionary.DefaultListableBeanFactory;
import org.kuali.rice.krad.datadictionary.uif.ViewTypeDictionaryIndex;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.service.ViewTypeService;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ViewModelUtils;
import org.kuali.rice.krad.uif.view.View;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;

public class UifDictionaryIndex
implements Runnable {
    private static final Log LOG = LogFactory.getLog(UifDictionaryIndex.class);
    private static final int VIEW_CACHE_SIZE = 1000;
    private DefaultListableBeanFactory ddBeans;
    private Map<String, String> viewBeanEntriesById;
    private Map<String, ViewTypeDictionaryIndex> viewEntriesByType;
    protected Map<String, View> viewCache = new HashMap<String, View>(1000);

    public UifDictionaryIndex(DefaultListableBeanFactory ddBeans) {
        this.ddBeans = ddBeans;
    }

    @Override
    public void run() {
        this.buildViewIndicies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View getViewById(String viewId) {
        View cachedView = this.viewCache.get(viewId);
        if (cachedView == null) {
            String beanName;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("View " + viewId + " not in cache - creating and storing to cache"));
            }
            if (StringUtils.isBlank((String)(beanName = this.viewBeanEntriesById.get(viewId)))) {
                throw new DataDictionaryException("Unable to find View with id: " + viewId);
            }
            View newView = (View)this.ddBeans.getBean(beanName, View.class);
            boolean inDevMode = ConfigContext.getCurrentContextConfig().getBooleanProperty("rice.krad.dev.mode");
            if (!inDevMode) {
                Map<String, View> map = this.viewCache;
                synchronized (map) {
                    this.viewCache.put(viewId, newView);
                }
            }
            cachedView = newView;
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Pulled view " + viewId + " from Cache.  Cloning..."));
        }
        View clonedView = ComponentUtils.copy(cachedView);
        return clonedView;
    }

    public View getImmutableViewById(String viewId) {
        View cachedView = this.viewCache.get(viewId);
        if (cachedView == null) {
            return this.getViewById(viewId);
        }
        return cachedView;
    }

    public View getViewByTypeIndex(UifConstants.ViewType viewTypeName, Map<String, String> indexKey) {
        String viewId = this.getViewIdByTypeIndex(viewTypeName, indexKey);
        if (StringUtils.isNotBlank((String)viewId)) {
            return this.getViewById(viewId);
        }
        return null;
    }

    public String getViewIdByTypeIndex(UifConstants.ViewType viewTypeName, Map<String, String> indexKey) {
        String index = this.buildTypeIndex(indexKey);
        ViewTypeDictionaryIndex typeIndex = this.getTypeIndex(viewTypeName);
        return typeIndex.get(index);
    }

    public boolean viewByTypeExist(UifConstants.ViewType viewTypeName, Map<String, String> indexKey) {
        boolean viewExist = false;
        String index = this.buildTypeIndex(indexKey);
        ViewTypeDictionaryIndex typeIndex = this.getTypeIndex(viewTypeName);
        String viewId = typeIndex.get(index);
        if (StringUtils.isNotBlank((String)viewId)) {
            viewExist = true;
        }
        return viewExist;
    }

    public PropertyValues getViewPropertiesById(String viewId) {
        String beanName = this.viewBeanEntriesById.get(viewId);
        if (StringUtils.isNotBlank((String)beanName)) {
            BeanDefinition beanDefinition = this.ddBeans.getMergedBeanDefinition(beanName);
            return beanDefinition.getPropertyValues();
        }
        return null;
    }

    public PropertyValues getViewPropertiesByType(UifConstants.ViewType viewTypeName, Map<String, String> indexKey) {
        String index = this.buildTypeIndex(indexKey);
        ViewTypeDictionaryIndex typeIndex = this.getTypeIndex(viewTypeName);
        String beanName = typeIndex.get(index);
        if (StringUtils.isNotBlank((String)beanName)) {
            BeanDefinition beanDefinition = this.ddBeans.getMergedBeanDefinition(beanName);
            return beanDefinition.getPropertyValues();
        }
        return null;
    }

    public List<View> getViewsForType(UifConstants.ViewType viewTypeName) {
        ArrayList<View> typeViews = new ArrayList<View>();
        if (this.viewEntriesByType.containsKey(viewTypeName.name())) {
            ViewTypeDictionaryIndex typeIndex = this.viewEntriesByType.get(viewTypeName.name());
            for (Map.Entry<String, String> typeEntry : typeIndex.getViewIndex().entrySet()) {
                View typeView = (View)this.ddBeans.getBean(typeEntry.getValue(), View.class);
                typeViews.add(typeView);
            }
        } else {
            throw new DataDictionaryException("Unable to find view index for type: " + (Object)((Object)viewTypeName));
        }
        return typeViews;
    }

    protected void buildViewIndicies() {
        String[] beanNames;
        LOG.info((Object)"Starting View Index Building");
        this.viewBeanEntriesById = new HashMap<String, String>();
        this.viewEntriesByType = new HashMap<String, ViewTypeDictionaryIndex>();
        for (String beanName : beanNames = this.ddBeans.getBeanNamesForType(View.class)) {
            BeanDefinition beanDefinition = this.ddBeans.getMergedBeanDefinition(beanName);
            MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
            String id = ViewModelUtils.getStringValFromPVs((PropertyValues)propertyValues, "id");
            if (StringUtils.isBlank((String)id)) {
                id = beanName;
            }
            if (this.viewBeanEntriesById.containsKey(id)) {
                throw new DataDictionaryException("Two views must not share the same id. Found duplicate id: " + id);
            }
            this.viewBeanEntriesById.put(id, beanName);
            this.indexViewForType((PropertyValues)propertyValues, id);
        }
        LOG.info((Object)"Completed View Index Building");
    }

    protected void indexViewForType(PropertyValues propertyValues, String id) {
        String viewTypeName = ViewModelUtils.getStringValFromPVs(propertyValues, "viewTypeName");
        if (StringUtils.isBlank((String)viewTypeName)) {
            return;
        }
        UifConstants.ViewType viewType = UifConstants.ViewType.valueOf(viewTypeName);
        ViewTypeService typeService = KRADServiceLocatorWeb.getViewService().getViewTypeService(viewType);
        if (typeService == null) {
            return;
        }
        Map<String, String> typeParameters = typeService.getParametersFromViewConfiguration(propertyValues);
        String index = this.buildTypeIndex(typeParameters);
        ViewTypeDictionaryIndex typeIndex = this.getTypeIndex(viewType);
        typeIndex.put(index, id);
    }

    protected ViewTypeDictionaryIndex getTypeIndex(UifConstants.ViewType viewType) {
        ViewTypeDictionaryIndex typeIndex = null;
        if (this.viewEntriesByType.containsKey(viewType.name())) {
            typeIndex = this.viewEntriesByType.get(viewType.name());
        } else {
            typeIndex = new ViewTypeDictionaryIndex();
            this.viewEntriesByType.put(viewType.name(), typeIndex);
        }
        return typeIndex;
    }

    protected String buildTypeIndex(Map<String, String> typeParameters) {
        String index = "";
        for (String parameterName : typeParameters.keySet()) {
            if (StringUtils.isNotBlank((String)index)) {
                index = index + "|||";
            }
            index = index + parameterName + "^^" + typeParameters.get(parameterName);
        }
        return index;
    }
}

