/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBean;
import org.kuali.rice.krad.datadictionary.validator.ErrorReport;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.springframework.core.io.ResourceLoader;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ValidationTrace {
    private static final Log LOG = LogFactory.getLog(ValidationTrace.class);
    public static final String NO_BEAN_ID = "NOBEANID";
    public static final int START_UP = 0;
    public static final int BUILD = 1;
    private ArrayList<String> beanIds = new ArrayList();
    private ArrayList<String> beanTypes = new ArrayList();
    private Map<String, Document> beanMap = new HashMap<String, Document>();
    private int validationStage;

    public ValidationTrace() {
    }

    public ValidationTrace(String[] files, ResourceLoader loader) {
        this.loadFiles(files, loader);
    }

    public void addBean(String beanType, String beanId) {
        this.beanIds.add(beanId);
        this.beanTypes.add(beanType);
    }

    public void addBean(Component component) {
        String beanId = NO_BEAN_ID;
        String beanType = component.getClass().getSimpleName();
        if (component.getId() != null) {
            if (component.getId().compareTo("null") != 0) {
                beanId = component.getId();
            } else {
                try {
                    beanId = ((DataBinding)((Object)component)).getPropertyName();
                }
                catch (Exception e) {
                    beanId = NO_BEAN_ID;
                }
            }
        } else {
            try {
                beanId = ((DataBinding)((Object)component)).getPropertyName();
            }
            catch (Exception e) {
                beanId = NO_BEAN_ID;
            }
        }
        this.addBean(beanType, beanId);
    }

    public void addBean(UifDictionaryBean configurable) {
        String beanId = "configurable";
        String beanType = configurable.getClass().getSimpleName();
        this.addBean(beanType, beanId);
    }

    public void removeBean(int index) {
        this.beanIds.remove(index);
        this.beanTypes.remove(index);
    }

    public void modifyBean(int index, String beanId, String beanType) {
        this.beanIds.set(index, beanId);
        this.beanTypes.set(index, beanType);
    }

    public ValidationTrace getCopy() {
        ValidationTrace copy = new ValidationTrace();
        for (int i = 0; i < this.getTraceSize(); ++i) {
            copy.addBean(this.getBeanType(i), this.getBeanId(i));
        }
        copy.setValidationStage(this.getValidationStage());
        copy.setBeanMap(this.beanMap);
        return copy;
    }

    private void loadFiles(String[] beanFiles, ResourceLoader loader) {
        LOG.debug((Object)"Started Loading Parser Files");
        for (int i = 0; i < beanFiles.length; ++i) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                String file = beanFiles[i];
                LOG.debug((Object)("Loading file: " + file));
                Document document = builder.parse(loader.getResource(file).getInputStream());
                this.beanMap.put(file, document);
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)("Not Found: " + beanFiles[i]));
            }
        }
        LOG.debug((Object)"Finished Loading Parser Files");
    }

    private Map<String, Document> findBeanById(String id, Map<String, Document> beans) {
        HashMap<String, Document> result = new HashMap<String, Document>();
        LOG.debug((Object)("Searching for bean of Id: " + id));
        for (Map.Entry<String, Document> entry : beans.entrySet()) {
            Document document = entry.getValue();
            NodeList nodes = document.getElementsByTagName("bean");
            block1: for (int i = 0; i < nodes.getLength(); ++i) {
                if (!nodes.item(i).hasAttributes()) continue;
                for (int j = 0; j < nodes.item(i).getAttributes().getLength(); ++j) {
                    if (nodes.item(i).getAttributes().item(j).getNodeValue().toLowerCase().compareTo(id.toLowerCase()) != 0) continue;
                    LOG.debug((Object)("Found bean of Id = " + id));
                    result.put(entry.getKey(), entry.getValue());
                    continue block1;
                }
            }
        }
        return result;
    }

    public ArrayList<String> findXmlFiles() {
        HashMap<String, Document> result = new HashMap<String, Document>();
        LOG.debug((Object)"Looking for Xml files");
        for (int i = 0; i < this.getTraceSize(); ++i) {
            if (this.getBeanId(i) == null || this.getBeanId(i).compareTo(NO_BEAN_ID) == 0) continue;
            result.putAll(this.findBeanById(this.getBeanId(i), this.beanMap));
        }
        ArrayList<String> files = new ArrayList<String>();
        for (Map.Entry entry : result.entrySet()) {
            files.add((String)entry.getKey());
        }
        return files;
    }

    public void setValidationStage(int stage) {
        this.validationStage = stage;
    }

    private void setBeanMap(Map<String, Document> newMap) {
        this.beanMap = newMap;
    }

    public void createError(String validation, String[] values) {
        ErrorReport report = new ErrorReport(1, validation, this, values);
        Validator.addErrorReport(report);
    }

    public void createWarning(String validation, String[] values) {
        ErrorReport report = new ErrorReport(2, validation, this, values);
        Validator.addErrorReport(report);
    }

    public String getBeanId(int index) {
        return this.beanIds.get(index);
    }

    public String getBeanType(int index) {
        return this.beanTypes.get(index);
    }

    public int getValidationStage() {
        return this.validationStage;
    }

    public int getTraceSize() {
        return this.beanIds.size();
    }

    public String getBeanLocation() {
        String path = "";
        for (int i = 0; i < this.beanTypes.size() - 1; ++i) {
            path = path + this.beanTypes.get(i) + "(" + this.beanIds.get(i) + ")" + ".";
        }
        if (this.getTraceSize() > 0) {
            path = path + this.beanTypes.get(this.beanTypes.size() - 1) + "(" + this.beanIds.get(this.beanTypes.size() - 1) + ")";
        }
        return path;
    }

    public ArrayList<String> getRelatedXmls() {
        return this.findXmlFiles();
    }
}

