/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.keyvalues;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KeyValuesService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PersistableBusinessObjectValuesFinder<T extends PersistableBusinessObject>
extends KeyValuesBase {
    private static final Log LOG = LogFactory.getLog(PersistableBusinessObjectValuesFinder.class);
    private Class<T> businessObjectClass;
    private String keyAttributeName;
    private String labelAttributeName;
    private boolean includeKeyInDescription = false;
    private boolean includeBlankRow = false;

    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> labels = new ArrayList<KeyValue>();
        try {
            KeyValuesService boService = KRADServiceLocator.getKeyValuesService();
            Collection objects = boService.findAll(this.businessObjectClass);
            if (this.includeBlankRow) {
                labels.add((KeyValue)new ConcreteKeyValue("", ""));
            }
            for (PersistableBusinessObject object : objects) {
                Object key = PropertyUtils.getProperty((Object)object, (String)this.keyAttributeName);
                String label = (String)PropertyUtils.getProperty((Object)object, (String)this.labelAttributeName);
                if (this.includeKeyInDescription) {
                    label = key + " - " + label;
                }
                labels.add((KeyValue)new ConcreteKeyValue(key.toString(), label));
            }
        }
        catch (IllegalAccessException e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            LOG.error((Object)e.getMessage());
            throw new RuntimeException("IllegalAccessException occurred while trying to build keyValues List. dataObjectClass: " + this.businessObjectClass + "; keyAttributeName: " + this.keyAttributeName + "; labelAttributeName: " + this.labelAttributeName + "; includeKeyInDescription: " + this.includeKeyInDescription, e);
        }
        catch (InvocationTargetException e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            LOG.error((Object)e.getMessage());
            throw new RuntimeException("InvocationTargetException occurred while trying to build keyValues List. dataObjectClass: " + this.businessObjectClass + "; keyAttributeName: " + this.keyAttributeName + "; labelAttributeName: " + this.labelAttributeName + "; includeKeyInDescription: " + this.includeKeyInDescription, e);
        }
        catch (NoSuchMethodException e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            LOG.error((Object)e.getMessage());
            throw new RuntimeException("NoSuchMethodException occurred while trying to build keyValues List. dataObjectClass: " + this.businessObjectClass + "; keyAttributeName: " + this.keyAttributeName + "; labelAttributeName: " + this.labelAttributeName + "; includeKeyInDescription: " + this.includeKeyInDescription, e);
        }
        return labels;
    }

    public Class<T> getBusinessObjectClass() {
        return this.businessObjectClass;
    }

    public void setBusinessObjectClass(Class<T> businessObjectClass) {
        this.businessObjectClass = businessObjectClass;
    }

    public boolean isIncludeKeyInDescription() {
        return this.includeKeyInDescription;
    }

    public void setIncludeKeyInDescription(boolean includeKeyInDescription) {
        this.includeKeyInDescription = includeKeyInDescription;
    }

    public String getKeyAttributeName() {
        return this.keyAttributeName;
    }

    public void setKeyAttributeName(String keyAttributeName) {
        this.keyAttributeName = keyAttributeName;
    }

    public String getLabelAttributeName() {
        return this.labelAttributeName;
    }

    public void setLabelAttributeName(String labelAttributeName) {
        this.labelAttributeName = labelAttributeName;
    }

    public boolean isIncludeBlankRow() {
        return this.includeBlankRow;
    }

    public void setIncludeBlankRow(boolean includeBlankRow) {
        this.includeBlankRow = includeBlankRow;
    }
}

