/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.maintenance;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.DocumentAttachment;
import org.kuali.rice.krad.bo.GlobalBusinessObject;
import org.kuali.rice.krad.bo.MultiDocumentAttachment;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.bo.PersistableAttachment;
import org.kuali.rice.krad.bo.PersistableAttachmentList;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.datadictionary.MaintenanceDocumentEntry;
import org.kuali.rice.krad.datadictionary.WorkflowAttributes;
import org.kuali.rice.krad.datadictionary.WorkflowProperties;
import org.kuali.rice.krad.document.DocumentBase;
import org.kuali.rice.krad.document.SessionDocument;
import org.kuali.rice.krad.exception.PessimisticLockingException;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.maintenance.Maintainable;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.maintenance.MaintenanceUtils;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.rice.krad.service.DocumentDictionaryService;
import org.kuali.rice.krad.service.DocumentHeaderService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.MaintenanceDocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.NoteType;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.util.documentserializer.PropertySerializabilityEvaluator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Entity
@Table(name="KRNS_MAINT_DOC_T")
public class MaintenanceDocumentBase
extends DocumentBase
implements MaintenanceDocument,
SessionDocument {
    private static final long serialVersionUID = -505085142412593305L;
    private static final Logger LOG = Logger.getLogger(MaintenanceDocumentBase.class);
    public static final String MAINTAINABLE_IMPL_CLASS = "maintainableImplClass";
    public static final String OLD_MAINTAINABLE_TAG_NAME = "oldMaintainableObject";
    public static final String NEW_MAINTAINABLE_TAG_NAME = "newMaintainableObject";
    public static final String MAINTENANCE_ACTION_TAG_NAME = "maintenanceAction";
    public static final String NOTES_TAG_NAME = "notes";
    @Transient
    private static transient DocumentDictionaryService documentDictionaryService;
    @Transient
    private static transient MaintenanceDocumentService maintenanceDocumentService;
    @Transient
    private static transient DocumentHeaderService documentHeaderService;
    @Transient
    private static transient DocumentService documentService;
    @Transient
    protected Maintainable oldMaintainableObject;
    @Transient
    protected Maintainable newMaintainableObject;
    @Column(name="DOC_CNTNT", length=4096)
    protected String xmlDocumentContents;
    @Transient
    protected boolean fieldsClearedOnCopy = false;
    @Transient
    protected boolean displayTopicFieldInNotes = false;
    @Transient
    protected String attachmentPropertyName;
    @Transient
    protected String attachmentListPropertyName;
    @Transient
    protected String attachmentCollectionName;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE})
    @JoinColumn(name="DOC_HDR_ID", insertable=false, updatable=false)
    protected DocumentAttachment attachment;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE})
    @JoinColumn(name="DOC_HDR_ID", insertable=false, updatable=false)
    protected List<MultiDocumentAttachment> attachments;

    public MaintenanceDocumentBase() {
    }

    public MaintenanceDocumentBase(String documentTypeName) {
        this();
        Class<? extends Maintainable> clazz = this.getDocumentDictionaryService().getMaintainableClass(documentTypeName);
        try {
            this.oldMaintainableObject = clazz.newInstance();
            this.newMaintainableObject = clazz.newInstance();
            Class<?> dataObjectClazz = this.getDocumentDictionaryService().getMaintenanceDataObjectClass(documentTypeName);
            this.oldMaintainableObject.setDataObject(dataObjectClazz.newInstance());
            this.oldMaintainableObject.setDataObjectClass(dataObjectClazz);
            this.newMaintainableObject.setDataObject(dataObjectClazz.newInstance());
            this.newMaintainableObject.setDataObjectClass(dataObjectClazz);
        }
        catch (InstantiationException e) {
            LOG.error((Object)("Unable to initialize maintainables of type " + clazz.getName()));
            throw new RuntimeException("Unable to initialize maintainables of type " + clazz.getName());
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)("Unable to initialize maintainables of type " + clazz.getName()));
            throw new RuntimeException("Unable to initialize maintainables of type " + clazz.getName());
        }
    }

    @Override
    public String getDocumentTitle() {
        String documentTitle = "";
        documentTitle = this.newMaintainableObject.getDocumentTitle(this);
        if (StringUtils.isNotBlank((String)documentTitle)) {
            return documentTitle;
        }
        String className = this.newMaintainableObject.getDataObject().getClass().getName();
        String truncatedClassName = className.substring(className.lastIndexOf(46) + 1);
        documentTitle = this.isOldDataObjectInDocument() ? "Edit " : "New ";
        documentTitle = documentTitle + truncatedClassName + " - ";
        documentTitle = documentTitle + this.getDocumentHeader().getDocumentDescription() + " ";
        return documentTitle;
    }

    protected boolean isOldMaintainableInDocument(Document xmlDocument) {
        boolean isOldMaintainableInExistence = false;
        if (xmlDocument.getElementsByTagName(OLD_MAINTAINABLE_TAG_NAME).getLength() > 0) {
            isOldMaintainableInExistence = true;
        }
        return isOldMaintainableInExistence;
    }

    @Override
    public boolean isOldDataObjectInDocument() {
        boolean isOldBusinessObjectInExistence = false;
        isOldBusinessObjectInExistence = this.oldMaintainableObject == null || this.oldMaintainableObject.getDataObject() == null ? false : this.oldMaintainableObject.isOldDataObjectInDocument();
        return isOldBusinessObjectInExistence;
    }

    @Override
    public boolean isNew() {
        return MaintenanceUtils.isMaintenanceDocumentCreatingNewRecord(this.newMaintainableObject.getMaintenanceAction());
    }

    @Override
    public boolean isEdit() {
        return "Edit".equalsIgnoreCase(this.newMaintainableObject.getMaintenanceAction());
    }

    @Override
    public boolean isNewWithExisting() {
        return "newWithExisting".equalsIgnoreCase(this.newMaintainableObject.getMaintenanceAction());
    }

    @Override
    public void populateMaintainablesFromXmlDocumentContents() {
        if (!StringUtils.isEmpty((String)this.xmlDocumentContents)) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document xmlDocument = builder.parse(new InputSource(new StringReader(this.xmlDocumentContents)));
                String clazz = xmlDocument.getDocumentElement().getAttribute(MAINTAINABLE_IMPL_CLASS);
                if (this.isOldMaintainableInDocument(xmlDocument)) {
                    this.oldMaintainableObject = (Maintainable)Class.forName(clazz).newInstance();
                    Object dataObject = this.getDataObjectFromXML(OLD_MAINTAINABLE_TAG_NAME);
                    String oldMaintenanceAction = this.getMaintenanceAction(xmlDocument, OLD_MAINTAINABLE_TAG_NAME);
                    this.oldMaintainableObject.setMaintenanceAction(oldMaintenanceAction);
                    this.oldMaintainableObject.setDataObject(dataObject);
                    this.oldMaintainableObject.setDataObjectClass(dataObject.getClass());
                }
                this.newMaintainableObject = (Maintainable)Class.forName(clazz).newInstance();
                Object bo = this.getDataObjectFromXML(NEW_MAINTAINABLE_TAG_NAME);
                this.newMaintainableObject.setDataObject(bo);
                this.newMaintainableObject.setDataObjectClass(bo.getClass());
                String newMaintenanceAction = this.getMaintenanceAction(xmlDocument, NEW_MAINTAINABLE_TAG_NAME);
                this.newMaintainableObject.setMaintenanceAction(newMaintenanceAction);
                if (this.newMaintainableObject.isNotesEnabled()) {
                    List<Note> notes = this.getNotesFromXml(NOTES_TAG_NAME);
                    this.setNotes(notes);
                }
            }
            catch (ParserConfigurationException e) {
                LOG.error((Object)"Error while parsing document contents", (Throwable)e);
                throw new RuntimeException("Could not load document contents from xml", e);
            }
            catch (SAXException e) {
                LOG.error((Object)"Error while parsing document contents", (Throwable)e);
                throw new RuntimeException("Could not load document contents from xml", e);
            }
            catch (IOException e) {
                LOG.error((Object)"Error while parsing document contents", (Throwable)e);
                throw new RuntimeException("Could not load document contents from xml", e);
            }
            catch (InstantiationException e) {
                LOG.error((Object)"Error while parsing document contents", (Throwable)e);
                throw new RuntimeException("Could not load document contents from xml", e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)"Error while parsing document contents", (Throwable)e);
                throw new RuntimeException("Could not load document contents from xml", e);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)"Error while parsing document contents", (Throwable)e);
                throw new RuntimeException("Could not load document contents from xml", e);
            }
        }
    }

    protected String getMaintenanceAction(Document xmlDocument, String oldOrNewElementName) {
        if (StringUtils.isBlank((String)oldOrNewElementName)) {
            throw new IllegalArgumentException("oldOrNewElementName may not be blank, null, or empty-string.");
        }
        String maintenanceAction = null;
        NodeList rootChildren = xmlDocument.getDocumentElement().getChildNodes();
        for (int i = 0; i < rootChildren.getLength(); ++i) {
            Node rootChild = rootChildren.item(i);
            if (!oldOrNewElementName.equalsIgnoreCase(rootChild.getNodeName())) continue;
            NodeList maintChildren = rootChild.getChildNodes();
            for (int j = 0; j < maintChildren.getLength(); ++j) {
                Node maintChild = maintChildren.item(j);
                if (!MAINTENANCE_ACTION_TAG_NAME.equalsIgnoreCase(maintChild.getNodeName())) continue;
                maintenanceAction = maintChild.getChildNodes().item(0).getNodeValue();
            }
        }
        return maintenanceAction;
    }

    private List<Note> getNotesFromXml(String notesTagName) {
        String notesXml = StringUtils.substringBetween((String)this.xmlDocumentContents, (String)("<" + notesTagName + ">"), (String)("</" + notesTagName + ">"));
        if (StringUtils.isBlank((String)notesXml)) {
            return Collections.emptyList();
        }
        List notes = (List)KRADServiceLocator.getXmlObjectSerializerService().fromXml(notesXml);
        if (notes == null) {
            return Collections.emptyList();
        }
        return notes;
    }

    protected Object getDataObjectFromXML(String maintainableTagName) {
        String maintXml = StringUtils.substringBetween((String)this.xmlDocumentContents, (String)("<" + maintainableTagName + ">"), (String)("</" + maintainableTagName + ">"));
        boolean ignoreMissingFields = false;
        String classAndDocTypeNames = ConfigContext.getCurrentContextConfig().getProperty("rice.krad.bos.ignoreMissingFieldsOnDeserialize");
        if (!StringUtils.isEmpty((String)classAndDocTypeNames)) {
            String classNameOnXML = StringUtils.substringBetween((String)this.xmlDocumentContents, (String)("<" + maintainableTagName + "><"), (String)">");
            String classNamesNoSpaces = this.removeSpacesAround(classAndDocTypeNames);
            List<String> classAndDocTypeNamesList = Arrays.asList(StringUtils.split((String)classNamesNoSpaces, (String)","));
            String originalDocTypeId = this.getDocumentHeader().getWorkflowDocument().getDocumentTypeId();
            DocumentType docType = KewApiServiceLocator.getDocumentTypeService().getDocumentTypeById(originalDocTypeId);
            while (docType != null && !ignoreMissingFields) {
                for (String classNameOrDocTypeName : classAndDocTypeNamesList) {
                    if (!docType.getName().equalsIgnoreCase(classNameOrDocTypeName) && !classNameOnXML.equalsIgnoreCase(classNameOrDocTypeName)) continue;
                    ignoreMissingFields = true;
                    break;
                }
                if (!StringUtils.isEmpty((String)docType.getParentId())) {
                    docType = KewApiServiceLocator.getDocumentTypeService().getDocumentTypeById(docType.getParentId());
                    continue;
                }
                docType = null;
            }
        }
        if (!ignoreMissingFields) {
            return KRADServiceLocator.getXmlObjectSerializerService().fromXml(maintXml);
        }
        return KRADServiceLocator.getXmlObjectSerializerIgnoreMissingFieldsService().fromXml(maintXml);
    }

    private String removeSpacesAround(String csv) {
        if (csv == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (String value : csv.split(",")) {
            if ("".equals(value.trim())) continue;
            result.append(value.trim());
            result.append(",");
        }
        int i = result.lastIndexOf(",");
        if (i != -1) {
            result.deleteCharAt(i);
        }
        return result.toString();
    }

    @Override
    public void populateXmlDocumentContentsFromMaintainables() {
        StringBuilder docContentBuffer = new StringBuilder();
        docContentBuffer.append("<maintainableDocumentContents maintainableImplClass=\"").append(this.newMaintainableObject.getClass().getName()).append("\">");
        if (this.getNewMaintainableObject().isNotesEnabled()) {
            docContentBuffer.append("<notes>");
            ArrayList<Note> noteList = new ArrayList<Note>();
            for (Note note : this.getNotes()) {
                noteList.add(note);
            }
            docContentBuffer.append(KRADServiceLocator.getXmlObjectSerializerService().toXml(noteList));
            docContentBuffer.append("</notes>");
        }
        if (this.oldMaintainableObject != null && this.oldMaintainableObject.getDataObject() != null) {
            docContentBuffer.append("<oldMaintainableObject>");
            Object oldBo = this.oldMaintainableObject.getDataObject();
            if (oldBo instanceof PersistableBusinessObject) {
                ObjectUtils.materializeAllSubObjects((PersistableBusinessObject)oldBo);
            }
            docContentBuffer.append(KRADServiceLocator.getBusinessObjectSerializerService().serializeBusinessObjectToXml(oldBo));
            docContentBuffer.append("<maintenanceAction>");
            docContentBuffer.append(this.oldMaintainableObject.getMaintenanceAction());
            docContentBuffer.append("</maintenanceAction>\n");
            docContentBuffer.append("</oldMaintainableObject>");
        }
        docContentBuffer.append("<newMaintainableObject>");
        Object newBo = this.newMaintainableObject.getDataObject();
        if (newBo instanceof PersistableBusinessObject) {
            ObjectUtils.materializeAllSubObjects((PersistableBusinessObject)newBo);
        }
        docContentBuffer.append(KRADServiceLocator.getBusinessObjectSerializerService().serializeBusinessObjectToXml(newBo));
        docContentBuffer.append("<maintenanceAction>");
        docContentBuffer.append(this.newMaintainableObject.getMaintenanceAction());
        docContentBuffer.append("</maintenanceAction>\n");
        docContentBuffer.append("</newMaintainableObject>");
        docContentBuffer.append("</maintainableDocumentContents>");
        this.xmlDocumentContents = docContentBuffer.toString();
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        String documentNumber;
        super.doRouteStatusChange(statusChangeEvent);
        WorkflowDocument workflowDocument = this.getDocumentHeader().getWorkflowDocument();
        this.getNewMaintainableObject().doRouteStatusChange(this.getDocumentHeader());
        if (workflowDocument.isProcessed()) {
            documentNumber = this.getDocumentHeader().getDocumentNumber();
            this.newMaintainableObject.setDocumentNumber(documentNumber);
            if (this.newMaintainableObject.getDataObject() instanceof PersistableAttachment) {
                this.populateAttachmentBeforeSave();
            }
            if (this.newMaintainableObject.getDataObject() instanceof PersistableAttachmentList) {
                this.populateBoAttachmentListBeforeSave();
            }
            this.newMaintainableObject.saveDataObject();
            if (!this.getDocumentService().saveDocumentNotes(this)) {
                throw new IllegalStateException("Failed to save document notes, this means that the note target was not ready for notes to be attached when it should have been.");
            }
            this.deleteDocumentAttachment();
            this.deleteDocumentAttachmentList();
            this.getMaintenanceDocumentService().deleteLocks(documentNumber);
            if (this.checkAllowsRecordDeletion() && this.checkMaintenanceAction() && this.checkDeletePermission(this.newMaintainableObject.getDataObject())) {
                this.newMaintainableObject.deleteDataObject();
            }
        }
        if (workflowDocument.isCanceled() || workflowDocument.isDisapproved() || workflowDocument.isRecalled() || workflowDocument.isException()) {
            this.deleteDocumentAttachment();
            this.deleteDocumentAttachmentList();
            documentNumber = this.getDocumentHeader().getDocumentNumber();
            this.getMaintenanceDocumentService().deleteLocks(documentNumber);
        }
    }

    @Override
    public List<String> getWorkflowEngineDocumentIdsToLock() {
        if (this.newMaintainableObject != null) {
            return this.newMaintainableObject.getWorkflowEngineDocumentIdsToLock();
        }
        return Collections.emptyList();
    }

    @Override
    public void prepareForSave() {
        if (this.newMaintainableObject != null) {
            this.newMaintainableObject.prepareForSave();
        }
    }

    @Override
    public void processAfterRetrieve() {
        super.processAfterRetrieve();
        this.populateMaintainablesFromXmlDocumentContents();
        if (this.oldMaintainableObject != null) {
            this.oldMaintainableObject.setDocumentNumber(this.documentNumber);
        }
        if (this.newMaintainableObject != null) {
            this.newMaintainableObject.setDocumentNumber(this.documentNumber);
            this.newMaintainableObject.processAfterRetrieve();
            if (this.newMaintainableObject.getDataObject() instanceof PersistableAttachment) {
                this.populateAttachmentForBO();
            }
            if (this.newMaintainableObject.getDataObject() instanceof PersistableAttachmentList) {
                this.populateAttachmentListForBO();
            }
            this.checkForLockingDocument(false);
        }
    }

    @Override
    public Maintainable getNewMaintainableObject() {
        return this.newMaintainableObject;
    }

    @Override
    public void setNewMaintainableObject(Maintainable newMaintainableObject) {
        this.newMaintainableObject = newMaintainableObject;
    }

    @Override
    public Maintainable getOldMaintainableObject() {
        return this.oldMaintainableObject;
    }

    @Override
    public void setOldMaintainableObject(Maintainable oldMaintainableObject) {
        this.oldMaintainableObject = oldMaintainableObject;
    }

    @Override
    public void setDocumentNumber(String documentNumber) {
        super.setDocumentNumber(documentNumber);
        this.oldMaintainableObject.setDocumentNumber(documentNumber);
        this.newMaintainableObject.setDocumentNumber(documentNumber);
    }

    @Override
    public final boolean isFieldsClearedOnCopy() {
        return this.fieldsClearedOnCopy;
    }

    @Override
    public final void setFieldsClearedOnCopy(boolean fieldsClearedOnCopy) {
        this.fieldsClearedOnCopy = fieldsClearedOnCopy;
    }

    @Override
    public String getXmlDocumentContents() {
        return this.xmlDocumentContents;
    }

    @Override
    public void setXmlDocumentContents(String xmlDocumentContents) {
        this.xmlDocumentContents = xmlDocumentContents;
    }

    @Override
    public boolean getAllowsCopy() {
        return this.getDocumentDictionaryService().getAllowsCopy(this);
    }

    @Override
    public boolean isDisplayTopicFieldInNotes() {
        return this.displayTopicFieldInNotes;
    }

    @Override
    public void setDisplayTopicFieldInNotes(boolean displayTopicFieldInNotes) {
        this.displayTopicFieldInNotes = displayTopicFieldInNotes;
    }

    @Override
    public String serializeDocumentToXml() {
        String tempXmlDocumentContents = this.xmlDocumentContents;
        this.xmlDocumentContents = null;
        String xmlForWorkflow = super.serializeDocumentToXml();
        this.xmlDocumentContents = tempXmlDocumentContents;
        return xmlForWorkflow;
    }

    @Override
    public void prepareForSave(KualiDocumentEvent event) {
        super.prepareForSave(event);
        if (this.newMaintainableObject.getDataObject() instanceof PersistableAttachment) {
            this.populateDocumentAttachment();
            this.populateAttachmentForBO();
            if (this.oldMaintainableObject.getDataObject() instanceof PersistableAttachment) {
                ((PersistableAttachment)this.oldMaintainableObject.getDataObject()).setAttachmentContent(null);
            }
        }
        if (this.newMaintainableObject.getDataObject() instanceof PersistableAttachmentList) {
            this.populateDocumentAttachmentList();
            this.populateAttachmentListForBO();
            if (this.oldMaintainableObject.getDataObject() instanceof PersistableAttachmentList) {
                for (PersistableAttachment pa : ((PersistableAttachmentList)this.oldMaintainableObject.getDataObject()).getAttachments()) {
                    pa.setAttachmentContent(null);
                }
            }
        }
        this.populateXmlDocumentContentsFromMaintainables();
    }

    protected void refreshAttachment() {
        if (ObjectUtils.isNull((Object)this.attachment)) {
            boolean isProxy;
            this.refreshReferenceObject("attachment");
            boolean bl = isProxy = this.attachment != null && ProxyHelper.isProxy((Object)((Object)this.attachment));
            if (isProxy && ProxyHelper.getRealObject((Object)((Object)this.attachment)) == null) {
                this.attachment = null;
            }
        }
    }

    protected void refreshAttachmentList() {
        if (ObjectUtils.isNull(this.attachments)) {
            boolean isProxy;
            this.refreshReferenceObject("attachments");
            boolean bl = isProxy = this.attachments != null && ProxyHelper.isProxy(this.attachments);
            if (isProxy && ProxyHelper.getRealObject(this.attachments) == null) {
                this.attachments = null;
            }
        }
    }

    public void populateAttachmentForBO() {
    }

    public void populateDocumentAttachment() {
    }

    public void populateAttachmentListForBO() {
    }

    public void populateAttachmentBeforeSave() {
    }

    public void populateDocumentAttachmentList() {
    }

    public void populateBoAttachmentListBeforeSave() {
    }

    public void deleteDocumentAttachment() {
        KRADServiceLocator.getBusinessObjectService().delete((PersistableBusinessObject)this.attachment);
        this.attachment = null;
    }

    public void deleteDocumentAttachmentList() {
        if (CollectionUtils.isNotEmpty(this.attachments)) {
            KRADServiceLocator.getBusinessObjectService().delete(this.attachments);
            this.attachments = null;
        }
    }

    @Override
    public void validateBusinessRules(KualiDocumentEvent event) {
        if (GlobalVariables.getMessageMap().hasErrors()) {
            this.logErrors();
            throw new ValidationException("errors occured before business rule");
        }
        this.checkForLockingDocument(true);
        if (this.newMaintainableObject != null && KRADServiceLocator.getPersistenceStructureService().isPersistable(this.newMaintainableObject.getDataObject().getClass())) {
            PersistableBusinessObject pbObject = KRADServiceLocator.getBusinessObjectService().retrieve((PersistableBusinessObject)this.newMaintainableObject.getDataObject());
            Long pbObjectVerNbr = ObjectUtils.isNull(pbObject) ? null : pbObject.getVersionNumber();
            Long newObjectVerNbr = ((PersistableBusinessObject)this.newMaintainableObject.getDataObject()).getVersionNumber();
            if (pbObjectVerNbr != null && !pbObjectVerNbr.equals(newObjectVerNbr)) {
                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.version.mismatch", new String[0]);
                throw new ValidationException("Version mismatch between the local business object and the database business object");
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("invoking rules engine on document " + this.getDocumentNumber()));
        }
        boolean isValid = true;
        isValid = KRADServiceLocatorWeb.getKualiRuleService().applyRules(event);
        if (!isValid) {
            this.logErrors();
            throw new ValidationException("business rule evaluation failed");
        }
        if (GlobalVariables.getMessageMap().hasErrors()) {
            this.logErrors();
            if (!(event instanceof SaveDocumentEvent)) {
                throw new ValidationException("Unreported errors occured during business rule evaluation (rule developer needs to put meaningful error messages into global ErrorMap)");
            }
        }
        LOG.debug((Object)"validation completed");
    }

    protected void checkForLockingDocument(boolean throwExceptionIfLocked) {
        MaintenanceUtils.checkForLockingDocument(this, throwExceptionIfLocked);
    }

    @Override
    public void postProcessSave(KualiDocumentEvent event) {
        PersistableBusinessObject bo;
        if (this.getNewMaintainableObject().getDataObject() instanceof PersistableBusinessObject && (bo = (PersistableBusinessObject)this.getNewMaintainableObject().getDataObject()) instanceof GlobalBusinessObject) {
            KRADServiceLocator.getBusinessObjectService().save(bo);
        }
        if (!(event instanceof SaveDocumentEvent)) {
            this.getMaintenanceDocumentService().deleteLocks(this.getDocumentNumber());
            this.getMaintenanceDocumentService().storeLocks(this.getNewMaintainableObject().generateMaintenanceLocks());
        }
    }

    @Override
    public Object getDocumentDataObject() {
        return this.getNewMaintainableObject().getDataObject();
    }

    @Override
    public PersistableBusinessObject getNoteTarget() {
        if (this.getNewMaintainableObject() == null) {
            throw new IllegalStateException("Failed to acquire the note target.  The new maintainable object on this document is null.");
        }
        if (this.getNewMaintainableObject().isNotesEnabled()) {
            return (PersistableBusinessObject)this.getDocumentDataObject();
        }
        return super.getNoteTarget();
    }

    @Override
    public NoteType getNoteType() {
        if (this.getNewMaintainableObject().isNotesEnabled()) {
            return NoteType.BUSINESS_OBJECT;
        }
        return super.getNoteType();
    }

    @Override
    public PropertySerializabilityEvaluator getDocumentPropertySerizabilityEvaluator() {
        String docTypeName = "";
        if (this.newMaintainableObject != null) {
            docTypeName = this.getDocumentDictionaryService().getMaintenanceDocumentTypeName(this.newMaintainableObject.getDataObjectClass());
        } else if (this.getDocumentHeader() != null && this.getDocumentHeader().getWorkflowDocument() != null) {
            docTypeName = this.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        }
        if (!StringUtils.isBlank((String)docTypeName)) {
            MaintenanceDocumentEntry documentEntry = this.getDocumentDictionaryService().getMaintenanceDocumentEntry(docTypeName);
            if (documentEntry != null) {
                WorkflowProperties workflowProperties = documentEntry.getWorkflowProperties();
                WorkflowAttributes workflowAttributes = documentEntry.getWorkflowAttributes();
                return this.createPropertySerializabilityEvaluator(workflowProperties, workflowAttributes);
            }
            LOG.error((Object)("Unable to obtain DD DocumentEntry for document type: '" + docTypeName + "'"));
        } else {
            LOG.error((Object)("Unable to obtain document type name for this document: " + this));
        }
        LOG.error((Object)"Returning null for the PropertySerializabilityEvaluator");
        return null;
    }

    public DocumentAttachment getAttachment() {
        return this.attachment;
    }

    public void setAttachment(DocumentAttachment attachment) {
        this.attachment = attachment;
    }

    public List<MultiDocumentAttachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<MultiDocumentAttachment> attachments) {
        this.attachments = attachments;
    }

    public String getAttachmentPropertyName() {
        return this.attachmentPropertyName;
    }

    public void setAttachmentPropertyName(String attachmentPropertyName) {
        this.attachmentPropertyName = attachmentPropertyName;
    }

    public String getAttachmentListPropertyName() {
        return this.attachmentListPropertyName;
    }

    public void setAttachmentListPropertyName(String attachmentListPropertyName) {
        this.attachmentListPropertyName = attachmentListPropertyName;
    }

    public String getAttachmentCollectionName() {
        return this.attachmentCollectionName;
    }

    public void setAttachmentCollectionName(String attachmentCollectionName) {
        this.attachmentCollectionName = attachmentCollectionName;
    }

    protected void postRemove() {
        super.postRemove();
        this.getDocumentHeaderService().deleteDocumentHeader(this.getDocumentHeader());
    }

    @Override
    protected void postLoad() {
        super.postLoad();
        this.setDocumentHeader(this.getDocumentHeaderService().getDocumentHeaderById(this.getDocumentNumber()));
    }

    protected void prePersist() {
        super.prePersist();
        this.getDocumentHeaderService().saveDocumentHeader(this.getDocumentHeader());
    }

    protected void preUpdate() {
        super.preUpdate();
        this.getDocumentHeaderService().saveDocumentHeader(this.getDocumentHeader());
    }

    public boolean isSessionDocument() {
        return SessionDocument.class.isAssignableFrom(this.getClass());
    }

    @Override
    public boolean useCustomLockDescriptors() {
        return this.newMaintainableObject != null && this.newMaintainableObject.useCustomLockDescriptors();
    }

    @Override
    public String getCustomLockDescriptor(Person user) {
        if (this.newMaintainableObject == null) {
            throw new PessimisticLockingException("Maintenance Document " + this.getDocumentNumber() + " is using pessimistic locking with custom lock descriptors, but no new maintainable object has been defined");
        }
        return this.newMaintainableObject.getCustomLockDescriptor(user);
    }

    protected DocumentDictionaryService getDocumentDictionaryService() {
        if (documentDictionaryService == null) {
            documentDictionaryService = KRADServiceLocatorWeb.getDocumentDictionaryService();
        }
        return documentDictionaryService;
    }

    protected MaintenanceDocumentService getMaintenanceDocumentService() {
        if (maintenanceDocumentService == null) {
            maintenanceDocumentService = KRADServiceLocatorWeb.getMaintenanceDocumentService();
        }
        return maintenanceDocumentService;
    }

    protected DocumentHeaderService getDocumentHeaderService() {
        if (documentHeaderService == null) {
            documentHeaderService = KRADServiceLocatorWeb.getDocumentHeaderService();
        }
        return documentHeaderService;
    }

    protected DocumentService getDocumentService() {
        if (documentService == null) {
            documentService = KRADServiceLocatorWeb.getDocumentService();
        }
        return documentService;
    }

    protected boolean checkAllowsRecordDeletion() {
        Boolean allowsRecordDeletion = KRADServiceLocatorWeb.getDocumentDictionaryService().getAllowsRecordDeletion(this.getNewMaintainableObject().getDataObjectClass());
        if (allowsRecordDeletion != null) {
            return allowsRecordDeletion;
        }
        return false;
    }

    protected boolean checkMaintenanceAction() {
        return this.getNewMaintainableObject().getMaintenanceAction().equals("Delete");
    }

    protected boolean checkDeletePermission(Object dataObject) {
        boolean allowsMaintain = false;
        String maintDocTypeName = KRADServiceLocatorWeb.getDocumentDictionaryService().getMaintenanceDocumentTypeName(dataObject.getClass());
        if (StringUtils.isNotBlank((String)maintDocTypeName)) {
            allowsMaintain = KRADServiceLocatorWeb.getDataObjectAuthorizationService().canMaintain(dataObject, GlobalVariables.getUserSession().getPerson(), maintDocTypeName);
        }
        return allowsMaintain;
    }
}

