/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.config.module.RunMode;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DataObjectMetaDataService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.service.impl.RemoteModuleServiceBase;
import org.kuali.rice.krad.util.UrlFactory;

public class ModuleServiceBase
extends RemoteModuleServiceBase
implements ModuleService {
    protected static final Logger LOG = Logger.getLogger(ModuleServiceBase.class);
    protected BusinessObjectService businessObjectService;
    protected DataObjectMetaDataService dataObjectMetaDataService;

    @Override
    public <T extends ExternalizableBusinessObject> T getExternalizableBusinessObject(Class<T> businessObjectClass, Map<String, Object> fieldValues) {
        Class<T> implementationClass = this.getExternalizableBusinessObjectImplementation(businessObjectClass);
        ExternalizableBusinessObject businessObject = (ExternalizableBusinessObject)this.getBusinessObjectService().findByPrimaryKey(implementationClass, fieldValues);
        return (T)businessObject;
    }

    @Override
    public <T extends ExternalizableBusinessObject> List<T> getExternalizableBusinessObjectsList(Class<T> externalizableBusinessObjectClass, Map<String, Object> fieldValues) {
        Class<T> implementationClass = this.getExternalizableBusinessObjectImplementation(externalizableBusinessObjectClass);
        return (List)this.getBusinessObjectService().findMatching(implementationClass, fieldValues);
    }

    @Override
    @Deprecated
    public String getExternalizableBusinessObjectInquiryUrl(Class inquiryBusinessObjectClass, Map<String, String[]> parameters) {
        if (!this.isExternalizable(inquiryBusinessObjectClass)) {
            return "";
        }
        Class implementationClass = this.getExternalizableBusinessObjectImplementation(inquiryBusinessObjectClass);
        if (implementationClass == null) {
            LOG.error((Object)("Can't find ExternalizableBusinessObject implementation class for " + inquiryBusinessObjectClass.getName()));
            throw new RuntimeException("Can't find ExternalizableBusinessObject implementation class for interface " + inquiryBusinessObjectClass.getName());
        }
        String businessObjectClassAttribute = implementationClass.getName();
        return UrlFactory.parameterizeUrl((String)this.getInquiryUrl(inquiryBusinessObjectClass), (Properties)this.getUrlParameters(businessObjectClassAttribute, parameters));
    }

    @Override
    @Deprecated
    protected String getInquiryUrl(Class inquiryBusinessObjectClass) {
        String riceBaseUrl = "";
        String potentialUrlAddition = "";
        if (this.goToCentralRiceForInquiry()) {
            riceBaseUrl = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("kr.url");
        } else {
            riceBaseUrl = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.url");
            potentialUrlAddition = "kr/";
        }
        String inquiryUrl = riceBaseUrl;
        if (!inquiryUrl.endsWith("/")) {
            inquiryUrl = inquiryUrl + "/";
        }
        return inquiryUrl + potentialUrlAddition + "inquiry.do";
    }

    @Override
    public boolean isExternalizableBusinessObjectLookupable(Class boClass) {
        return this.getDataObjectMetaDataService().hasLocalLookup(boClass);
    }

    @Override
    public boolean isExternalizableBusinessObjectInquirable(Class boClass) {
        return this.getDataObjectMetaDataService().hasLocalInquiry(boClass);
    }

    @Override
    @Deprecated
    public String getExternalizableBusinessObjectLookupUrl(Class inquiryBusinessObjectClass, Map<String, String> parameters) {
        Properties urlParameters = new Properties();
        String riceBaseUrl = "";
        String potentialUrlAddition = "";
        if (this.goToCentralRiceForInquiry()) {
            riceBaseUrl = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("kr.url");
        } else {
            riceBaseUrl = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.url");
            potentialUrlAddition = "kr/";
        }
        String lookupUrl = riceBaseUrl;
        if (!lookupUrl.endsWith("/")) {
            lookupUrl = lookupUrl + "/";
        }
        lookupUrl = parameters.containsKey("multipleValues") ? lookupUrl + potentialUrlAddition + "multipleValueLookup.do" : lookupUrl + potentialUrlAddition + "lookup.do";
        for (String paramName : parameters.keySet()) {
            urlParameters.put(paramName, parameters.get(paramName));
        }
        Class clazz = this.getExternalizableBusinessObjectImplementation(inquiryBusinessObjectClass);
        urlParameters.put("businessObjectClassName", clazz == null ? "" : clazz.getName());
        return UrlFactory.parameterizeUrl((String)lookupUrl, (Properties)urlParameters);
    }

    @Override
    public boolean goToCentralRiceForInquiry() {
        return false;
    }

    @Override
    protected String getBaseLookupUrl() {
        if (this.goToCentralRiceForInquiry()) {
            return RemoteModuleServiceBase.BaseLookupUrlsHolder.remoteKradBaseLookupUrl;
        }
        return RemoteModuleServiceBase.BaseLookupUrlsHolder.localKradBaseLookupUrl;
    }

    protected RunMode getRunMode(String module) {
        String propertyName = module + ".mode";
        String runMode = ConfigContext.getCurrentContextConfig().getProperty(propertyName);
        if (StringUtils.isBlank((String)runMode)) {
            throw new ConfigurationException("Failed to determine run mode for module '" + module + "'.  Please be sure to set configuration parameter '" + propertyName + "'");
        }
        return RunMode.valueOf((String)runMode.toUpperCase());
    }

    protected DataObjectMetaDataService getDataObjectMetaDataService() {
        if (this.dataObjectMetaDataService == null) {
            this.dataObjectMetaDataService = KRADServiceLocatorWeb.getDataObjectMetaDataService();
        }
        return this.dataObjectMetaDataService;
    }

    public void setDataObjectMetaDataService(DataObjectMetaDataService dataObjectMetaDataService) {
        this.dataObjectMetaDataService = dataObjectMetaDataService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KRADServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

